/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.config.InvConfig;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="inventoryhud")
public class InventoryGui
extends GuiIngame {
    private final RenderItem itemRenderer;
    private final FontRenderer fontRenderer;
    private final Minecraft minecraft;
    public static int invX;
    public static int invY;
    public static int potX;
    public static int potY;
    public static int armX;
    public static int armY;
    public static InvConfig.Orientation ArmOr;
    public static InvConfig.Orientation InvOr;
    public static InvConfig.PotOrientation PotOr;
    public static int potSide;
    public static int potIconSide;
    public static int potTextSide;
    public static int armAbove;
    public static float PotAlpha;
    public static boolean invTop;
    public static boolean potTop;
    public static boolean armTop;
    public static InvConfig.ArmorType armType;
    public static InvConfig.ArmorView armView;
    private static String[] armorRL;
    private static String[] dirs;
    private static String[] atlases;
    private final int[][] armorPosX = new int[][]{{-136, -136, 119, 119, 119, -136, 119}, {-119, -119, 94, 94, 94, -119, 94}};
    private final int[] armorPosY = new int[]{-56, -38, -56, -38, -74, -74, -20};
    private static final ResourceLocation PBG;

    private boolean isInAtlases(String mod) {
        for (String at : atlases) {
            if (!mod.equalsIgnoreCase(at)) continue;
            return true;
        }
        return false;
    }

    public static void syncConfig() {
        InventoryHUD.getConfig();
        invX = InvConfig.inv.xInvPos;
        InventoryHUD.getConfig();
        invY = InvConfig.inv.yInvPos;
        InventoryHUD.getConfig();
        potX = InvConfig.pot.xPotionPos;
        InventoryHUD.getConfig();
        potY = InvConfig.pot.yPotionPos;
        InventoryHUD.getConfig();
        armX = InvConfig.arm.xArmPos;
        InventoryHUD.getConfig();
        armY = InvConfig.arm.yArmPos;
        InventoryHUD.getConfig();
        InvOr = InvConfig.inv.invOr;
        InventoryHUD.getConfig();
        ArmOr = InvConfig.arm.armOr;
        InventoryHUD.getConfig();
        PotOr = InvConfig.pot.PotOrient;
        switch (PotOr) {
            case TOP_RIGHT: {
                potSide = -1;
                potIconSide = 36;
                potTextSide = -22;
                break;
            }
            case TOP_LEFT: {
                potSide = 1;
                potIconSide = 0;
                potTextSide = 0;
                break;
            }
            case BOTTOM_RIGHT: {
                potSide = -1;
                potIconSide = 36;
                potTextSide = -22;
                break;
            }
            case BOTTOM_LEFT: {
                potSide = 1;
                potIconSide = 0;
                potTextSide = 0;
            }
        }
        InventoryHUD.getConfig();
        armAbove = InvConfig.arm.armAbove;
        InventoryHUD.getConfig();
        PotAlpha = (float)InvConfig.pot.potAlpha / 100.0f;
        InventoryHUD.getConfig();
        armType = InvConfig.arm.armType;
        InventoryHUD.getConfig();
        armView = InvConfig.arm.armView;
    }

    public InventoryGui() {
        super(Minecraft.func_71410_x());
        this.minecraft = Minecraft.func_71410_x();
        this.itemRenderer = this.minecraft.func_175599_af();
        this.fontRenderer = this.minecraft.field_71466_p;
        InventoryGui.syncConfig();
    }

    @SubscribeEvent
    public void onPreRenderGui(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS && InventoryHUD.potionHUD) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        GuiIngameForge.renderExperiance = true;
        ScaledResolution scaled = new ScaledResolution(this.minecraft);
        int width = scaled.func_78326_a();
        int height = scaled.func_78328_b();
        if (InventoryHUD.armorHUD || InventoryHUD.potionHUD) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-90.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            if (InventoryHUD.armorHUD) {
                this.RenderArmorStatus(width, height);
            }
            if (InventoryHUD.potionHUD) {
                this.RenderPotions(width, height);
            }
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        if (!InventoryHUD.isActive) {
            return;
        }
        if (this.field_73839_d.field_71462_r instanceof GuiContainer) {
            return;
        }
        switch (InvOr) {
            case MIDDLE: {
                width = width / 2 - 81;
                height -= 126;
                break;
            }
            case TOP_LEFT: {
                width = invX;
                height = invY;
                break;
            }
            case TOP_RIGHT: {
                width = width - 162 - invX;
                height = invY;
                break;
            }
            case BOTTOM_LEFT: {
                width = invX;
                height = height - 54 - invY;
                break;
            }
            case BOTTOM_RIGHT: {
                width = width - 162 - invX;
                height = height - 54 - invY;
            }
        }
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 3; ++j) {
                RenderHelper.func_74519_b();
                RenderHelper.func_74520_c();
                ItemStack item = (ItemStack)this.field_73839_d.field_71439_g.field_71071_by.field_70462_a.get(i + (j + 1) * 9);
                this.itemRenderer.func_180450_b(item, width + i * 18, height + j * 18);
                this.itemRenderer.func_180453_a(this.fontRenderer, item, width + i * 18, height + j * 18, "");
                if (item.func_190916_E() > 1) {
                    this.itemRenderer.func_175030_a(this.fontRenderer, item, width + i * 18, height + j * 18);
                }
                RenderHelper.func_74518_a();
            }
        }
    }

    private void RenderArmorStatus(int width, int height) {
        switch (ArmOr) {
            case MIDDLE: {
                int i = 5;
                for (ItemStack item : this.field_73839_d.field_71439_g.func_184209_aF()) {
                    if (armType == InvConfig.ArmorType.ARMOR && i > 3) {
                        --i;
                        continue;
                    }
                    int Damage = ArmorStatus.GetDamage(item);
                    if (Damage >= 0 && Damage <= armAbove) {
                        String text = "";
                        int xp = width / 2 + this.armorPosX[1][i];
                        switch (armView) {
                            case PERCENTAGE: {
                                String p = String.valueOf(Damage);
                                text = this.getDamageText(p, Damage);
                                switch (i) {
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        xp += 18 - p.length() * 6;
                                    }
                                }
                                break;
                            }
                            case DAMAGE: {
                                String p = String.valueOf(item.func_77952_i());
                                text = this.getDamageText(p, Damage);
                                switch (i) {
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        xp += 23 - p.length() * 6;
                                    }
                                }
                                break;
                            }
                            case DAMAGE_LEFT: {
                                String p = String.valueOf(item.func_77958_k() - item.func_77952_i());
                                text = this.getDamageText(p, Damage);
                                switch (i) {
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        xp += 23 - p.length() * 6;
                                    }
                                }
                                break;
                            }
                        }
                        this.itemRenderer.func_180450_b(item, width / 2 + this.armorPosX[0][i], height + this.armorPosY[i]);
                        this.fontRenderer.func_175063_a(text, (float)xp, (float)(height + this.armorPosY[i] + 4), 0xFFFFFF);
                    } else {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        if (i == 5) {
                            this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation("inventoryhud", armorRL[i]));
                        } else {
                            this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation(armorRL[i]));
                        }
                        InventoryGui.func_146110_a((int)(width / 2 + this.armorPosX[0][i]), (int)(height + this.armorPosY[i]), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                    }
                    --i;
                }
                if (armType != InvConfig.ArmorType.FULL_AND_INV) break;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation("inventoryhud", armorRL[6]));
                InventoryGui.func_146110_a((int)(width / 2 + this.armorPosX[0][6]), (int)(height + this.armorPosY[6]), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                int count = 0;
                for (ItemStack slot : this.field_73839_d.field_71439_g.field_71071_by.field_70462_a) {
                    if (!slot.func_190926_b()) continue;
                    ++count;
                }
                this.fontRenderer.func_175063_a("" + count, (float)(width / 2 + this.armorPosX[1][6] + 23 - String.valueOf(count).length() * 6), (float)(height + this.armorPosY[6] + 4), 0xFFFFFF);
                break;
            }
            case TOP_LEFT: {
                this.RenderItems(armX, armY, false);
                break;
            }
            case TOP_RIGHT: {
                this.RenderItems(width - 16 - armX, armY, true);
                break;
            }
            case BOTTOM_LEFT: {
                this.RenderItems(armX, height - 72 - armY, false);
                break;
            }
            case BOTTOM_RIGHT: {
                this.RenderItems(width - 16 - armX, height - 72 - armY, true);
            }
        }
    }

    private void RenderItems(int xpos, int ypos, boolean right) {
        int i = 5;
        for (ItemStack item : this.field_73839_d.field_71439_g.func_184209_aF()) {
            if (armType == InvConfig.ArmorType.ARMOR && i > 3) {
                --i;
                continue;
            }
            int Damage = ArmorStatus.GetDamage(item);
            if (Damage >= 0 && Damage <= armAbove) {
                String text = "";
                int tLength = -17;
                switch (armView) {
                    case PERCENTAGE: {
                        String p = String.valueOf(Damage);
                        text = this.getDamageText(p, Damage);
                        if (!right) break;
                        tLength = (1 + p.length()) * 6 + 1;
                        break;
                    }
                    case DAMAGE: {
                        String p = String.valueOf(item.func_77952_i());
                        text = this.getDamageText(p, Damage);
                        if (!right) break;
                        tLength = p.length() * 6 + 1;
                        break;
                    }
                    case DAMAGE_LEFT: {
                        String p = String.valueOf(item.func_77958_k() - item.func_77952_i());
                        text = this.getDamageText(p, Damage);
                        if (!right) break;
                        tLength = p.length() * 6 + 1;
                        break;
                    }
                }
                int xOffset = 42;
                if (right) {
                    xOffset = -42;
                }
                if (i == 5) {
                    this.itemRenderer.func_180450_b(item, xpos + xOffset, ypos);
                    this.fontRenderer.func_175063_a(text, (float)(xpos - tLength + xOffset), (float)(ypos + 4), 0xFFFFFF);
                } else if (i == 4) {
                    this.itemRenderer.func_180450_b(item, xpos + xOffset, ypos + 18);
                    this.fontRenderer.func_175063_a(text, (float)(xpos - tLength + xOffset), (float)(ypos + 18 + 4), 0xFFFFFF);
                } else {
                    this.itemRenderer.func_180450_b(item, xpos, ypos + i * 18);
                    this.fontRenderer.func_175063_a(text, (float)(xpos - tLength), (float)(ypos + i * 18 + 4), 0xFFFFFF);
                }
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int xOffset = 42;
                if (right) {
                    xOffset = -42;
                }
                if (i == 5) {
                    this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation("inventoryhud", armorRL[i]));
                    InventoryGui.func_146110_a((int)(xpos + xOffset), (int)ypos, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                } else if (i == 4) {
                    this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation(armorRL[i]));
                    InventoryGui.func_146110_a((int)(xpos + xOffset), (int)(ypos + 18), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                } else {
                    this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation(armorRL[i]));
                    InventoryGui.func_146110_a((int)xpos, (int)(ypos + i * 18), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                }
            }
            --i;
        }
        if (armType == InvConfig.ArmorType.FULL_AND_INV) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int xOffset = 42;
            if (right) {
                xOffset = -42;
            }
            this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation("inventoryhud", armorRL[6]));
            InventoryGui.func_146110_a((int)(xpos + xOffset), (int)(ypos + 36), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            int count = 0;
            for (ItemStack slot : this.field_73839_d.field_71439_g.field_71071_by.field_70462_a) {
                if (!slot.func_190926_b()) continue;
                ++count;
            }
            int textOffset = -17;
            if (right) {
                textOffset = 1 + String.valueOf(count).length() * 6;
            }
            this.fontRenderer.func_175063_a("" + count, (float)(xpos + xOffset - textOffset), (float)(ypos + 40), 0xFFFFFF);
        }
    }

    private String getDamageText(String p, int d) {
        String result = p;
        if (d > 75) {
            result = TextFormatting.GREEN + result;
        } else if (d <= 10) {
            result = TextFormatting.RED + result;
        } else if (d <= 25) {
            result = TextFormatting.GOLD + result;
        }
        if (armView == InvConfig.ArmorView.PERCENTAGE) {
            result = result + TextFormatting.WHITE + "%";
        }
        return result;
    }

    private void RenderPotions(int width, int height) {
        int y = 0;
        int effCount = this.field_73839_d.field_71439_g.func_70651_bq().size();
        int xPos = 0;
        int yPos = 0;
        switch (PotOr) {
            case TOP_LEFT: {
                xPos = potX;
                yPos = potY;
                break;
            }
            case TOP_RIGHT: {
                xPos = width - 60 - potX;
                yPos = potY;
                break;
            }
            case BOTTOM_LEFT: {
                xPos = potX;
                yPos = height - effCount * 24 - potY;
                break;
            }
            case BOTTOM_RIGHT: {
                xPos = width - 60 - potX;
                yPos = height - effCount * 24 - potY;
            }
        }
        for (PotionEffect effect : this.field_73839_d.field_71439_g.func_70651_bq()) {
            Potion pot = effect.func_188419_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)PotAlpha);
            this.field_73839_d.func_110434_K().func_110577_a(PBG);
            InventoryGui.func_146110_a((int)xPos, (int)(yPos + y), (float)0.0f, (float)0.0f, (int)60, (int)24, (float)(60 * potSide), (float)24.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String path = pot.getRegistryName().func_110623_a();
            String domain = pot.getRegistryName().func_110624_b();
            if (domain == "minecraft") {
                int index = pot.func_76392_e();
                this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation("minecraft", "textures/gui/container/inventory.png"));
                InventoryGui.func_146110_a((int)(xPos + 3 + potIconSide), (int)(yPos + y + 3), (float)(index % 8 * 18), (float)(198 + index / 8 * 18), (int)18, (int)18, (float)256.0f, (float)256.0f);
            } else if (this.isInAtlases(domain)) {
                switch (domain) {
                    case "extraalchemy": {
                        int index = pot.func_76392_e();
                        this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation(domain, "textures/icons/potions_alt.png"));
                        InventoryGui.func_146110_a((int)(xPos + 3 + potIconSide), (int)(yPos + y + 3), (float)(index % 8 * 18), (float)(198 + index / 8 * 18), (int)18, (int)18, (float)256.0f, (float)256.0f);
                        break;
                    }
                    case "extrautils2": {
                        path = path.replace("effect.xu2.", "");
                        this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation(domain, "textures/potions/" + path + ".png"));
                        InventoryGui.func_146110_a((int)(xPos + 3 + potIconSide), (int)(yPos + y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
                        break;
                    }
                    case "botania": {
                        int index = 0;
                        switch (path) {
                            case "clear": {
                                index = 0;
                                break;
                            }
                            case "featherfeet": {
                                index = 1;
                                break;
                            }
                            case "bloodthirst": {
                                index = 3;
                                break;
                            }
                            case "emptiness": {
                                index = 2;
                                break;
                            }
                            case "allure": {
                                index = 5;
                                break;
                            }
                            case "soulcross": {
                                index = 0;
                            }
                        }
                        this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation(domain, "textures/gui/potions.png"));
                        InventoryGui.func_146110_a((int)(xPos + 3 + potIconSide), (int)(yPos + y + 3), (float)(index % 8 * 18), (float)(198 + index / 8 * 18), (int)18, (int)18, (float)256.0f, (float)256.0f);
                        break;
                    }
                    case "thaumcraft": 
                    case "bloodmagic": {
                        int index = pot.func_76392_e();
                        this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation(domain, "textures/misc/potions.png"));
                        InventoryGui.func_146110_a((int)(xPos + 3 + potIconSide), (int)(yPos + y + 3), (float)(index % 8 * 18), (float)(198 + index / 8 * 18), (int)18, (int)18, (float)256.0f, (float)256.0f);
                        break;
                    }
                    case "cyberware": {
                        int index = 0;
                        switch (path) {
                            case "rejection": {
                                index = 1;
                                break;
                            }
                            case "neuropozyne": {
                                index = 0;
                            }
                        }
                        this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation(domain, "textures/gui/potions.png"));
                        InventoryGui.func_146110_a((int)(xPos + 3 + potIconSide), (int)(yPos + y + 3), (float)(index % 8 * 18), (float)(198 + index / 8 * 18), (int)18, (int)18, (float)256.0f, (float)256.0f);
                        break;
                    }
                    case "resize": {
                        int index = pot.func_76392_e();
                        this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation(domain, "textures/potions/effects.png"));
                        InventoryGui.func_146110_a((int)(xPos + 3 + potIconSide), (int)(yPos + y + 3), (float)(index % 8 * 18), (float)(198 + index / 8 * 18), (int)18, (int)18, (float)256.0f, (float)256.0f);
                        break;
                    }
                    case "toughasnails": {
                        int index = pot.func_76392_e();
                        this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation(domain, "textures/potions/tan_potion_fx.png"));
                        InventoryGui.func_146110_a((int)(xPos + 3 + potIconSide), (int)(yPos + y + 3), (float)(index % 8 * 18), (float)(198 + index / 8 * 18), (int)18, (int)18, (float)256.0f, (float)256.0f);
                        break;
                    }
                }
            } else {
                boolean done = false;
                for (String s : dirs) {
                    ResourceLocation loc = new ResourceLocation(domain, s + path + ".png");
                    if (this.field_73839_d.func_110434_K().func_110581_b(loc) != null) {
                        this.field_73839_d.func_110434_K().func_110577_a(loc);
                        done = true;
                        break;
                    }
                    try {
                        SimpleTexture texture = new SimpleTexture(loc);
                        texture.func_110551_a(this.field_73839_d.func_110442_L());
                        this.field_73839_d.func_110434_K().func_110577_a(loc);
                        done = true;
                        break;
                    }
                    catch (IOException iOException) {
                    }
                }
                if (!done) {
                    this.field_73839_d.func_110434_K().func_110577_a(new ResourceLocation("minecraft", "textures/items/barrier.png"));
                }
                InventoryGui.func_146110_a((int)(xPos + 3 + potIconSide), (int)(yPos + y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
            }
            ResourceLocation lev = effect.func_76458_c() < 9 ? new ResourceLocation("inventoryhud", "textures/gui/l_" + effect.func_76458_c() + ".png") : new ResourceLocation("inventoryhud", "textures/gui/l_inf.png");
            this.field_73839_d.func_110434_K().func_110577_a(lev);
            InventoryGui.func_146110_a((int)(xPos + 15 + potIconSide), (int)(yPos + y), (float)0.0f, (float)0.0f, (int)9, (int)9, (float)9.0f, (float)9.0f);
            String time = "";
            int dur = effect.func_76459_b() / 20;
            if (dur > 1600) {
                time = " **:**";
            } else {
                String mins = dur / 60 + "";
                String secs = dur % 60 + "";
                if (dur / 60 < 10) {
                    mins = "0" + mins;
                }
                if (dur % 60 < 10) {
                    secs = "0" + secs;
                }
                time = dur > 10 ? mins + ":" + secs : TextFormatting.RED + mins + TextFormatting.WHITE + ":" + TextFormatting.RED + secs;
            }
            this.fontRenderer.func_175063_a(time, (float)(xPos + 28 + potTextSide), (float)(yPos + y + 8), 0xFFFFFF);
            y += 24;
        }
    }

    static {
        potIconSide = 36;
        potTextSide = -22;
        armAbove = 100;
        PotAlpha = 1.0f;
        armorRL = new String[]{"textures/items/empty_armor_slot_helmet.png", "textures/items/empty_armor_slot_chestplate.png", "textures/items/empty_armor_slot_leggings.png", "textures/items/empty_armor_slot_boots.png", "textures/items/empty_armor_slot_shield.png", "textures/items/empty_main_hand_slot.png", "textures/items/inventory.png"};
        dirs = new String[]{"textures/mob_effect/", "textures/potions/", "textures/potion/", "textures/gui/potion/", "textures/gui/"};
        atlases = new String[]{"extraalchemy", "extrautils2", "botania", "bloodmagic", "cyberware", "resize", "thaumcraft", "toughasnails"};
        PBG = new ResourceLocation("inventoryhud", "textures/gui/potion_bg.png");
    }
}

