/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.github.jsnimda.common.config.IConfigOption;
import java.util.Objects;

public interface IConfigOptionPrimitive<T>
extends IConfigOption {
    public T getValue();

    public T getDefaultValue();

    public void setValue(T var1);

    @Override
    default public boolean isModified() {
        return !Objects.equals(this.getValue(), this.getDefaultValue());
    }

    @Override
    default public void resetToDefault() {
        this.setValue(this.getDefaultValue());
    }

    @Override
    default public JsonElement toJsonElement() {
        T v = this.getValue();
        if (v instanceof Boolean) {
            return new JsonPrimitive((Boolean)v);
        }
        if (v instanceof Number) {
            return new JsonPrimitive((Number)v);
        }
        if (v instanceof String) {
            return new JsonPrimitive((String)v);
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    default public void fromJsonElement(JsonElement element) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive p = element.getAsJsonPrimitive();
            T v = this.getDefaultValue();
            if (v instanceof Boolean) {
                if (p.isBoolean()) {
                    Boolean o = p.getAsBoolean();
                    this.setValue(o);
                    return;
                }
            } else if (v instanceof Number) {
                if (p.isNumber()) {
                    if (v instanceof Integer) {
                        Integer o = p.getAsInt();
                        this.setValue(o);
                    } else if (v instanceof Double) {
                        Double o = p.getAsDouble();
                        this.setValue(o);
                    } else {
                        throw new UnsupportedOperationException("Not implemented yet");
                    }
                    return;
                }
            } else if (v instanceof String) {
                if (p.isString()) {
                    String o = p.getAsString();
                    this.setValue(o);
                    return;
                }
            } else {
                throw new UnsupportedOperationException("Not implemented yet");
            }
        }
    }
}

