/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.config.options;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.jsnimda.common.config.ConfigOptionBase;
import io.github.jsnimda.common.input.Keybind;
import io.github.jsnimda.common.input.KeybindSettings;
import java.util.ArrayList;
import java.util.List;

public class ConfigHotkey
extends ConfigOptionBase {
    private final Keybind mainKeybind;
    private List<Keybind> alternativeKeybinds = new ArrayList<Keybind>();

    public ConfigHotkey(String defaultStorageString, KeybindSettings defaultSettings) {
        this.mainKeybind = new Keybind(defaultStorageString, defaultSettings);
    }

    public boolean isActivated() {
        return this.mainKeybind.isActivated() || this.alternativeKeybinds.stream().anyMatch(x -> x.isActivated());
    }

    public Keybind getMainKeybind() {
        return this.mainKeybind;
    }

    public List<Keybind> getAlternativeKeybinds() {
        return this.alternativeKeybinds;
    }

    @Override
    public boolean isModified() {
        return !this.alternativeKeybinds.isEmpty() || this.mainKeybind.isModified();
    }

    @Override
    public void resetToDefault() {
        this.alternativeKeybinds.clear();
        this.mainKeybind.resetToDefault();
    }

    @Override
    public JsonElement toJsonElement() {
        JsonObject obj = new JsonObject();
        if (this.mainKeybind.isModified()) {
            obj.add("main", this.mainKeybind.toJsonElement());
        }
        if (!this.alternativeKeybinds.isEmpty()) {
            JsonArray arr = new JsonArray();
            this.alternativeKeybinds.forEach(x -> arr.add(x.toJsonElement()));
            obj.add("alternatives", (JsonElement)arr);
        }
        return obj;
    }

    @Override
    public void fromJsonElement(JsonElement element) {
        this.resetToDefault();
        if (element.isJsonObject()) {
            JsonElement alternativesEle;
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("main")) {
                this.mainKeybind.fromJsonElement(obj.get("main"));
            }
            if (obj.has("alternatives") && (alternativesEle = obj.get("alternatives")).isJsonArray()) {
                JsonArray arr = alternativesEle.getAsJsonArray();
                arr.forEach(x -> {
                    Keybind alt = new Keybind(this.mainKeybind);
                    alt.fromJsonElement((JsonElement)x);
                    if (alt.isModified()) {
                        this.alternativeKeybinds.add(alt);
                    }
                });
            }
        }
    }
}

