/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.gui;

import io.github.jsnimda.common.config.IConfigOption;
import io.github.jsnimda.common.config.options.ConfigHotkey;
import io.github.jsnimda.common.gui.ConfigOptionWidgetBase;
import io.github.jsnimda.common.gui.OverlayScreen;
import io.github.jsnimda.common.gui.Tooltips;
import io.github.jsnimda.common.gui.VHLine;
import io.github.jsnimda.common.input.ConfigElementKeybindSetting;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_308;

public class ConfigOptionHotkeyOverlayScreen
extends OverlayScreen {
    private ConfigHotkey configHotkey;
    private ConfigElementKeybindSetting keybindSettingElement;
    List<? extends IConfigOption> configs;
    List<ConfigOptionWidgetBase<?>> configWidgets;
    private int dialogX;
    private int dialogY;
    private int dialogWidth;
    private int dialogHeight;
    private static final int COLOR_WHITE = -1;
    private static final int COLOR_BORDER = -6710887;
    private static final int COLOR_BG = -16777216;

    protected ConfigOptionHotkeyOverlayScreen(ConfigHotkey configHotkey) {
        super((class_2561)new class_2588("inventoryprofiles.common.gui.config.advanced_keybind_settings", new Object[0]));
        this.configHotkey = configHotkey;
        this.keybindSettingElement = new ConfigElementKeybindSetting(configHotkey.getMainKeybind().getDefaultSettings(), configHotkey.getMainKeybind().getSettings());
        this.configs = this.keybindSettingElement.getConfigOptions();
        this.configWidgets = this.configs.stream().map(x -> ConfigOptionWidgetBase.of(x)).collect(Collectors.toList());
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        class_308.method_1450();
        this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        this.configHotkey.getMainKeybind().setSettings(this.keybindSettingElement.getSettings());
        this.dialogHeight = 112;
        int maxTextW = this.configs.stream().mapToInt(x -> this.font.method_1727(class_1074.method_4662((String)("inventoryprofiles.common.gui.config." + x.getKey()), (Object[])new Object[0]))).max().orElse(0);
        this.dialogWidth = maxTextW + 150 + 2 + 20;
        this.dialogWidth = Math.max(this.font.method_1727("\u00a7l" + this.title.method_10863()) + 20, this.dialogWidth);
        this.dialogX = (this.width - this.dialogWidth) / 2;
        this.dialogY = (this.height - this.dialogHeight) / 2;
        ConfigOptionHotkeyOverlayScreen.fill((int)this.dialogX, (int)this.dialogY, (int)(this.dialogX + this.dialogWidth), (int)(this.dialogY + this.dialogHeight), (int)-16777216);
        VHLine.outline(this.dialogX, this.dialogY, this.dialogX + this.dialogWidth, this.dialogY + this.dialogHeight, -6710887);
        int y0 = this.dialogY + 2;
        this.drawCenteredString(this.font, "\u00a7l" + this.title.method_10863(), this.dialogX + this.dialogWidth / 2, y0 + 6, -1);
        for (ConfigOptionWidgetBase<?> widget : this.configWidgets) {
            String displayName = class_1074.method_4662((String)("inventoryprofiles.common.gui.config." + widget.configOption.getKey()), (Object[])new Object[0]);
            int tx = this.dialogX + 10;
            int ty = (y0 += 20) + 6;
            int tw = this.font.method_1727(displayName);
            this.drawString(this.font, displayName, tx, ty, -1);
            if (VHLine.contains(tx, ty - 1, tx + tw, ty + 9 + 1, mouseX, mouseY)) {
                Tooltips.getInstance().addTooltip(class_1074.method_4662((String)("inventoryprofiles.common.gui.config.description." + widget.configOption.getKey()), (Object[])new Object[0]), mouseX, mouseY, k -> k * 2 / 3);
            }
            widget.x = this.dialogX + maxTextW + 2 + 10;
            widget.y = y0;
            widget.width = 150;
            widget.render(mouseX, mouseY, partialTicks);
        }
        Tooltips.getInstance().renderAll();
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (super.mouseClicked(d, e, i)) {
            return true;
        }
        if (!VHLine.contains(this.dialogX, this.dialogY, this.dialogX + this.dialogWidth, this.dialogY + this.dialogHeight, (int)d, (int)e)) {
            this.onClose();
            return true;
        }
        return false;
    }

    protected void init() {
        this.configWidgets.forEach(x -> this.children.add(x));
    }
}

