/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.gui;

import io.github.jsnimda.common.gui.AnchoredListWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigScreenBase
extends class_437 {
    private static final int COLOR_WHITE = -1;
    private List<Pair<String, Runnable>> navigationButtons = new ArrayList<Pair<String, Runnable>>();
    private boolean buttonsDirty = false;
    protected int userDefinedButtonsWidth = -1;
    protected int calculatedButtonsWidth = 10;
    protected int defaultButtonsWidth = -1;
    public Optional<AnchoredListWidget<?>> currentConfigList = Optional.empty();
    private int selectedIndex = -1;
    private List<class_4185> navigationButtonWidgets = new ArrayList<class_4185>();
    public boolean autoScrollToTop = true;

    protected ConfigScreenBase(class_2561 text) {
        super(text);
    }

    public int getScrollY() {
        return this.currentConfigList.map(x -> x.getContainer().getScrollY()).orElse(0);
    }

    public void setScrollY(int scrollY) {
        this.currentConfigList.ifPresent(x -> x.getContainer().setScrollY(scrollY));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.renderPre(mouseX, mouseY, partialTicks);
        boolean overList = this.currentConfigList.map(x -> x.isMouseOver(mouseX, mouseY)).orElse(false);
        for (int k = 0; k < this.buttons.size(); ++k) {
            ((class_339)this.buttons.get(k)).render(overList ? -1 : mouseX, overList ? -1 : mouseY, partialTicks);
        }
        this.drawString(this.font, this.title.method_10863(), 20, 10, -1);
        this.currentConfigList.ifPresent(x -> x.render(mouseX, mouseY, partialTicks));
    }

    public void renderPre(int mouseX, int mouseY, float partialTicks) {
    }

    public List<? extends class_364> children() {
        ArrayList newList = new ArrayList();
        this.currentConfigList.ifPresent(x -> newList.add(x));
        newList.addAll(this.children);
        return newList;
    }

    protected void init() {
        if (this.buttonsDirty) {
            this.buttonsDirty = false;
            this.calculatedButtonsWidth = 0;
            this.navigationButtons.forEach(x -> {
                int w = this.font.method_1727((String)x.getLeft());
                this.calculatedButtonsWidth = Math.max(w, this.calculatedButtonsWidth);
            });
            this.calculatedButtonsWidth = this.calculatedButtonsWidth == 0 ? 10 : this.calculatedButtonsWidth + 20;
        }
        this.navigationButtonWidgets.clear();
        int x2 = 10;
        int y = 30;
        int h = 22;
        int k = 0;
        int w = this.getButtonsWidth();
        for (Pair<String, Runnable> e : this.navigationButtons) {
            int ind = k++;
            class_4185 b = new class_4185(x2, y + h * ind, w, 20, (String)e.getLeft(), m -> this.setSelectedIndex(ind));
            b.active = this.selectedIndex != ind;
            this.addButton((class_339)b);
            this.navigationButtonWidgets.add(b);
        }
        this.resizeListWidget();
    }

    private void resizeListWidget() {
        this.currentConfigList.ifPresent(e -> {
            int x = 10;
            int w = this.getButtonsWidth();
            int y = 30;
            int lx = x + w + 5;
            int ly = y;
            int lw = this.width - lx - 10;
            int lh = this.height - ly - 10;
            e.setBounds(lx, ly, lw, lh);
        });
    }

    public boolean isPauseScreen() {
        return false;
    }

    public int getButtonsWidth() {
        if (this.userDefinedButtonsWidth > 0) {
            return this.userDefinedButtonsWidth;
        }
        if (this.defaultButtonsWidth > 0) {
            return this.defaultButtonsWidth;
        }
        return this.calculatedButtonsWidth;
    }

    public void addNavigationButton(String buttonText, Runnable action) {
        this.navigationButtons.add((Pair<String, Runnable>)Pair.of((Object)buttonText, (Object)action));
        this.buttonsDirty = true;
    }

    public void addNavigationButton(String buttonText, Supplier<? extends AnchoredListWidget<?>> anchoredListWidget) {
        this.addNavigationButton(buttonText, () -> {
            this.currentConfigList = Optional.ofNullable(anchoredListWidget.get());
            this.resizeListWidget();
        });
    }

    public void addNavigationButton(String buttonText) {
        this.addNavigationButton(buttonText, () -> {
            this.currentConfigList = Optional.empty();
        });
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int index) {
        if (this.autoScrollToTop) {
            this.setScrollY(0);
        }
        if (index < 0 || index >= this.navigationButtons.size()) {
            index = -1;
        }
        if (this.selectedIndex != index) {
            this.selectedIndex = index;
            this.updateButtonActives();
            if (index != -1) {
                ((Runnable)this.navigationButtons.get(index).getRight()).run();
            }
        }
    }

    private void updateButtonActives() {
        for (int i = 0; i < this.navigationButtonWidgets.size(); ++i) {
            this.navigationButtonWidgets.get((int)i).active = this.selectedIndex != i;
        }
    }

    public boolean mouseReleased(double d, double e, int i) {
        if (super.mouseReleased(d, e, i)) {
            return true;
        }
        return this.currentConfigList.map(x -> x.mouseReleased(d, e, i)).orElse(false);
    }
}

