/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import io.github.jsnimda.common.gui.OverlayScreen;
import io.github.jsnimda.common.gui.VHLine;
import io.github.jsnimda.common.input.GlobalInputHandler;
import io.github.jsnimda.common.input.KeyCodes;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class DebugScreen
extends OverlayScreen {
    private static final int COLOR_TEXT_BG = -1873784752;
    private static final int COLOR_TEXT = 0xE0E0E0;
    private static final int COLOR_WHITE = -1;
    private static final int COLOR_BLACK = -16777216;
    private int textPosition = 0;
    private int toggleColor = 0;

    private List<String> getStrings() {
        DebugInfos.width = this.width;
        DebugInfos.height = this.height;
        return DebugInfos.getString();
    }

    private void drawTexts() {
        List<String> strings = this.getStrings();
        int bgh = 9;
        int y1 = this.textPosition < 2 ? 1 : this.height - 1 - bgh * strings.size();
        for (String s : strings) {
            int w = this.font.method_1727(s);
            int bgw = w + 2;
            int x1 = this.textPosition % 3 == 0 ? 1 : this.width - bgw - 1;
            int x2 = x1 + bgw;
            int y2 = y1 + bgh;
            DebugScreen.fill((int)x1, (int)y1, (int)x2, (int)y2, (int)-1873784752);
            this.font.method_1729(s, (float)(x1 + 1), (float)(y1 + 1), 0xE0E0E0);
            y1 += bgh;
        }
    }

    private boolean textBoundingBoxContains(int x, int y) {
        List<String> strings = this.getStrings();
        int bgh = 9;
        int y1 = this.textPosition < 2 ? 1 : this.height - 1 - bgh * strings.size();
        Iterator<String> iterator = strings.iterator();
        while (iterator.hasNext()) {
            int y2;
            String s;
            int w;
            int x2;
            int bgw;
            int x1 = this.textPosition % 3 == 0 ? 1 : this.width - bgw - 1;
            if (VHLine.contains(x1, y1, x2 = x1 + (bgw = (w = this.font.method_1727(s = iterator.next())) + 2), y2 = y1 + bgh, x, y)) {
                return true;
            }
            y1 += bgh;
        }
        return false;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        DebugInfos.mouseX = mouseX;
        DebugInfos.mouseY = mouseY;
        if (this.textBoundingBoxContains(mouseX, mouseY)) {
            this.textPosition = (this.textPosition + 1) % 4;
        }
        GlStateManager.disableLighting();
        GlStateManager.disableDepthTest();
        this.drawTexts();
        if (this.toggleColor < 2) {
            int color = this.toggleColor == 0 ? -1 : -16777216;
            VHLine.v(mouseX, 1, this.height - 2, color);
            VHLine.h(1, this.width - 2, mouseY, color);
        }
    }

    public static void open() {
        if (class_310.method_1551().field_1755 instanceof DebugScreen) {
            return;
        }
        DebugScreen d = new DebugScreen(class_310.method_1551().field_1755);
        class_310.method_1551().method_1507((class_437)d);
    }

    public static boolean isOpened() {
        return class_310.method_1551().field_1755 instanceof DebugScreen;
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (i == 0) {
            this.toggleColor = (this.toggleColor + 1) % 3;
        }
        return super.mouseClicked(d, e, i);
    }

    private DebugScreen(class_437 parent) {
        super((class_2561)new class_2585(""), parent);
    }

    public static class DebugInfos {
        public static int width;
        public static int height;
        public static int mouseX;
        public static int mouseY;
        public static int[] keys;
        public static int[] buttons;
        public static int key;

        public static void onKey(int key, int scanCode, int action, int modifiers) {
            keys = new int[]{key, scanCode, action, modifiers};
            DebugInfos.key = key;
        }

        public static void onMouseButton(int button, int action, int mods) {
            buttons = new int[]{button, action, mods};
            key = button - 100;
        }

        public static List<String> getString() {
            String s = "";
            s = s + String.format("x: %s , y: %s\nw: %s , h: %s", mouseX, mouseY, width, height);
            s = s + "\nonKey: " + Arrays.stream(keys).mapToObj(String::valueOf).collect(Collectors.joining(", "));
            s = s + "\nonMouse: " + Arrays.stream(buttons).mapToObj(String::valueOf).collect(Collectors.joining(", "));
            String name = KeyCodes.getKeyName(key);
            s = s + String.format("\nKey: %s (%s)", name, KeyCodes.getFriendlyName(name));
            s = s + "\nPressing keys: " + GlobalInputHandler.getInstance().pressingKeys.stream().map(x -> KeyCodes.getFriendlyName(x)).collect(Collectors.joining(" + "));
            return Arrays.asList(s.trim().split("\n"));
        }

        static {
            keys = new int[0];
            buttons = new int[0];
            key = -1;
        }
    }
}

