/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import io.github.jsnimda.common.gui.VHLine;
import java.util.Optional;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;

public class ScrollableContainerWidget
extends class_332
implements class_4068,
class_364 {
    private int contentHeight = 0;
    private int scrollY = 0;
    private int x;
    private int y;
    private int width;
    private int height;
    public boolean renderBorder = true;
    public int borderColor = -6710887;
    public int padding = 3;
    private int scrollbarWidth = 6;
    private Optional<IContentRenderer> contentRenderer = Optional.empty();
    private static final int COLOR_BORDER = -6710887;
    private static final int COLOR_SCROLLBAR_BG = Integer.MIN_VALUE;
    private static final int COLOR_SCROLLBAR_SHADOW = -6776680;
    private static final int COLOR_SCROLLBAR = -2565928;
    private static final int COLOR_SCROLLBAR_HOVER_SHADOW = -4144960;
    private static final int COLOR_SCROLLBAR_HOVER = -1;
    private boolean scrolling = false;
    private double scrollingInitMouseY;
    private int scrollingInitScrollbarYOffset;

    public void setContentRenderer(IContentRenderer contentRenderer) {
        this.contentRenderer = Optional.ofNullable(contentRenderer);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.setScrollY(this.scrollY);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getViewportX() {
        return this.x + this.padding;
    }

    public int getViewportY() {
        return this.y + this.padding;
    }

    public int getViewportWidth() {
        return this.width - this.scrollbarWidth - this.padding * 2;
    }

    public int getViewportHeight() {
        return this.height - this.padding * 2;
    }

    public int getScrollYMax() {
        return Math.max(0, this.contentHeight - this.getViewportHeight());
    }

    public int getScrollbarThumbHeight() {
        int vh = this.getViewportHeight();
        if (this.getScrollYMax() == 0) {
            return vh;
        }
        return vh * vh / this.contentHeight;
    }

    public int getScrollbarYOffsetMax() {
        return this.getViewportHeight() - this.getScrollbarThumbHeight();
    }

    public int getScrollbarYOffset() {
        return this.scrollYToScrollbarYOffset(this.scrollY);
    }

    private int scrollbarYOffsetToScrollY(int scrollbarY) {
        if (this.getScrollbarYOffsetMax() == 0) {
            return 0;
        }
        return this.map(this.getScrollbarYOffsetMax(), this.getScrollYMax(), scrollbarY);
    }

    private int scrollYToScrollbarYOffset(int scrollY) {
        if (this.getScrollYMax() == 0) {
            return 0;
        }
        return this.map(this.getScrollYMax(), this.getScrollbarYOffsetMax(), scrollY);
    }

    private int map(int inputMax, int outputMax, int input) {
        return (int)Math.round(1.0 * (double)input * (double)outputMax / (double)inputMax);
    }

    public void setScrollY(int newScrollY) {
        int oldScrollY = this.scrollY;
        if (newScrollY < 0) {
            this.scrollY = 0;
        } else {
            int n = this.scrollY = newScrollY > this.getScrollYMax() ? this.getScrollYMax() : newScrollY;
        }
        if (oldScrollY != newScrollY) {
            this.scrollYChanged(newScrollY, oldScrollY);
        }
    }

    private void scrollYChanged(int newScrollY, int oldScrollY) {
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
        this.setScrollY(this.scrollY);
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.renderBorder) {
            VHLine.outline(this.x, this.y, this.x + this.width, this.y + this.height, this.borderColor);
        }
        if (this.isScrollbarVisible()) {
            int x1 = this.getViewportX() + this.getViewportWidth();
            int y1 = this.getViewportY();
            int x2 = x1 + this.scrollbarWidth;
            int y2 = y1 + this.getViewportHeight();
            int sy1 = y1 + this.getScrollbarYOffset();
            int sy2 = sy1 + this.getScrollbarThumbHeight();
            ScrollableContainerWidget.fill((int)x1, (int)y1, (int)x2, (int)y2, (int)Integer.MIN_VALUE);
            boolean hover = VHLine.contains(x1, sy1, x2, sy2, mouseX, mouseY) || this.scrolling;
            ScrollableContainerWidget.fill((int)x1, (int)sy1, (int)x2, (int)sy2, (int)(hover ? -4144960 : -6776680));
            ScrollableContainerWidget.fill((int)x1, (int)sy1, (int)(x2 - 1), (int)(sy2 - 1), (int)(hover ? -1 : -2565928));
        }
        if (this.contentRenderer.isPresent()) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-400.0f);
            GlStateManager.enableDepthTest();
            GlStateManager.depthFunc((int)518);
            GlStateManager.disableAlphaTest();
            int vx = this.getViewportX();
            int vy = this.getViewportY();
            int vw = this.getViewportWidth();
            int vh = this.getViewportHeight();
            ScrollableContainerWidget.fill((int)vx, (int)vy, (int)(vx + vw), (int)(vy + vh), (int)0);
            GlStateManager.enableAlphaTest();
            GlStateManager.depthFunc((int)515);
            this.contentRenderer.get().render(mouseX, mouseY, partialTicks, vx, vy, vw, vh, this.scrollY);
            GlStateManager.popMatrix();
            GlStateManager.disableDepthTest();
        }
    }

    public boolean isScrollbarVisible() {
        return this.getScrollYMax() > 0;
    }

    private boolean hoverScrollbarThumb(int mouseX, int mouseY) {
        int x1 = this.getViewportX() + this.getViewportWidth();
        int y1 = this.getViewportY();
        int x2 = x1 + this.scrollbarWidth;
        int sy1 = y1 + this.getScrollbarYOffset();
        int sy2 = sy1 + this.getScrollbarThumbHeight();
        return VHLine.contains(x1, sy1, x2, sy2, mouseX, mouseY);
    }

    private boolean hoverScrollbar(int mouseX, int mouseY) {
        int x1 = this.getViewportX() + this.getViewportWidth();
        int y1 = this.getViewportY();
        int x2 = x1 + this.scrollbarWidth;
        int y2 = y1 + this.getViewportHeight();
        return VHLine.contains(x1, y1, x2, y2, mouseX, mouseY);
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (this.isScrollbarVisible()) {
            this.scrolling = this.hoverScrollbar((int)d, (int)e);
            if (i == 0 && this.scrolling) {
                if (!this.hoverScrollbarThumb((int)d, (int)e)) {
                    int y1 = this.getViewportY();
                    int newYOffset = (int)e - y1 - this.getScrollbarThumbHeight() / 2;
                    this.setScrollY(this.scrollbarYOffsetToScrollY(newYOffset));
                }
                this.scrollingInitMouseY = e;
                this.scrollingInitScrollbarYOffset = this.getScrollbarYOffset();
                return true;
            }
        }
        return false;
    }

    public boolean mouseReleased(double d, double e, int i) {
        this.scrolling = false;
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        if (button == 0 && this.scrolling) {
            double shiftY = mouseY - this.scrollingInitMouseY;
            this.setScrollY(this.scrollbarYOffsetToScrollY(this.scrollingInitScrollbarYOffset + (int)shiftY));
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double d, double e, double f) {
        if (this.isScrollbarVisible()) {
            this.setScrollY(this.scrollY - (int)(f * 20.0));
        }
        return true;
    }

    public boolean isMouseOver(double d, double e) {
        return VHLine.contains(this.x, this.y, this.x + this.width, this.y + this.height, (int)d, (int)e);
    }

    public boolean isMouseOverViewport(double d, double e) {
        int x1 = this.getViewportX();
        int y1 = this.getViewportY();
        int x2 = x1 + this.getViewportWidth();
        int y2 = y1 + this.getViewportHeight();
        return VHLine.contains(x1, y1, x2, y2, (int)d, (int)e);
    }

    public static interface IContentRenderer {
        public void render(int var1, int var2, float var3, int var4, int var5, int var6, int var7, int var8);
    }
}

