/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_918;

public class Tooltips {
    private static final Tooltips INSTANCE = new Tooltips();
    public List<Tooltip> tooltips = new ArrayList<Tooltip>();

    public static Tooltips getInstance() {
        return INSTANCE;
    }

    public void addTooltip(String string, int mouseX, int mouseY) {
        this.addTooltip(Arrays.asList(string.split("\n")), mouseX, mouseY);
    }

    public void addTooltip(List<String> strings, int x, int y) {
        this.tooltips.add(new Tooltip(strings, x, y));
    }

    public void renderAll() {
        this.tooltips.forEach(x -> x.render());
        this.tooltips.clear();
    }

    public void addTooltip(String string, int mouseX, int mouseY, int maxWidth) {
        this.addTooltip(class_310.method_1551().field_1772.method_1728(string, maxWidth), mouseX, mouseY);
    }

    public void addTooltip(String string, int mouseX, int mouseY, Function<Integer, Integer> maxWidthProvider) {
        this.addTooltip(class_310.method_1551().field_1772.method_1728(string, maxWidthProvider.apply(class_310.method_1551().field_1755.width).intValue()), mouseX, mouseY);
    }

    public static class Tooltip
    extends class_332 {
        public List<String> strings;
        public int mouseX;
        public int mouseY;

        public Tooltip(String string, int mouseX, int mouseY) {
            this.strings = Arrays.asList(string.split("\n"));
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }

        public Tooltip(List<String> strings, int mouseX, int mouseY) {
            this.strings = strings;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }

        public void render() {
            this.renderTooltip(false);
        }

        private void renderTooltip(boolean firstLineGap) {
            List<String> list = this.strings;
            int width = class_310.method_1551().field_1755.width;
            int height = class_310.method_1551().field_1755.height;
            class_327 font = class_310.method_1551().field_1772;
            class_918 itemRenderer = class_310.method_1551().method_1480();
            if (!list.isEmpty()) {
                GlStateManager.disableRescaleNormal();
                class_308.method_1450();
                GlStateManager.disableLighting();
                GlStateManager.disableDepthTest();
                int maxStringWidth = 0;
                for (String string : list) {
                    int l = font.method_1727(string);
                    if (l <= maxStringWidth) continue;
                    maxStringWidth = l;
                }
                int p = 8;
                if (list.size() > 1) {
                    p += (firstLineGap ? 2 : 0) + (list.size() - 1) * 10;
                }
                int textX = this.mouseX + 4;
                int textY = this.mouseY - p - 6;
                if (textX + maxStringWidth + 4 + 5 > width) {
                    textX -= 7 + maxStringWidth;
                }
                if (textX - 4 - 5 < 0) {
                    textX = width - (maxStringWidth + 4 + 5);
                }
                if (textY + p + 6 > height) {
                    textY = height - p - 6;
                }
                if (textY - 6 < 0) {
                    textY = 6;
                }
                this.blitOffset = 300;
                itemRenderer.field_4730 = 300.0f;
                int COLOR_BG = -267386864;
                this.fillGradient(textX - 3, textY - 4, textX + maxStringWidth + 3, textY - 3, COLOR_BG, COLOR_BG);
                this.fillGradient(textX - 3, textY + p + 3, textX + maxStringWidth + 3, textY + p + 4, COLOR_BG, COLOR_BG);
                this.fillGradient(textX - 3, textY - 3, textX + maxStringWidth + 3, textY + p + 3, COLOR_BG, COLOR_BG);
                this.fillGradient(textX - 4, textY - 3, textX - 3, textY + p + 3, COLOR_BG, COLOR_BG);
                this.fillGradient(textX + maxStringWidth + 3, textY - 3, textX + maxStringWidth + 4, textY + p + 3, COLOR_BG, COLOR_BG);
                int COLOR_OUTLINE_TOP = 0x505000FF;
                int COLOR_OUTLINE_BOTTOM = 1344798847;
                this.fillGradient(textX - 3, textY - 3 + 1, textX - 3 + 1, textY + p + 3 - 1, COLOR_OUTLINE_TOP, COLOR_OUTLINE_BOTTOM);
                this.fillGradient(textX + maxStringWidth + 2, textY - 3 + 1, textX + maxStringWidth + 3, textY + p + 3 - 1, COLOR_OUTLINE_TOP, COLOR_OUTLINE_BOTTOM);
                this.fillGradient(textX - 3, textY - 3, textX + maxStringWidth + 3, textY - 3 + 1, COLOR_OUTLINE_TOP, COLOR_OUTLINE_TOP);
                this.fillGradient(textX - 3, textY + p + 2, textX + maxStringWidth + 3, textY + p + 3, COLOR_OUTLINE_BOTTOM, COLOR_OUTLINE_BOTTOM);
                for (int t = 0; t < list.size(); ++t) {
                    String string2 = list.get(t);
                    font.method_1720(string2, (float)textX, (float)textY, -1);
                    if (t == 0) {
                        textY += firstLineGap ? 2 : 0;
                    }
                    textY += 10;
                }
                this.blitOffset = 0;
                itemRenderer.field_4730 = 0.0f;
                GlStateManager.enableLighting();
                GlStateManager.enableDepthTest();
                class_308.method_1452();
                GlStateManager.enableRescaleNormal();
            }
        }
    }
}

