/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.input;

import java.util.HashMap;
import java.util.Map;

public class KeyCodes {
    public static final int KEY_UNKNOWN = -1;
    public static final int KEY_SPACE = 32;
    public static final int KEY_APOSTROPHE = 39;
    public static final int KEY_COMMA = 44;
    public static final int KEY_MINUS = 45;
    public static final int KEY_PERIOD = 46;
    public static final int KEY_SLASH = 47;
    public static final int KEY_0 = 48;
    public static final int KEY_1 = 49;
    public static final int KEY_2 = 50;
    public static final int KEY_3 = 51;
    public static final int KEY_4 = 52;
    public static final int KEY_5 = 53;
    public static final int KEY_6 = 54;
    public static final int KEY_7 = 55;
    public static final int KEY_8 = 56;
    public static final int KEY_9 = 57;
    public static final int KEY_SEMICOLON = 59;
    public static final int KEY_EQUAL = 61;
    public static final int KEY_A = 65;
    public static final int KEY_B = 66;
    public static final int KEY_C = 67;
    public static final int KEY_D = 68;
    public static final int KEY_E = 69;
    public static final int KEY_F = 70;
    public static final int KEY_G = 71;
    public static final int KEY_H = 72;
    public static final int KEY_I = 73;
    public static final int KEY_J = 74;
    public static final int KEY_K = 75;
    public static final int KEY_L = 76;
    public static final int KEY_M = 77;
    public static final int KEY_N = 78;
    public static final int KEY_O = 79;
    public static final int KEY_P = 80;
    public static final int KEY_Q = 81;
    public static final int KEY_R = 82;
    public static final int KEY_S = 83;
    public static final int KEY_T = 84;
    public static final int KEY_U = 85;
    public static final int KEY_V = 86;
    public static final int KEY_W = 87;
    public static final int KEY_X = 88;
    public static final int KEY_Y = 89;
    public static final int KEY_Z = 90;
    public static final int KEY_LEFT_BRACKET = 91;
    public static final int KEY_BACKSLASH = 92;
    public static final int KEY_RIGHT_BRACKET = 93;
    public static final int KEY_GRAVE_ACCENT = 96;
    public static final int KEY_WORLD_1 = 161;
    public static final int KEY_WORLD_2 = 162;
    public static final int KEY_ESCAPE = 256;
    public static final int KEY_ENTER = 257;
    public static final int KEY_TAB = 258;
    public static final int KEY_BACKSPACE = 259;
    public static final int KEY_INSERT = 260;
    public static final int KEY_DELETE = 261;
    public static final int KEY_RIGHT = 262;
    public static final int KEY_LEFT = 263;
    public static final int KEY_DOWN = 264;
    public static final int KEY_UP = 265;
    public static final int KEY_PAGE_UP = 266;
    public static final int KEY_PAGE_DOWN = 267;
    public static final int KEY_HOME = 268;
    public static final int KEY_END = 269;
    public static final int KEY_CAPS_LOCK = 280;
    public static final int KEY_SCROLL_LOCK = 281;
    public static final int KEY_NUM_LOCK = 282;
    public static final int KEY_PRINT_SCREEN = 283;
    public static final int KEY_PAUSE = 284;
    public static final int KEY_F1 = 290;
    public static final int KEY_F2 = 291;
    public static final int KEY_F3 = 292;
    public static final int KEY_F4 = 293;
    public static final int KEY_F5 = 294;
    public static final int KEY_F6 = 295;
    public static final int KEY_F7 = 296;
    public static final int KEY_F8 = 297;
    public static final int KEY_F9 = 298;
    public static final int KEY_F10 = 299;
    public static final int KEY_F11 = 300;
    public static final int KEY_F12 = 301;
    public static final int KEY_F13 = 302;
    public static final int KEY_F14 = 303;
    public static final int KEY_F15 = 304;
    public static final int KEY_F16 = 305;
    public static final int KEY_F17 = 306;
    public static final int KEY_F18 = 307;
    public static final int KEY_F19 = 308;
    public static final int KEY_F20 = 309;
    public static final int KEY_F21 = 310;
    public static final int KEY_F22 = 311;
    public static final int KEY_F23 = 312;
    public static final int KEY_F24 = 313;
    public static final int KEY_F25 = 314;
    public static final int KEY_KP_0 = 320;
    public static final int KEY_KP_1 = 321;
    public static final int KEY_KP_2 = 322;
    public static final int KEY_KP_3 = 323;
    public static final int KEY_KP_4 = 324;
    public static final int KEY_KP_5 = 325;
    public static final int KEY_KP_6 = 326;
    public static final int KEY_KP_7 = 327;
    public static final int KEY_KP_8 = 328;
    public static final int KEY_KP_9 = 329;
    public static final int KEY_KP_DECIMAL = 330;
    public static final int KEY_KP_DIVIDE = 331;
    public static final int KEY_KP_MULTIPLY = 332;
    public static final int KEY_KP_SUBTRACT = 333;
    public static final int KEY_KP_ADD = 334;
    public static final int KEY_KP_ENTER = 335;
    public static final int KEY_KP_EQUAL = 336;
    public static final int KEY_LEFT_SHIFT = 340;
    public static final int KEY_LEFT_CONTROL = 341;
    public static final int KEY_LEFT_ALT = 342;
    public static final int KEY_LEFT_SUPER = 343;
    public static final int KEY_RIGHT_SHIFT = 344;
    public static final int KEY_RIGHT_CONTROL = 345;
    public static final int KEY_RIGHT_ALT = 346;
    public static final int KEY_RIGHT_SUPER = 347;
    public static final int KEY_MENU = 348;
    public static final int KEY_LAST = 348;
    public static final int MOUSE_BUTTON_1 = -100;
    public static final int MOUSE_BUTTON_2 = -99;
    public static final int MOUSE_BUTTON_3 = -98;
    public static final int MOUSE_BUTTON_4 = -97;
    public static final int MOUSE_BUTTON_5 = -96;
    public static final int MOUSE_BUTTON_6 = -95;
    public static final int MOUSE_BUTTON_7 = -94;
    public static final int MOUSE_BUTTON_8 = -93;
    private static final Map<Integer, String> KEY_TO_NAME_MAP = new HashMap<Integer, String>();
    private static final Map<String, Integer> NAME_TO_KEY_MAP = new HashMap<String, Integer>();
    private static final Map<String, String> NAME_TO_DISPLAY_TEXT_MAP = new HashMap<String, String>();

    private static void mapKeyName(String name, String displayText, int key) {
        if (!KEY_TO_NAME_MAP.containsKey(key)) {
            KEY_TO_NAME_MAP.put(key, name);
        }
        if (!NAME_TO_KEY_MAP.containsKey(name)) {
            NAME_TO_KEY_MAP.put(name, key);
        }
        if (!NAME_TO_DISPLAY_TEXT_MAP.containsKey(name)) {
            NAME_TO_DISPLAY_TEXT_MAP.put(name, displayText == null || displayText.isEmpty() ? name : displayText);
        }
    }

    public static String getKeyName(int key) {
        return KEY_TO_NAME_MAP.containsKey(key) ? KEY_TO_NAME_MAP.get(key) : "keycode " + key;
    }

    public static int getKeyFromName(String name) {
        return NAME_TO_KEY_MAP.containsKey(name) ? NAME_TO_KEY_MAP.get(name) : -1;
    }

    public static String getFriendlyName(String name) {
        return NAME_TO_DISPLAY_TEXT_MAP.containsKey(name) ? NAME_TO_DISPLAY_TEXT_MAP.get(name) : name;
    }

    public static String getFriendlyName(int key) {
        return KeyCodes.getFriendlyName(KeyCodes.getKeyName(key));
    }

    static {
        KeyCodes.mapKeyName("UNKNOWN", null, -1);
        KeyCodes.mapKeyName("SPACE", "Space", 32);
        KeyCodes.mapKeyName("APOSTROPHE", "'", 39);
        KeyCodes.mapKeyName("COMMA", ",", 44);
        KeyCodes.mapKeyName("MINUS", "-", 45);
        KeyCodes.mapKeyName("PERIOD", ".", 46);
        KeyCodes.mapKeyName("SLASH", "/", 47);
        KeyCodes.mapKeyName("0", "0", 48);
        KeyCodes.mapKeyName("1", "1", 49);
        KeyCodes.mapKeyName("2", "2", 50);
        KeyCodes.mapKeyName("3", "3", 51);
        KeyCodes.mapKeyName("4", "4", 52);
        KeyCodes.mapKeyName("5", "5", 53);
        KeyCodes.mapKeyName("6", "6", 54);
        KeyCodes.mapKeyName("7", "7", 55);
        KeyCodes.mapKeyName("8", "8", 56);
        KeyCodes.mapKeyName("9", "9", 57);
        KeyCodes.mapKeyName("SEMICOLON", ";", 59);
        KeyCodes.mapKeyName("EQUAL", "=", 61);
        KeyCodes.mapKeyName("A", "a", 65);
        KeyCodes.mapKeyName("B", "b", 66);
        KeyCodes.mapKeyName("C", "c", 67);
        KeyCodes.mapKeyName("D", "d", 68);
        KeyCodes.mapKeyName("E", "e", 69);
        KeyCodes.mapKeyName("F", "f", 70);
        KeyCodes.mapKeyName("G", "g", 71);
        KeyCodes.mapKeyName("H", "h", 72);
        KeyCodes.mapKeyName("I", "i", 73);
        KeyCodes.mapKeyName("J", "j", 74);
        KeyCodes.mapKeyName("K", "k", 75);
        KeyCodes.mapKeyName("L", "l", 76);
        KeyCodes.mapKeyName("M", "m", 77);
        KeyCodes.mapKeyName("N", "n", 78);
        KeyCodes.mapKeyName("O", "o", 79);
        KeyCodes.mapKeyName("P", "p", 80);
        KeyCodes.mapKeyName("Q", "q", 81);
        KeyCodes.mapKeyName("R", "r", 82);
        KeyCodes.mapKeyName("S", "s", 83);
        KeyCodes.mapKeyName("T", "t", 84);
        KeyCodes.mapKeyName("U", "u", 85);
        KeyCodes.mapKeyName("V", "v", 86);
        KeyCodes.mapKeyName("W", "w", 87);
        KeyCodes.mapKeyName("X", "x", 88);
        KeyCodes.mapKeyName("Y", "y", 89);
        KeyCodes.mapKeyName("Z", "z", 90);
        KeyCodes.mapKeyName("LEFT_BRACKET", "[", 91);
        KeyCodes.mapKeyName("BACKSLASH", "\\", 92);
        KeyCodes.mapKeyName("RIGHT_BRACKET", "]", 93);
        KeyCodes.mapKeyName("GRAVE_ACCENT", "`", 96);
        KeyCodes.mapKeyName("WORLD_1", null, 161);
        KeyCodes.mapKeyName("WORLD_2", null, 162);
        KeyCodes.mapKeyName("ESCAPE", "Esc", 256);
        KeyCodes.mapKeyName("ENTER", "Enter", 257);
        KeyCodes.mapKeyName("TAB", "Tab", 258);
        KeyCodes.mapKeyName("BACKSPACE", "Backspace", 259);
        KeyCodes.mapKeyName("INSERT", "Insert", 260);
        KeyCodes.mapKeyName("DELETE", "Delete", 261);
        KeyCodes.mapKeyName("RIGHT", "Right", 262);
        KeyCodes.mapKeyName("LEFT", "Left", 263);
        KeyCodes.mapKeyName("DOWN", "Down", 264);
        KeyCodes.mapKeyName("UP", "Up", 265);
        KeyCodes.mapKeyName("PAGE_UP", "Page Up", 266);
        KeyCodes.mapKeyName("PAGE_DOWN", "Page Down", 267);
        KeyCodes.mapKeyName("HOME", "Home", 268);
        KeyCodes.mapKeyName("END", "End", 269);
        KeyCodes.mapKeyName("CAPS_LOCK", "Caps Lock", 280);
        KeyCodes.mapKeyName("SCROLL_LOCK", "Scroll Lock", 281);
        KeyCodes.mapKeyName("NUM_LOCK", "Num Lock", 282);
        KeyCodes.mapKeyName("PRINT_SCREEN", "Print Screen", 283);
        KeyCodes.mapKeyName("PAUSE", "Pause", 284);
        KeyCodes.mapKeyName("F1", "F1", 290);
        KeyCodes.mapKeyName("F2", "F2", 291);
        KeyCodes.mapKeyName("F3", "F3", 292);
        KeyCodes.mapKeyName("F4", "F4", 293);
        KeyCodes.mapKeyName("F5", "F5", 294);
        KeyCodes.mapKeyName("F6", "F6", 295);
        KeyCodes.mapKeyName("F7", "F7", 296);
        KeyCodes.mapKeyName("F8", "F8", 297);
        KeyCodes.mapKeyName("F9", "F9", 298);
        KeyCodes.mapKeyName("F10", "F10", 299);
        KeyCodes.mapKeyName("F11", "F11", 300);
        KeyCodes.mapKeyName("F12", "F12", 301);
        KeyCodes.mapKeyName("F13", null, 302);
        KeyCodes.mapKeyName("F14", null, 303);
        KeyCodes.mapKeyName("F15", null, 304);
        KeyCodes.mapKeyName("F16", null, 305);
        KeyCodes.mapKeyName("F17", null, 306);
        KeyCodes.mapKeyName("F18", null, 307);
        KeyCodes.mapKeyName("F19", null, 308);
        KeyCodes.mapKeyName("F20", null, 309);
        KeyCodes.mapKeyName("F21", null, 310);
        KeyCodes.mapKeyName("F22", null, 311);
        KeyCodes.mapKeyName("F23", null, 312);
        KeyCodes.mapKeyName("F24", null, 313);
        KeyCodes.mapKeyName("F25", null, 314);
        KeyCodes.mapKeyName("KP_0", "Numpad 0", 320);
        KeyCodes.mapKeyName("KP_1", "Numpad 1", 321);
        KeyCodes.mapKeyName("KP_2", "Numpad 2", 322);
        KeyCodes.mapKeyName("KP_3", "Numpad 3", 323);
        KeyCodes.mapKeyName("KP_4", "Numpad 4", 324);
        KeyCodes.mapKeyName("KP_5", "Numpad 5", 325);
        KeyCodes.mapKeyName("KP_6", "Numpad 6", 326);
        KeyCodes.mapKeyName("KP_7", "Numpad 7", 327);
        KeyCodes.mapKeyName("KP_8", "Numpad 8", 328);
        KeyCodes.mapKeyName("KP_9", "Numpad 9", 329);
        KeyCodes.mapKeyName("KP_DECIMAL", "Numpad .", 330);
        KeyCodes.mapKeyName("KP_DIVIDE", "Numpad /", 331);
        KeyCodes.mapKeyName("KP_MULTIPLY", "Numpad *", 332);
        KeyCodes.mapKeyName("KP_SUBTRACT", "Numpad -", 333);
        KeyCodes.mapKeyName("KP_ADD", "Numpad +", 334);
        KeyCodes.mapKeyName("KP_ENTER", "Numpad Enter", 335);
        KeyCodes.mapKeyName("KP_EQUAL", null, 336);
        KeyCodes.mapKeyName("LEFT_SHIFT", "Left Shift", 340);
        KeyCodes.mapKeyName("LEFT_CONTROL", "Left Ctrl", 341);
        KeyCodes.mapKeyName("LEFT_ALT", "Left Alt", 342);
        KeyCodes.mapKeyName("LEFT_SUPER", "Left Win", 343);
        KeyCodes.mapKeyName("RIGHT_SHIFT", "Right Shift", 344);
        KeyCodes.mapKeyName("RIGHT_CONTROL", "Right Ctrl", 345);
        KeyCodes.mapKeyName("RIGHT_ALT", "Right Alt", 346);
        KeyCodes.mapKeyName("RIGHT_SUPER", "Right Win", 347);
        KeyCodes.mapKeyName("MENU", "Menu", 348);
        KeyCodes.mapKeyName("LAST", null, 348);
        KeyCodes.mapKeyName("BUTTON_1", "Left Button", -100);
        KeyCodes.mapKeyName("BUTTON_2", "Right Button", -99);
        KeyCodes.mapKeyName("BUTTON_3", "Middle Button", -98);
        KeyCodes.mapKeyName("BUTTON_4", "Back Button", -97);
        KeyCodes.mapKeyName("BUTTON_5", "Forward Button", -96);
        KeyCodes.mapKeyName("BUTTON_6", null, -95);
        KeyCodes.mapKeyName("BUTTON_7", null, -94);
        KeyCodes.mapKeyName("BUTTON_8", null, -93);
    }
}

