/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.input;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.jsnimda.common.config.IConfigElementResettable;
import io.github.jsnimda.common.input.ConfigElementKeybindSetting;
import io.github.jsnimda.common.input.GlobalInputHandler;
import io.github.jsnimda.common.input.KeyCodes;
import io.github.jsnimda.common.input.KeybindSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Keybind
implements IConfigElementResettable {
    private final List<Integer> defaultKeyCodes;
    private List<Integer> keyCodes;
    private final Optional<KeybindSettings> defaultSettings;
    private Optional<KeybindSettings> settings;
    private final Optional<Keybind> parent;

    public Keybind(String defaultStorageString, KeybindSettings defaultSettings) {
        this.defaultKeyCodes = ImmutableList.copyOf(Keybind.storageStringToKeyCodes(defaultStorageString));
        this.keyCodes = new ArrayList<Integer>(this.defaultKeyCodes);
        this.defaultSettings = Optional.of(defaultSettings);
        this.settings = Optional.of(defaultSettings);
        this.parent = Optional.empty();
    }

    public Keybind(Keybind parent) {
        this.defaultKeyCodes = ImmutableList.of();
        this.keyCodes = new ArrayList<Integer>();
        this.defaultSettings = Optional.empty();
        this.settings = Optional.empty();
        this.parent = Optional.of(parent);
    }

    public List<Integer> getKeyCodes() {
        return this.keyCodes;
    }

    public List<Integer> getDefaultKeyCodes() {
        return this.defaultKeyCodes;
    }

    public void setKeyCodes(List<Integer> keyCodes) {
        this.keyCodes = new ArrayList<Integer>(keyCodes);
    }

    public KeybindSettings getSettings() {
        return this.settings.isPresent() ? this.settings.get() : this.parent.get().getSettings();
    }

    public KeybindSettings getDefaultSettings() {
        return this.defaultSettings.isPresent() ? this.defaultSettings.get() : this.parent.get().getSettings();
    }

    public void setSettings(KeybindSettings settings) {
        this.settings = Optional.of(settings);
    }

    public boolean isActivated() {
        return GlobalInputHandler.getInstance().isActivated(this.keyCodes, this.getSettings());
    }

    private static List<Integer> storageStringToKeyCodes(String storageString) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String s : storageString.split(",")) {
            if ((s = s.trim()).isEmpty()) continue;
            result.add(KeyCodes.getKeyFromName(s));
        }
        return result;
    }

    private static String keyCodesToStorageString(List<Integer> keyCodes) {
        return keyCodes.stream().map(x -> KeyCodes.getKeyName(x)).collect(Collectors.joining(","));
    }

    private static String keyCodesToDisplayText(List<Integer> keyCodes) {
        return keyCodes.stream().map(x -> KeyCodes.getFriendlyName(x)).collect(Collectors.joining(" + "));
    }

    public String getDisplayText() {
        return Keybind.keyCodesToDisplayText(this.keyCodes);
    }

    public String toStorageString() {
        return Keybind.keyCodesToStorageString(this.keyCodes);
    }

    public void fromStorageString(String storageString) {
        this.keyCodes = Keybind.storageStringToKeyCodes(storageString);
    }

    public boolean isKeyCodesModified() {
        return !this.defaultKeyCodes.equals(this.keyCodes);
    }

    public boolean isSettingsModified() {
        return !this.defaultSettings.equals(this.settings);
    }

    public void resetKeyCodesToDefault() {
        this.keyCodes = new ArrayList<Integer>(this.defaultKeyCodes);
    }

    public void resetSettingsToDefault() {
        this.settings = this.defaultSettings;
    }

    @Override
    public JsonElement toJsonElement() {
        JsonObject obj = new JsonObject();
        if (this.isKeyCodesModified()) {
            obj.addProperty("keys", this.toStorageString());
        }
        if (this.parent.isPresent()) {
            obj.addProperty("inherit", Boolean.valueOf(!this.settings.isPresent()));
        }
        if (this.isSettingsModified()) {
            obj.add("settings", new ConfigElementKeybindSetting(this.getDefaultSettings(), this.getSettings()).toJsonElement());
        }
        return obj;
    }

    @Override
    public void fromJsonElement(JsonElement element) {
        this.resetToDefault();
        if (element.isJsonObject()) {
            JsonElement keysEle;
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("keys") && (keysEle = obj.get("keys")).isJsonPrimitive() && keysEle.getAsJsonPrimitive().isString()) {
                this.fromStorageString(keysEle.getAsString());
            }
            if (obj.has("settings")) {
                ConfigElementKeybindSetting configEle = new ConfigElementKeybindSetting(this.getDefaultSettings(), this.getSettings());
                configEle.fromJsonElement(obj.get("settings"));
                this.settings = Optional.of(configEle.getSettings());
            } else if (this.parent.isPresent()) {
                JsonElement inheritEle;
                boolean inherit = true;
                if (obj.has("inherit") && (inheritEle = obj.get("inherit")).isJsonPrimitive() && inheritEle.getAsJsonPrimitive().isBoolean()) {
                    inherit = inheritEle.getAsBoolean();
                }
                if (!inherit) {
                    this.settings = Optional.of(this.getDefaultSettings());
                }
            }
        }
    }

    @Override
    public boolean isModified() {
        return this.isKeyCodesModified() || this.isSettingsModified();
    }

    @Override
    public void resetToDefault() {
        this.resetKeyCodesToDefault();
        this.resetSettingsToDefault();
    }
}

