/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.input;

import net.minecraft.class_1074;

public class KeybindSettings {
    public static final KeybindSettings INGAME_DEFAULT = new KeybindSettings(Context.INGAME, KeyAction.PRESS, 2L);
    public static final KeybindSettings GUI_DEFAULT = new KeybindSettings(Context.GUI, KeyAction.PRESS, 2L);
    public static final KeybindSettings ANY_DEFAULT = new KeybindSettings(Context.ANY, KeyAction.PRESS, 2L);
    public final Context context;
    public final KeyAction activateOn;
    public final boolean allowExtraKeys;
    public final boolean orderSensitive;

    public KeybindSettings(Context context, KeyAction activateOn, boolean allowExtraKeys, boolean orderSensitive) {
        this.context = context;
        this.activateOn = activateOn;
        this.allowExtraKeys = allowExtraKeys;
        this.orderSensitive = orderSensitive;
    }

    public KeybindSettings(Context context, KeyAction activateOn, long flags) {
        this.context = context;
        this.activateOn = activateOn;
        this.allowExtraKeys = (flags & 1L) != 0L;
        this.orderSensitive = (flags & 2L) != 0L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activateOn == null ? 0 : this.activateOn.hashCode());
        result = 31 * result + (this.allowExtraKeys ? 1231 : 1237);
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.orderSensitive ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeybindSettings other = (KeybindSettings)obj;
        if (this.activateOn != other.activateOn) {
            return false;
        }
        if (this.allowExtraKeys != other.allowExtraKeys) {
            return false;
        }
        if (this.context != other.context) {
            return false;
        }
        return this.orderSensitive == other.orderSensitive;
    }

    public class FlagConstants {
        public static final long NO_EXTRA = 0L;
        public static final long ALLOW_EXTRA = 1L;
        public static final long NO_ORDER = 0L;
        public static final long IN_ORDER = 2L;
    }

    public static enum Context {
        INGAME,
        GUI,
        ANY;


        public String toString() {
            return class_1074.method_4662((String)("inventoryprofiles.common.enum.context." + this.name().toLowerCase()), (Object[])new Object[0]);
        }
    }

    public static enum KeyAction {
        PRESS,
        RELEASE,
        BOTH;


        public String toString() {
            return class_1074.method_4662((String)("inventoryprofiles.common.enum.key_action." + this.name().toLowerCase()), (Object[])new Object[0]);
        }
    }
}

