/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.config;

import io.github.jsnimda.common.config.CategorizedConfigOptions;
import io.github.jsnimda.common.config.ConfigSaveLoadManager;
import io.github.jsnimda.common.config.ConfigsClassBuilder;
import io.github.jsnimda.common.config.options.ConfigBoolean;
import io.github.jsnimda.common.config.options.ConfigEnum;
import io.github.jsnimda.common.config.options.ConfigHotkey;
import io.github.jsnimda.common.config.options.ConfigHotkeyedBoolean;
import io.github.jsnimda.common.config.options.ConfigInteger;
import io.github.jsnimda.common.input.KeybindSettings;
import io.github.jsnimda.inventoryprofiles.sorter.predefined.SortingMethodOption;

public class Configs {
    @ConfigsClassBuilder.Exclude
    public static final CategorizedConfigOptions CLASS_CONFIGS = ConfigsClassBuilder.loadWithNested(Configs.class, false);
    public static final String FILE_PATH = "inventoryprofiles/inventoryprofiles.json";
    public static ConfigSaveLoadManager saveLoadManager = new ConfigSaveLoadManager(CLASS_CONFIGS, "inventoryprofiles/inventoryprofiles.json");

    public static CategorizedConfigOptions getConfigs(Class<?> clazz) {
        return (CategorizedConfigOptions)CLASS_CONFIGS.getConfigOptionsMap().get(clazz.getSimpleName());
    }

    @ConfigsClassBuilder.ConfigOptionsClass
    public static class Tweaks {
        @ConfigsClassBuilder.Category(value="inventoryprofiles.config.category.client_side_tweaks")
        public static final ConfigHotkeyedBoolean INSTANT_MINING_COOLDOWN = ConfigsClassBuilder.hotkeyedBool(false);
        public static final ConfigHotkeyedBoolean DISABLE_BLOCK_BREAKING_COOLDOWN = ConfigsClassBuilder.hotkeyedBool(false);
        public static final ConfigHotkeyedBoolean DISABLE_ITEM_USE_COOLDOWN = ConfigsClassBuilder.hotkeyedBool(false);
        public static final ConfigHotkeyedBoolean PREVENT_CLOSE_GUI_DROP_ITEM = ConfigsClassBuilder.hotkeyedBool(false);
        public static final ConfigHotkeyedBoolean DISABLE_SCREEN_SHAKING_ON_DAMAGE = ConfigsClassBuilder.hotkeyedBool(false);
        public static final ConfigHotkeyedBoolean DISABLE_LAVA_FOG = ConfigsClassBuilder.hotkeyedBool(false);
    }

    @ConfigsClassBuilder.ConfigOptionsClass
    public static class Hotkeys {
        @ConfigsClassBuilder.Category(value="inventoryprofiles.config.category.hotkeys")
        public static final ConfigHotkey OPEN_CONFIG_MENU = ConfigsClassBuilder.hotkey("R,C", KeybindSettings.INGAME_DEFAULT);
        public static final ConfigHotkey SORT_INVENTORY = ConfigsClassBuilder.hotkey("R", KeybindSettings.GUI_DEFAULT);
        public static final ConfigHotkey SORT_INVENTORY_IN_COLUMNS = ConfigsClassBuilder.hotkey("");
        public static final ConfigHotkey SORT_INVENTORY_IN_ROWS = ConfigsClassBuilder.hotkey("");
        public static final ConfigHotkey MOVE_ALL_ITEMS = ConfigsClassBuilder.hotkey("");
        @ConfigsClassBuilder.Category(value="inventoryprofiles.config.category.debugs")
        public static final ConfigHotkey DEBUG_SCREEN = ConfigsClassBuilder.hotkey("Z", KeybindSettings.ANY_DEFAULT);
    }

    @ConfigsClassBuilder.ConfigOptionsClass
    public static class GuiSettings {
        @ConfigsClassBuilder.Category(value="inventoryprofiles.config.category.inventory")
        public static final ConfigBoolean SHOW_SORT_BUTTON = ConfigsClassBuilder.bool(true);
        public static final ConfigBoolean SHOW_SORT_IN_COLUMNS_BUTTON = ConfigsClassBuilder.bool(true);
        public static final ConfigBoolean SHOW_SORT_IN_ROWS_BUTTON = ConfigsClassBuilder.bool(true);
        public static final ConfigBoolean SHOW_MOVE_ALL_BUTTON = ConfigsClassBuilder.bool(true);
        public static final ConfigBoolean SHOW_BUTTON_TOOLTIPS = ConfigsClassBuilder.bool(true);
    }

    @ConfigsClassBuilder.ConfigOptionsClass
    public static class ModSettings {
        @ConfigsClassBuilder.Category(value="inventoryprofiles.config.category.inventory_sorting")
        public static final ConfigEnum<SortingMethodOption> SORT_ORDER = ConfigsClassBuilder.enumList(SortingMethodOption.DEFAULT);
        public static final ConfigBoolean ADD_INTERVAL_BETWEEN_CLICKS = ConfigsClassBuilder.bool(false);
        public static final ConfigInteger INTERVAL_BETWEEN_CLICKS_MS = ConfigsClassBuilder.integer(10, 1, 500);
        public static final ConfigBoolean RESTOCK_HOTBAR = ConfigsClassBuilder.bool(false);
        public static final ConfigBoolean SORT_AT_CURSOR = ConfigsClassBuilder.bool(false);
        public static final ConfigBoolean STOP_AT_SCREEN_CLOSE = ConfigsClassBuilder.bool(false);
        @ConfigsClassBuilder.Category(value="inventoryprofiles.config.category.debugs")
        public static final ConfigBoolean DEBUG_LOGS = ConfigsClassBuilder.bool(false);
    }
}

