/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.config;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IndentParser {
    private static final Pattern INDENT_REGEX = Pattern.compile("^[ \\\t]*");
    public boolean parsed = false;
    public Section root = null;
    public List<ErrorMessage> errorMsgs = new ArrayList<ErrorMessage>();
    public final List<String> lines;
    public final int maxLevel;

    public IndentParser(List<String> lines, int maxLevel) {
        this.lines = lines;
        this.maxLevel = maxLevel;
    }

    public IndentParser parse() {
        if (this.parsed) {
            return this;
        }
        this.root = new Section(-1, "", -1, -1, null);
        int lineNumber = 0;
        Section last = null;
        block0: for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            lineNumber = i + 1;
            if (line.trim().isEmpty()) continue;
            int indent = IndentParser.getIndent(line);
            if (last == null && indent != 0) {
                this.error(lineNumber, "Unexpected indent. Indent should be zero.");
                continue;
            }
            if (indent == 0) {
                last = new Section(lineNumber, line, 0, 0, this.root);
                continue;
            }
            if (indent < last.indent) {
                while (indent < last.indent) {
                    last = last.parent;
                }
                if (indent > last.indent) {
                    this.error(lineNumber, "Unexpected indent. Indent not aligned.");
                    ++i;
                    while (i < this.lines.size()) {
                        line = this.lines.get(i);
                        lineNumber = i + 1;
                        if (!line.trim().isEmpty()) {
                            if (IndentParser.getIndent(line) > last.indent) {
                                this.error(lineNumber, "Skipped. Due to last un-aligned line.");
                            } else {
                                --i;
                                continue block0;
                            }
                        }
                        ++i;
                    }
                    continue;
                }
            }
            last = this.maxLevel >= 0 && last.level >= this.maxLevel || indent == last.indent ? new Section(lineNumber, line, last.level, last.indent, last.parent) : new Section(lineNumber, line, last.level + 1, indent, last);
        }
        this.parsed = true;
        return this;
    }

    private void error(int lineNumber, String message) {
        this.errorMsgs.add(new ErrorMessage(lineNumber, message));
    }

    public static int getIndent(String line) {
        Matcher m = INDENT_REGEX.matcher(line);
        return m.find() ? m.group(0).length() : 0;
    }

    public static IndentParser parse(List<String> lines, int maxLevel) {
        return new IndentParser(lines, maxLevel).parse();
    }

    public static class ErrorMessage {
        public int lineNumber;
        public String message;

        public ErrorMessage(int lineNumber, String message) {
            this.lineNumber = lineNumber;
            this.message = message;
        }

        public String toString() {
            return this.lineNumber + ": " + this.message;
        }
    }

    public static class Section {
        public int lineNumber;
        public String text;
        public int level;
        public int indent;
        public List<Section> children = new ArrayList<Section>();
        public Section parent;

        public Section(int lineNumber, String text, int level, int indent, Section parent) {
            this.lineNumber = lineNumber;
            this.text = text;
            this.level = level;
            this.indent = indent;
            this.parent = parent;
            if (parent != null) {
                parent.children.add(this);
            }
        }

        public String toString() {
            return "L" + this.level + ":" + this.lineNumber + ": " + this.text.trim();
        }
    }
}

