/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.gui.inject;

import io.github.jsnimda.inventoryprofiles.config.Configs;
import io.github.jsnimda.inventoryprofiles.gui.ToolTips;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSorterPort;
import io.github.jsnimda.inventoryprofiles.sorter.predefined.SortingMethodProviders;
import io.github.jsnimda.inventoryprofiles.sorter.util.ContainerActions;
import io.github.jsnimda.inventoryprofiles.sorter.util.ContainerCategory;
import io.github.jsnimda.inventoryprofiles.sorter.util.Current;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_3871;
import net.minecraft.class_3873;
import net.minecraft.class_3874;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_479;
import net.minecraft.class_481;
import net.minecraft.class_490;

public class GuiSortingButtons {
    public static final class_2960 TEXTURE = new class_2960("inventoryprofiles", "textures/gui/gui_buttons.png");
    private class_437 screen;
    private class_1703 container;
    private int left;
    private int top;
    private int containerWidth;
    private int containerHeight;
    List<class_339> list = new ArrayList<class_339>();
    private int right_base_x;
    private int player_y;
    private int chest_y;
    private ContainerCategory cate;

    public GuiSortingButtons(class_437 screen, class_1703 container, int left, int top, int containerWidth, int containerHeight) {
        this.screen = screen;
        this.container = container;
        this.left = left;
        this.top = top;
        this.containerWidth = containerWidth;
        this.containerHeight = containerHeight;
    }

    public List<class_339> gets() {
        this.right_base_x = this.left + this.containerWidth - 17;
        this.player_y = this.top + this.containerHeight - 95;
        this.chest_y = this.top + 5;
        this.cate = ContainerCategory.of(this.container);
        if (this.cate == ContainerCategory.PLAYER_CREATIVE) {
            this.right_base_x -= 18;
        }
        boolean addChestSide = this.cate == ContainerCategory.SORTABLE_3x3 || this.cate == ContainerCategory.SORTABLE_9xN || this.cate == ContainerCategory.SORTABLE_Nx3 || this.cate == ContainerCategory.UNKNOWN;
        boolean addNonChestSide = this.cate == ContainerCategory.PLAYER_SURVIVAL || this.cate == ContainerCategory.PLAYER_CREATIVE;
        boolean shouldAdd = addChestSide || addNonChestSide;
        int x0 = this.right_base_x;
        if (Configs.GuiSettings.SHOW_MOVE_ALL_BUTTON.getBooleanValue() && GuiSortingButtons.showMoveAllButton(this.cate)) {
            this.list.add((class_339)this.moveAllButton(false, x0));
            if (this.cate.isStorage()) {
                this.list.add((class_339)this.moveAllButton(true, x0));
            }
            if (this.cate != ContainerCategory.PLAYER_SURVIVAL) {
                x0 -= 12;
            }
        }
        if (shouldAdd) {
            if (Configs.GuiSettings.SHOW_SORT_IN_ROWS_BUTTON.getBooleanValue()) {
                if (addChestSide) {
                    this.list.add((class_339)this.sortRowsButton(true, x0));
                }
                if (addNonChestSide) {
                    this.list.add((class_339)this.sortRowsButton(false, x0));
                }
                x0 -= 12;
            }
            if (Configs.GuiSettings.SHOW_SORT_IN_COLUMNS_BUTTON.getBooleanValue()) {
                if (addChestSide) {
                    this.list.add((class_339)this.sortColumnsButton(true, x0));
                }
                if (addNonChestSide) {
                    this.list.add((class_339)this.sortColumnsButton(false, x0));
                }
                x0 -= 12;
            }
            if (Configs.GuiSettings.SHOW_SORT_BUTTON.getBooleanValue()) {
                if (addChestSide) {
                    this.list.add((class_339)this.sortButton(true, x0));
                }
                if (addNonChestSide) {
                    this.list.add((class_339)this.sortButton(false, x0));
                }
                x0 -= 12;
            }
        }
        return this.list;
    }

    public static List<class_339> gets(class_437 screen, class_1703 container, int left, int top, int containerWidth, int containerHeight) {
        return new GuiSortingButtons(screen, container, left, top, containerWidth, containerHeight).gets();
    }

    private static boolean showMoveAllButton(ContainerCategory cate) {
        return cate.isStorage() || cate == ContainerCategory.CRAFTABLE_3x3 || cate == ContainerCategory.PLAYER_SURVIVAL;
    }

    private SortButtonWidget sortButton(boolean chestSide, int buttonX) {
        return new SortButtonWidget(buttonX, chestSide ? this.chest_y : this.player_y, 1, 0, x -> VirtualSorterPort.doSort(!chestSide, SortingMethodProviders.current(), VirtualSorterPort.GroupingType.PRESERVED), "inventoryprofiles.tooltip.sort_button");
    }

    private SortButtonWidget sortColumnsButton(boolean chestSide, int buttonX) {
        return new SortButtonWidget(buttonX, chestSide ? this.chest_y : this.player_y, 2, 0, x -> VirtualSorterPort.doSort(!chestSide, SortingMethodProviders.current(), VirtualSorterPort.GroupingType.COLUMNS), "inventoryprofiles.tooltip.sort_columns_button");
    }

    private SortButtonWidget sortRowsButton(boolean chestSide, int buttonX) {
        return new SortButtonWidget(buttonX, chestSide ? this.chest_y : this.player_y, 3, 0, x -> VirtualSorterPort.doSort(!chestSide, SortingMethodProviders.current(), VirtualSorterPort.GroupingType.ROWS), "inventoryprofiles.tooltip.sort_rows_button");
    }

    private SortButtonWidget moveAllButton(boolean chestSide, int buttonX) {
        return new SortButtonWidget(buttonX, chestSide ? this.chest_y : this.player_y - (this.cate == ContainerCategory.PLAYER_SURVIVAL ? 12 : 0), chestSide ? 6 : 5, 0, x -> ContainerActions.moveAllAlike(chestSide, class_437.hasShiftDown()), "inventoryprofiles.tooltip.move_all_button");
    }

    private static boolean isRecipeBookOpen() {
        if (Current.screen() instanceof class_490 || Current.screen() instanceof class_479) {
            return Current.recipeBook().method_14887();
        }
        if (Current.screen() instanceof class_3873) {
            return Current.recipeBook().method_14891();
        }
        if (Current.screen() instanceof class_3871) {
            return Current.recipeBook().method_17317();
        }
        if (Current.screen() instanceof class_3874) {
            return Current.recipeBook().method_17321();
        }
        return false;
    }

    public static class SortButtonWidget
    extends class_344 {
        String tooltipText = "";
        int originalX;

        public SortButtonWidget(int x, int y, int gx, int gy, class_4185.class_4241 pressAction, String tooltipText) {
            super(x, y, 10, 10, gx * 10, gy * 10, gy * 10 + 10, TEXTURE, pressAction);
            this.originalX = x;
            this.tooltipText = tooltipText;
        }

        public void renderButton(int int_1, int int_2, float float_1) {
            boolean isNarrow;
            this.x = this.originalX;
            if (Current.screen() instanceof class_481 && ((class_481)Current.screen()).method_2469() != class_1761.field_7918.method_7741()) {
                this.x = -20;
            }
            boolean bl = isNarrow = Current.screen().width < 379;
            if (GuiSortingButtons.isRecipeBookOpen() && !isNarrow) {
                this.x = this.originalX + 177 - 100;
            }
            super.renderButton(int_1, int_2, float_1);
            this.renderToolTip(int_1, int_2);
        }

        public void renderToolTip(int x, int y) {
            if (Configs.GuiSettings.SHOW_BUTTON_TOOLTIPS.getBooleanValue() && this.isHovered() && !this.tooltipText.isEmpty()) {
                ToolTips.add(class_1074.method_4662((String)this.tooltipText, (Object[])new Object[0]), x, y);
            }
        }
    }
}

