/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter;

import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemType;

public final class VirtualItemStack {
    public VirtualItemType itemType;
    public int count;

    public VirtualItemStack(VirtualItemType itemType, int count) {
        this.itemType = itemType;
        this.count = count;
    }

    public int getMaxCount() {
        return this.itemType.getMaxCount();
    }

    public boolean sameType(VirtualItemStack b) {
        return this.itemType.equals(b.itemType);
    }

    public int add(int anotherCount) {
        int j = this.capOf(this.count + anotherCount) - this.count;
        this.count += j;
        return anotherCount - j;
    }

    public int tryAdd(int anotherCount) {
        return this.capOf(this.count + anotherCount);
    }

    public int capOf(int count) {
        return Math.min(count, this.getMaxCount());
    }

    public int getCappedCount() {
        return this.capOf(this.count);
    }

    public boolean isFull() {
        return this.count >= this.getMaxCount();
    }

    public VirtualItemStack copy() {
        return new VirtualItemStack(this.itemType, this.count);
    }

    public VirtualItemStack copy(int count) {
        return new VirtualItemStack(this.itemType, count);
    }

    public VirtualItemStack copy(VirtualItemType itemtype) {
        return new VirtualItemStack(itemtype, this.count);
    }

    public void updateEmpty() {
        if (this.itemType.isEmpty() || this.count <= 0) {
            this.setEmpty();
        }
    }

    public boolean isEmpty() {
        if (this.itemType.isEmpty() || this.count <= 0) {
            this.setEmpty();
            return true;
        }
        return false;
    }

    public void setEmpty() {
        this.itemType = VirtualItemType.EMPTY;
        this.count = 0;
    }

    public boolean capable(VirtualItemStack b) {
        return this.sameType(b) || this.isEmpty() || b.isEmpty();
    }

    public void swap(VirtualItemStack another) {
        VirtualItemType ctype = this.itemType;
        this.itemType = another.itemType;
        another.itemType = ctype;
        int tmpcount = this.count;
        this.count = another.count;
        another.count = tmpcount;
    }

    public boolean preTransfer(VirtualItemStack another) {
        if (!this.capable(another)) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (another.isFull()) {
            return false;
        }
        if (another.isEmpty()) {
            another.itemType = this.itemType;
            another.count = 0;
        }
        return true;
    }

    public boolean transferTo(VirtualItemStack another) {
        if (!this.preTransfer(another)) {
            return false;
        }
        this.count = another.add(this.count);
        this.updateEmpty();
        return true;
    }

    public boolean transferOneTo(VirtualItemStack another) {
        if (!this.preTransfer(another)) {
            return false;
        }
        --this.count;
        ++another.count;
        this.updateEmpty();
        return true;
    }

    public int splitHalf() {
        int del = this.count - this.count / 2;
        this.count -= del;
        return del;
    }

    public boolean splitHalfTo(VirtualItemStack another) {
        if (!this.capable(another)) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (!another.isEmpty()) {
            return false;
        }
        another.itemType = this.itemType;
        another.count = this.splitHalf();
        this.updateEmpty();
        return true;
    }

    public static VirtualItemStack empty() {
        return new VirtualItemStack(VirtualItemType.EMPTY, 0);
    }

    public String toString() {
        return this.count + "x " + this.itemType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.count;
        result = 31 * result + (this.itemType == null ? 0 : this.itemType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualItemStack other = (VirtualItemStack)obj;
        if (this.count != other.count) {
            return false;
        }
        return !(this.itemType == null ? other.itemType != null : !this.itemType.equals(other.itemType));
    }
}

