/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter;

import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemStack;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class VirtualSlotsStats {
    public final int size;
    public final List<VirtualItemStack> uniquified;
    public final List<Integer> emptyIndexes;
    private HashMap<VirtualItemType, ItemTypeStats> infos = null;
    private List<ItemTypeStats> infosAsList = null;
    private int minTotalStackCount = -1;
    private int maxTotalStackCount = -1;

    public VirtualSlotsStats(List<VirtualItemStack> items) {
        this.size = items.size();
        this.uniquified = VirtualSlotsStats.uniquify(items);
        this.emptyIndexes = VirtualSlotsStats.getEmptyIndexes(this.uniquified);
    }

    public ItemTypeStats getInfo(VirtualItemType type) {
        return this.getOrDefault(type, x -> x, ItemTypeStats.empty(type));
    }

    public <T> T getOrDefault(VirtualItemType type, Function<ItemTypeStats, T> func, T defaultValue) {
        ItemTypeStats j = this.getInfos().get(type);
        return j == null ? defaultValue : func.apply(j);
    }

    public int getMinTotalStackCount() {
        if (this.minTotalStackCount < 0) {
            this.minTotalStackCount = this.getInfos().values().stream().mapToInt(x -> x.stackCount).sum();
        }
        return this.minTotalStackCount;
    }

    public int getMaxTotalStackCount() {
        if (this.maxTotalStackCount < 0) {
            this.maxTotalStackCount = this.getInfos().values().stream().mapToInt(x -> x.totalCount).sum();
        }
        return this.maxTotalStackCount;
    }

    public List<VirtualItemStack> asItemStacks() {
        return this.getInfosAsList(x -> x.asItemStack());
    }

    public List<VirtualItemType> getItemTypes() {
        return this.getInfosAsList(x -> x.type);
    }

    public <T> List<T> getInfosAsListIgnoreOrder(Function<ItemTypeStats, T> func) {
        return this.getInfos().values().stream().map(func).collect(Collectors.toList());
    }

    public <T> Map<VirtualItemType, T> getInfosAsMap(Function<ItemTypeStats, T> func) {
        return this.getInfos().values().stream().collect(Collectors.toMap(x -> x.type, func));
    }

    public <T> List<T> getInfosAsList(Function<ItemTypeStats, T> func) {
        return this.getInfosAsList().stream().map(func).collect(Collectors.toList());
    }

    public List<ItemTypeStats> getInfosAsList() {
        if (this.infosAsList == null) {
            ArrayList<ItemTypeStats> res = new ArrayList<ItemTypeStats>();
            HashSet appeared = new HashSet();
            this.uniquified.forEach(x -> {
                if (x.isEmpty()) {
                    return;
                }
                if (!appeared.contains(x.itemType)) {
                    res.add(this.getInfo(x.itemType));
                    appeared.add(x.itemType);
                }
            });
            this.infosAsList = res;
        }
        return this.infosAsList;
    }

    public Map<VirtualItemType, ItemTypeStats> getInfos() {
        if (this.infos == null) {
            this.infos = VirtualSlotsStats.getInfos(this.uniquified);
        }
        return this.infos;
    }

    public static HashMap<VirtualItemType, ItemTypeStats> getInfos(List<VirtualItemStack> uniquified) {
        HashMap<VirtualItemType, ItemTypeStats.Builder> infoBuilders = new HashMap<VirtualItemType, ItemTypeStats.Builder>();
        for (int i = 0; i < uniquified.size(); ++i) {
            VirtualItemStack x2 = uniquified.get(i);
            if (x2.isEmpty()) continue;
            if (!infoBuilders.containsKey(x2.itemType)) {
                infoBuilders.put(x2.itemType, ItemTypeStats.builder(x2.itemType));
            }
            ((ItemTypeStats.Builder)infoBuilders.get(x2.itemType)).addInfo(x2.count, i);
        }
        return infoBuilders.values().stream().collect(Collectors.toMap(x -> x.type, x -> x.build(), (prev, next) -> next, HashMap::new));
    }

    public static int getStackCount(VirtualItemType type, int total) {
        int max = type.getMaxCount();
        return (total + max - 1) / max;
    }

    public static List<VirtualItemStack> uniquify(List<VirtualItemStack> items) {
        HashMap uniquifiedTypes = new HashMap();
        return items.stream().map(x -> {
            if (x.isEmpty()) {
                return VirtualItemStack.empty();
            }
            if (!uniquifiedTypes.containsKey(x.itemType)) {
                uniquifiedTypes.put(x.itemType, x.itemType);
            }
            return new VirtualItemStack((VirtualItemType)uniquifiedTypes.get(x.itemType), x.getCappedCount());
        }).collect(Collectors.toList());
    }

    public static List<Integer> getEmptyIndexes(List<VirtualItemStack> items) {
        return IntStream.range(0, items.size()).filter(s -> ((VirtualItemStack)items.get(s)).isEmpty()).boxed().collect(Collectors.toList());
    }

    public static class ItemTypeStats {
        public final VirtualItemType type;
        public final int totalCount;
        public final int stackCount;
        public final List<Integer> indexes;

        private ItemTypeStats(VirtualItemType type, int totalCount, List<Integer> indexes) {
            this.type = type;
            this.totalCount = totalCount;
            this.stackCount = VirtualSlotsStats.getStackCount(type, totalCount);
            this.indexes = indexes;
        }

        public VirtualItemStack asItemStack() {
            return new VirtualItemStack(this.type, this.totalCount);
        }

        public static ItemTypeStats empty(VirtualItemType type) {
            return new ItemTypeStats(type, 0, Collections.emptyList());
        }

        public static Builder builder(VirtualItemType type) {
            return new Builder(type);
        }

        public static class Builder {
            public final VirtualItemType type;
            private int totalCount = 0;
            private List<Integer> indexes = new ArrayList<Integer>();

            public Builder(VirtualItemType type) {
                this.type = type;
            }

            public Builder addInfo(int count, int slot) {
                this.totalCount += count;
                this.indexes.add(slot);
                return this;
            }

            public ItemTypeStats build() {
                return new ItemTypeStats(this.type, this.totalCount, this.indexes);
            }
        }
    }
}

