/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter.predefined;

import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemType;
import io.github.jsnimda.inventoryprofiles.sorter.util.Current;
import io.github.jsnimda.inventoryprofiles.sorter.util.ItemUtils;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2487;

public class BuiltInMethods {
    public static Map<String, Comparator<VirtualItemType>> methods = new HashMap<String, Comparator<VirtualItemType>>();

    public static int compareString(String a, String b, StringCompareMethod m) {
        if (m == StringCompareMethod.IGNORE_CASE) {
            return a.compareToIgnoreCase(b);
        }
        if (m == StringCompareMethod.UNICODE) {
            return a.compareTo(b);
        }
        if (m == StringCompareMethod.LOCALE) {
            String langTag = Current.languageCode().replace('_', '-');
            Collator c = Collator.getInstance(Locale.forLanguageTag(langTag));
            return c.compare(a, b);
        }
        throw new AssertionError((Object)"Unreachable");
    }

    public static int custom_name(VirtualItemType a, VirtualItemType b, StringCompareMethod m) {
        int bHas;
        int aHas = ItemUtils.getItemStack(a).method_7938() ? 1 : 0;
        int n = bHas = ItemUtils.getItemStack(b).method_7938() ? 1 : 0;
        if (aHas == 1 && bHas == 1) {
            String aStr = ItemUtils.getItemStack(a).method_7964().getString();
            String bStr = ItemUtils.getItemStack(b).method_7964().getString();
            return BuiltInMethods.compareString(aStr, bStr, m);
        }
        return bHas - aHas;
    }

    public static int translated_name(VirtualItemType a, VirtualItemType b, StringCompareMethod m) {
        String aStr = ItemUtils.getTranslatedName(a);
        String bStr = ItemUtils.getTranslatedName(b);
        return BuiltInMethods.compareString(aStr, bStr, m);
    }

    public static int display_name(VirtualItemType a, VirtualItemType b, StringCompareMethod m) {
        String aStr = ItemUtils.getItemStack(a).method_7964().getString();
        String bStr = ItemUtils.getItemStack(b).method_7964().getString();
        return BuiltInMethods.compareString(aStr, bStr, m);
    }

    public static int getGroupIndex(VirtualItemType type) {
        if (type.item.method_7859() == null && type.item == class_1802.field_8598) {
            return class_1761.field_7930.method_7741();
        }
        int groupCount = class_1761.field_7921.length;
        if (type.item.method_7859() == null) {
            return "minecraft".equals(ItemUtils.getItemId(type.item).method_12836()) ? class_1761.field_7932.method_7741() : groupCount;
        }
        return type.item.method_7859().method_7741();
    }

    public static double getEnchantmentsScore(VirtualItemType type) {
        Map enc = class_1890.method_8222((class_1799)ItemUtils.getItemStack(type));
        double score = 0.0;
        for (Map.Entry e : enc.entrySet()) {
            if (((class_1887)e.getKey()).method_8195()) continue;
            score += (double)((Integer)e.getValue()).intValue() / (double)((class_1887)e.getKey()).method_8183();
        }
        return score;
    }

    public static int item_id(VirtualItemType a, VirtualItemType b) {
        String itemIdA = ItemUtils.getItemIdString(a.item);
        String itemIdB = ItemUtils.getItemIdString(b.item);
        return itemIdA.compareTo(itemIdB);
    }

    public static int has_custom_name(VirtualItemType a, VirtualItemType b) {
        int aHas = ItemUtils.getItemStack(a).method_7938() ? 1 : 0;
        int bHas = ItemUtils.getItemStack(b).method_7938() ? 1 : 0;
        return bHas - aHas;
    }

    public static int custom_name_ignore_case(VirtualItemType a, VirtualItemType b) {
        return BuiltInMethods.custom_name(a, b, StringCompareMethod.IGNORE_CASE);
    }

    public static int custom_name_locale(VirtualItemType a, VirtualItemType b) {
        return BuiltInMethods.custom_name(a, b, StringCompareMethod.LOCALE);
    }

    public static int custom_name_unicode(VirtualItemType a, VirtualItemType b) {
        return BuiltInMethods.custom_name(a, b, StringCompareMethod.UNICODE);
    }

    public static int translation_key(VirtualItemType a, VirtualItemType b) {
        String aKey = ItemUtils.getItemStack(a).method_7922();
        String bKey = ItemUtils.getItemStack(b).method_7922();
        return aKey.compareTo(bKey);
    }

    public static int translated_name_ignore_case(VirtualItemType a, VirtualItemType b) {
        return BuiltInMethods.translated_name(a, b, StringCompareMethod.IGNORE_CASE);
    }

    public static int translated_name_locale(VirtualItemType a, VirtualItemType b) {
        return BuiltInMethods.translated_name(a, b, StringCompareMethod.LOCALE);
    }

    public static int translated_name_unicode(VirtualItemType a, VirtualItemType b) {
        return BuiltInMethods.translated_name(a, b, StringCompareMethod.UNICODE);
    }

    public static int display_name_ignore_case(VirtualItemType a, VirtualItemType b) {
        return BuiltInMethods.display_name(a, b, StringCompareMethod.IGNORE_CASE);
    }

    public static int display_name_locale(VirtualItemType a, VirtualItemType b) {
        return BuiltInMethods.display_name(a, b, StringCompareMethod.LOCALE);
    }

    public static int display_name_unicode(VirtualItemType a, VirtualItemType b) {
        return BuiltInMethods.display_name(a, b, StringCompareMethod.UNICODE);
    }

    public static int creative_menu_groups(VirtualItemType a, VirtualItemType b) {
        int aGp = BuiltInMethods.getGroupIndex(a);
        int bGp = BuiltInMethods.getGroupIndex(b);
        return aGp - bGp;
    }

    public static int raw_id(VirtualItemType a, VirtualItemType b) {
        int aInt = class_1792.method_7880((class_1792)a.item);
        int bInt = class_1792.method_7880((class_1792)b.item);
        return aInt - bInt;
    }

    public static int enchantments(VirtualItemType a, VirtualItemType b) {
        double bScore;
        double aScore = BuiltInMethods.getEnchantmentsScore(a);
        if (aScore > (bScore = BuiltInMethods.getEnchantmentsScore(b))) {
            return -1;
        }
        if (bScore > aScore) {
            return 1;
        }
        return 0;
    }

    public static int damage(VirtualItemType a, VirtualItemType b) {
        int aDmg = ItemUtils.getDamage(a);
        int bDmg = ItemUtils.getDamage(b);
        return aDmg - bDmg;
    }

    public static int has_potion_effects(VirtualItemType a, VirtualItemType b) {
        int aHas = class_1844.method_8066((class_2487)a.tag).isEmpty() ? 0 : 1;
        int bHas = class_1844.method_8066((class_2487)b.tag).isEmpty() ? 0 : 1;
        return bHas - aHas;
    }

    public static int has_custom_potion_effects(VirtualItemType a, VirtualItemType b) {
        int aHas = class_1844.method_8060((class_2487)a.tag).isEmpty() ? 0 : 1;
        int bHas = class_1844.method_8060((class_2487)b.tag).isEmpty() ? 0 : 1;
        return bHas - aHas;
    }

    public static int potion_name(VirtualItemType a, VirtualItemType b) {
        int bHas;
        int aHas = ItemUtils.hasPotionName(a) ? 1 : 0;
        int n = bHas = ItemUtils.hasPotionName(b) ? 1 : 0;
        if (aHas == 1 && bHas == 1) {
            String aStr = ItemUtils.getPotionRegularName(a);
            String bStr = ItemUtils.getPotionRegularName(b);
            return aStr.compareTo(bStr);
        }
        return bHas - aHas;
    }

    public static int potion_effects(VirtualItemType a, VirtualItemType b) {
        int bHas;
        List aList = class_1844.method_8066((class_2487)a.tag);
        List bList = class_1844.method_8066((class_2487)b.tag);
        int aHas = aList.isEmpty() ? 0 : 1;
        int n = bHas = bList.isEmpty() ? 0 : 1;
        if (aHas == 1 && bHas == 1) {
            return ItemUtils.compareEffects(aList, bList);
        }
        return bHas - aHas;
    }

    public static int nbt(VirtualItemType a, VirtualItemType b) {
        int bHas;
        int aHas = a.tag == null ? 0 : 1;
        int n = bHas = b.tag == null ? 0 : 1;
        if (aHas == 1 && bHas == 1) {
            String aStr = a.tag.toString();
            String bStr = b.tag.toString();
            return aStr.compareTo(bStr);
        }
        return bHas - aHas;
    }

    static {
        methods.put("item_id", BuiltInMethods::item_id);
        methods.put("has_custom_name", BuiltInMethods::has_custom_name);
        methods.put("custom_name_ignore_case", BuiltInMethods::custom_name_ignore_case);
        methods.put("custom_name_locale", BuiltInMethods::custom_name_locale);
        methods.put("custom_name_unicode", BuiltInMethods::custom_name_unicode);
        methods.put("translation_key", BuiltInMethods::translation_key);
        methods.put("translated_name_ignore_case", BuiltInMethods::translated_name_ignore_case);
        methods.put("translated_name_locale", BuiltInMethods::translated_name_locale);
        methods.put("translated_name_unicode", BuiltInMethods::translated_name_unicode);
        methods.put("display_name_ignore_case", BuiltInMethods::display_name_ignore_case);
        methods.put("display_name_locale", BuiltInMethods::display_name_locale);
        methods.put("display_name_unicode", BuiltInMethods::display_name_unicode);
        methods.put("creative_menu_groups", BuiltInMethods::creative_menu_groups);
        methods.put("raw_id", BuiltInMethods::raw_id);
        methods.put("enchantments", BuiltInMethods::enchantments);
        methods.put("damage", BuiltInMethods::damage);
        methods.put("has_potion_effects", BuiltInMethods::has_potion_effects);
        methods.put("has_custom_potion_effects", BuiltInMethods::has_custom_potion_effects);
        methods.put("potion_name", BuiltInMethods::potion_name);
        methods.put("potion_effects", BuiltInMethods::potion_effects);
        methods.put("nbt", BuiltInMethods::nbt);
    }

    public static enum StringCompareMethod {
        IGNORE_CASE,
        LOCALE,
        UNICODE;

    }
}

