/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter.predefined;

import io.github.jsnimda.inventoryprofiles.sorter.ISortingMethodProvider;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemStack;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemType;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSlotsStats;
import io.github.jsnimda.inventoryprofiles.sorter.predefined.ConvertedComparator;
import io.github.jsnimda.inventoryprofiles.sorter.util.CodeUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ComparatorBasedSorter
implements ISortingMethodProvider {
    private final Comparator<VirtualItemStack> comparator;

    @Override
    public List<VirtualItemStack> sort(List<VirtualItemStack> items) {
        VirtualSlotsStats stats = new VirtualSlotsStats(items);
        List<VirtualItemStack> collapsed = stats.asItemStacks();
        collapsed.sort(this.comparator);
        return CodeUtils.pad(ComparatorBasedSorter.uncollapse(collapsed), items.size(), () -> VirtualItemStack.empty());
    }

    public static List<VirtualItemStack> uncollapse(List<VirtualItemStack> items) {
        ArrayList<VirtualItemStack> res = new ArrayList<VirtualItemStack>();
        for (VirtualItemStack v : items) {
            int del;
            for (int c = v.count; c > 0; c -= del) {
                del = v.capOf(c);
                res.add(v.copy(del));
            }
        }
        return res;
    }

    public ComparatorBasedSorter(Comparator<VirtualItemType> comparator) {
        this.comparator = ConvertedComparator.convert(x -> x.itemType, comparator);
    }
}

