/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter.util;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CodeUtils {
    public static List<Integer> weightedScaleUp(List<Integer> weights, int sum) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        ArrayList<Integer> cu = new ArrayList<Integer>();
        int c = 0;
        for (int w : weights) {
            cu.add(c += w);
        }
        int k = 0;
        for (int i = 1; i < weights.size(); ++i) {
            int k2 = sum * (Integer)cu.get(i) / c;
            ints.add(k2 - k);
            k = k2;
        }
        return ints;
    }

    public static List<Integer> distribute(int sum, int size) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        int k = 0;
        for (int i = 1; i <= size; ++i) {
            int k2 = sum * i / size;
            ints.add(k2 - k);
            k = k2;
        }
        return ints;
    }

    public static List<Integer> distributeMonontonic(int sum, int size) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        int quo = sum / size;
        int rem = sum - size * quo;
        for (int i = 1; i <= size; ++i) {
            ints.add(i <= rem ? quo + 1 : quo);
        }
        return ints;
    }

    public static int divideUp(int dividend, int divisor) {
        return (dividend + divisor - 1) / divisor;
    }

    public static <T> List<T> pad(List<T> list, int size, Supplier<? extends T> zerosSupplier) {
        while (list.size() < size) {
            list.add(zerosSupplier.get());
        }
        return list;
    }

    public static <T> T selectFirst(Collection<? extends T> objects, Comparator<? super T> comparator) {
        Object res = null;
        for (T r : objects) {
            if (res != null && comparator.compare(r, res) >= 0) continue;
            res = r;
        }
        return res;
    }

    public static <T, R> MappedObject<T, R> selectFirst(Collection<? extends T> objects, Function<? super T, ? extends R> mapper, Comparator<? super MappedObject<T, R>> comparator) {
        return CodeUtils.selectFirst(objects.stream().map(x -> new MappedObject(x, mapper.apply(x))).collect(Collectors.toList()), comparator);
    }

    public static <T> void timedTasks(final List<? extends T> objects, final BiConsumer<? super T, Timer> action, int interval, final Runnable finalize) {
        if (interval <= 0) {
            for (T a : objects) {
                action.accept(a, null);
            }
            finalize.run();
        } else {
            final Timer timer = new Timer();
            timer.scheduleAtFixedRate(new TimerTask(){
                Iterator<? extends T> it;
                {
                    this.it = objects.iterator();
                }

                @Override
                public void run() {
                    if (this.it.hasNext()) {
                        Object a = this.it.next();
                        action.accept(a, timer);
                    } else {
                        timer.cancel();
                        finalize.run();
                    }
                }
            }, 0L, (long)interval);
        }
    }

    public static class MappedObject<T, R> {
        public T value;
        public R mappedValue;

        public MappedObject(T value, R mappedValue) {
            this.value = value;
            this.mappedValue = mappedValue;
        }
    }
}

