/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter.util;

import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemStack;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemType;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class Converter {
    public static VirtualItemStack toVirtualItemStack(class_1799 item) {
        return item.method_7960() ? VirtualItemStack.empty() : new VirtualItemStack(Converter.toVirtualItemType(item), item.method_7947());
    }

    public static VirtualItemType toVirtualItemType(class_1799 itemStack) {
        return new VirtualItemType(itemStack.method_7909(), itemStack.method_7969());
    }

    public static List<VirtualItemStack> toVirtualItemStackList(List<class_1735> slots) {
        return Converter.map(slots, x -> Converter.toVirtualItemStack(x.method_7677()));
    }

    public static List<VirtualItemStack> copy(List<VirtualItemStack> items) {
        return Converter.map(items, x -> x.copy());
    }

    public static VirtualSlot toVirtualSlot(class_1735 slot) {
        return new VirtualSlot(slot, Converter.toVirtualItemStack(slot.method_7677()));
    }

    public static List<VirtualSlot> toVirtualSlotList(List<class_1735> slots) {
        return Converter.map(slots, x -> Converter.toVirtualSlot(x));
    }

    public static <T, R> List<R> map(List<T> list, Function<T, R> func) {
        return list.stream().map(func).collect(Collectors.toList());
    }

    public static <T, R> List<R> concat(List<T> a, List<T> b, Function<T, R> mapper) {
        ArrayList<R> res = new ArrayList<R>();
        res.addAll(Converter.map(a, mapper));
        res.addAll(Converter.map(b, mapper));
        return res;
    }
}

