/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class WeightedRandom<T> {
    private int size = 0;
    private List<WeightedObject> objects = new ArrayList<WeightedObject>();
    private double totalWeight = 0.0;

    public WeightedRandom<T> add(T object, double weight) {
        this.objects.add(new WeightedObject(object, weight));
        return this;
    }

    public T next() {
        double random = Math.random() * this.totalWeight;
        int sel = Collections.binarySearch(this.objects, new WeightedObject(random));
        return sel < 0 ? null : (T)this.objects.get((int)sel).object;
    }

    public static <T> WeightedRandom<T> of(Collection<? extends T> objects, Function<? super T, Double> weightFunction) {
        WeightedRandom res = new WeightedRandom();
        objects.forEach(x -> res.add(x, (Double)weightFunction.apply(x)));
        return res;
    }

    private class WeightedObject
    implements Comparable<WeightedObject> {
        public int index;
        public T object;
        public double cumulativeWeightStart;
        public double cumulativeWeightEnd;

        public WeightedObject(T object, double weight) {
            this.index = WeightedRandom.this.size++;
            this.object = object;
            this.cumulativeWeightStart = WeightedRandom.this.totalWeight;
            this.cumulativeWeightEnd = WeightedRandom.this.totalWeight = WeightedRandom.this.totalWeight + weight;
        }

        public WeightedObject(double cumulativeWeight) {
            this.index = -1;
            this.object = null;
            this.cumulativeWeightStart = this.cumulativeWeightEnd = cumulativeWeight;
        }

        @Override
        public int compareTo(WeightedObject o) {
            if (this.index != -1 && o.index != -1) {
                return this.index - o.index;
            }
            if (this.index == -1 && o.index == -1) {
                return 0;
            }
            double s = this.index == -1 ? this.cumulativeWeightStart : o.cumulativeWeightStart;
            return this.index == -1 ? this.compare(s, o) : -this.compare(s, this);
        }

        public int compare(double cumulativeWeight, WeightedObject another) {
            if (cumulativeWeight < another.cumulativeWeightStart) {
                return -1;
            }
            if (cumulativeWeight < another.cumulativeWeightEnd) {
                return 0;
            }
            return 1;
        }
    }
}

