/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.github.jsnimda.common.config.IConfigElement;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_310;
import org.apache.commons.io.FileUtils;

public class ConfigSaveLoadManager {
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final IConfigElement config;
    private final String path;

    public static File getConfigDirectory() {
        return new File(class_310.method_1551().field_1697, "config");
    }

    public ConfigSaveLoadManager(IConfigElement config, String path) {
        this.config = config;
        this.path = path;
    }

    private File getConfigFile() {
        return ConfigSaveLoadManager.getConfigDirectory().toPath().resolve(this.path).toFile();
    }

    public void save() {
        String val = this.GSON.toJson(this.config.toJsonElement());
        try {
            FileUtils.writeStringToFile((File)this.getConfigFile(), (String)val, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        if (!this.getConfigFile().exists()) {
            return;
        }
        try {
            String val = FileUtils.readFileToString((File)this.getConfigFile(), (Charset)StandardCharsets.UTF_8);
            JsonElement element = new JsonParser().parse(val);
            this.config.fromJsonElement(element);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
    }
}

