/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.config;

import com.google.common.base.CaseFormat;
import io.github.jsnimda.common.config.CategorizedConfigOptions;
import io.github.jsnimda.common.config.IConfigOption;
import io.github.jsnimda.common.config.options.ConfigBoolean;
import io.github.jsnimda.common.config.options.ConfigEnum;
import io.github.jsnimda.common.config.options.ConfigHotkey;
import io.github.jsnimda.common.config.options.ConfigHotkeyedBoolean;
import io.github.jsnimda.common.config.options.ConfigInteger;
import io.github.jsnimda.common.input.KeybindSettings;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class ConfigsClassBuilder {
    public static ConfigBoolean bool(boolean defaultValue) {
        return new ConfigBoolean(defaultValue);
    }

    public static ConfigInteger integer(int defaultValue, int minValue, int maxValue) {
        return new ConfigInteger(defaultValue, minValue, maxValue);
    }

    public static <T extends Enum<T>> ConfigEnum<T> enumList(T defaultValue) {
        return new ConfigEnum<T>(defaultValue);
    }

    public static ConfigHotkey hotkey(String defaultValue) {
        return new ConfigHotkey(defaultValue, KeybindSettings.INGAME_DEFAULT);
    }

    public static ConfigHotkey hotkey(String defaultValue, KeybindSettings defaultSettings) {
        return new ConfigHotkey(defaultValue, defaultSettings);
    }

    public static ConfigHotkeyedBoolean hotkeyedBool(boolean defaultValue) {
        return new ConfigHotkeyedBoolean(defaultValue);
    }

    public static CategorizedConfigOptions load(Class<?> configOptionsClass) {
        Field[] fields;
        CategorizedConfigOptions cates = new CategorizedConfigOptions();
        cates.setKey(configOptionsClass.getSimpleName());
        for (Field field : fields = configOptionsClass.getDeclaredFields()) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod) || !Modifier.isFinal(mod)) continue;
            try {
                Object fieldValue = field.get(null);
                if (!(fieldValue instanceof IConfigOption) || field.getAnnotation(Exclude.class) != null) continue;
                Category categoryAnnotation = field.getAnnotation(Category.class);
                if (categoryAnnotation != null) {
                    cates.addCategory(categoryAnnotation.value());
                }
                IConfigOption configOption = (IConfigOption)fieldValue;
                configOption.setKey(CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, field.getName()));
                cates.addConfigOption(configOption);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return cates;
    }

    public static CategorizedConfigOptions loadWithNested(Class<?> configOptionsOuterClass, boolean isDeep) {
        Class<?>[] classes;
        CategorizedConfigOptions cates = new CategorizedConfigOptions();
        for (Class<?> clazz : classes = configOptionsOuterClass.getDeclaredClasses()) {
            int mod = clazz.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod) || clazz.getAnnotation(ConfigOptionsClass.class) == null) continue;
            cates.addConfigOption(isDeep ? ConfigsClassBuilder.loadWithNested(clazz, true) : ConfigsClassBuilder.load(clazz));
        }
        return cates;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Exclude {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConfigOptionsClass {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Category {
        public String value();
    }
}

