/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.jsnimda.common.config.IConfigElementResettable;
import io.github.jsnimda.common.config.IConfigOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public interface IConfigElementResettableMultiple
extends IConfigElementResettable {
    default public Map<String, ? extends IConfigOption> getConfigOptionsMapFromConfigOptionsCollection() {
        HashMap<String, IConfigOption> map = new HashMap<String, IConfigOption>();
        for (IConfigOption iConfigOption : this.getConfigOptions()) {
            map.put(iConfigOption.getKey(), iConfigOption);
        }
        return map;
    }

    public Map<String, ? extends IConfigOption> getConfigOptionsMap();

    default public Collection<? extends IConfigOption> getConfigOptionsCollectionFromConfigOptionsMap() {
        return this.getConfigOptionsMap().values();
    }

    public Collection<? extends IConfigOption> getConfigOptions();

    @Override
    default public JsonElement toJsonElement() {
        JsonObject obj = new JsonObject();
        for (IConfigOption iConfigOption : this.getConfigOptions()) {
            if (!iConfigOption.isModified()) continue;
            obj.add(iConfigOption.getKey(), iConfigOption.toJsonElement());
        }
        return obj;
    }

    @Override
    default public void fromJsonElement(JsonElement element) {
        this.resetToDefault();
        if (element.isJsonObject()) {
            for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                Map<String, ? extends IConfigOption> configOptionsMap = this.getConfigOptionsMap();
                if (!configOptionsMap.containsKey(entry.getKey())) continue;
                configOptionsMap.get(entry.getKey()).fromJsonElement((JsonElement)entry.getValue());
            }
        }
    }

    @Override
    default public boolean isModified() {
        return this.getConfigOptions().stream().anyMatch(x -> x.isModified());
    }

    @Override
    default public void resetToDefault() {
        this.getConfigOptions().forEach(x -> x.resetToDefault());
    }
}

