/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.config.options;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.github.jsnimda.common.config.ConfigOptionBase;
import io.github.jsnimda.common.config.IConfigOptionPrimitive;
import io.github.jsnimda.common.config.IConfigOptionToggleable;

public class ConfigEnum<E extends Enum<E>>
extends ConfigOptionBase
implements IConfigOptionPrimitive<E>,
IConfigOptionToggleable {
    private final E defaultValue;
    private E value;

    public ConfigEnum(E defaultValue) {
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    @Override
    public void toggleNext() {
        Enum[] values = (Enum[])((Enum)this.value).getDeclaringClass().getEnumConstants();
        this.value = values[(((Enum)this.value).ordinal() + 1) % values.length];
    }

    @Override
    public void togglePrevious() {
        Enum[] values = (Enum[])((Enum)this.value).getDeclaringClass().getEnumConstants();
        this.value = values[(((Enum)this.value).ordinal() + values.length - 1) % values.length];
    }

    @Override
    public E getValue() {
        return this.value;
    }

    @Override
    public E getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setValue(E value) {
        this.value = value == null ? this.defaultValue : value;
    }

    @Override
    public JsonElement toJsonElement() {
        return new JsonPrimitive(((Enum)this.value).name());
    }

    @Override
    public void fromJsonElement(JsonElement element) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            this.setValue((E)Enum.valueOf(((Enum)this.value).getDeclaringClass(), element.getAsString()));
        }
    }
}

