/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.gui;

import io.github.jsnimda.common.gui.AnchoredListWidget;
import io.github.jsnimda.common.gui.ScrollableContainerWidget;
import io.github.jsnimda.common.gui.TextButtonWidget;
import io.github.jsnimda.common.gui.VHLine;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_310;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;

public class AnchoredListWidget<E extends Entry>
extends class_362
implements class_4068 {
    private List<class_364> children = new ArrayList<class_364>();
    private List<E> entries = new ArrayList();
    private int entriesTotalHeight = 0;
    private int x;
    private int y;
    private int width;
    private int height;
    public boolean renderBorder = true;
    public boolean showAnchorsHeader = true;
    protected int anchorHeaderHeight = 13;
    private ScrollableContainerWidget container = new ScrollableContainerWidget();
    protected AnchorHeader anchorHeader = new AnchorHeader();
    private static final int COLOR_ANCHOR_BORDER = -2137417319;
    private static final int COLOR_ANCHOR_BG = 0x40999999;
    private static final int COLOR_ANCHOR_BORDER_HOVER = -6710887;
    private static final int COLOR_ANCHOR_BG_HOVER = -1063675495;
    private static final int COLOR_WHITE = -1;
    private static final int COLOR_BORDER = -6710887;
    public int borderColor = -6710887;

    public AnchoredListWidget(int x, int y, int width, int height) {
        this.children.add((class_364)this.anchorHeader);
        this.children.add(this.container);
        this.setBounds(x, y, width, height);
        this.container.setContentRenderer((mx, my, p, vx, vy, vw, vh, sy) -> {
            int dy = vy - sy;
            for (Entry e : this.entries) {
                int eh = e.getHeight();
                if (dy + eh > vy && dy < vy + vh) {
                    e.render(mx, my, p, vx, dy, vw);
                }
                dy += eh;
            }
        });
        this.container.renderBorder = false;
        this.renderBorder = false;
    }

    public ScrollableContainerWidget getContainer() {
        return this.container;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.container.setBounds(x, y + this.anchorHeaderHeight, width, height - this.anchorHeaderHeight);
        this.anchorHeader.sizeChanged();
    }

    public List<class_364> children() {
        return this.children;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.renderBorder) {
            VHLine.outline(this.x, this.y, this.x + this.width, this.y + this.height, this.borderColor);
        }
        this.container.render(mouseX, mouseY, partialTicks);
        this.anchorHeader.render(mouseX, mouseY, partialTicks);
    }

    public void addEntry(E entry) {
        this.entries.add(entry);
        this.children.add((class_364)entry);
        this.entriesTotalHeight += entry.getHeight();
        this.container.setContentHeight(this.entriesTotalHeight);
    }

    public void addAnchor(String displayText) {
        this.anchorHeader.addAnchor(displayText);
    }

    public boolean isMouseOver(double d, double e) {
        return VHLine.contains(this.x, this.y, this.x + this.width, this.y + this.height, (int)d, (int)e) || this.anchorHeader.isMouseOver(d, e);
    }

    public boolean mouseReleased(double d, double e, int i) {
        if (super.mouseReleased(d, e, i)) {
            return true;
        }
        return this.container.mouseReleased(d, e, i);
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (!this.isMouseOver(d, e)) {
            return false;
        }
        if (this.anchorHeader.isMouseOver(d, e)) {
            this.anchorHeader.mouseClicked(d, e, i);
            return true;
        }
        if (this.container.isMouseOverViewport(d, e)) {
            return super.mouseClicked(d, e, i);
        }
        if (this.container.isMouseOver(d, e) && this.container.mouseClicked(d, e, i)) {
            this.setFocused(this.container);
            if (i == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public static interface Entry
    extends class_364 {
        public int getHeight();

        public void render(int var1, int var2, float var3, int var4, int var5, int var6);
    }

    protected class AnchorHeader
    extends class_362
    implements class_4068 {
        private List<io.github.jsnimda.common.gui.AnchoredListWidget$AnchorHeader.Anchor> anchors = new ArrayList<io.github.jsnimda.common.gui.AnchoredListWidget$AnchorHeader.Anchor>();
        private boolean expanded = false;
        private final int SEPARATOR_WIDTH = 10;
        private final int DOT_DOT_DOT_WIDTH;
        private int rowHeight;
        private int currentTextX;
        private int currentTextRow;
        private int hoveringY;

        protected AnchorHeader() {
            this.DOT_DOT_DOT_WIDTH = class_310.method_1551().field_1772.method_1727(" ... ...");
            this.rowHeight = 13;
            this.currentTextX = 0;
            this.currentTextRow = 0;
            this.hoveringY = -1;
        }

        private int getTextOffsetY() {
            return (this.rowHeight + 1) / 2 - 4;
        }

        private int getTotalTextRow() {
            return this.currentTextRow + 1;
        }

        private int getViewingTextRow() {
            if (this.anchors.isEmpty()) {
                return 0;
            }
            int index = this.getViewingAnchorIndex();
            return ((Anchor)this.anchors.get((int)index)).rowIndex;
        }

        private int getExpandedHeight() {
            return this.rowHeight * this.getTotalTextRow() + 1;
        }

        private int getExpandedY() {
            if (this.hoveringY == -1) {
                this.hoveringY = Math.max(7, this.getHiddenStartY());
            }
            return this.hoveringY;
        }

        private int getHiddenStartY() {
            return AnchoredListWidget.this.y - this.getViewingTextRow() * this.rowHeight;
        }

        private int getAvailableStringWidth() {
            return AnchoredListWidget.this.width - 20 - this.DOT_DOT_DOT_WIDTH;
        }

        private int getStartX() {
            return AnchoredListWidget.this.x + 10;
        }

        public void addAnchor(String displayText) {
            this.addAnchor(displayText, AnchoredListWidget.this.entriesTotalHeight);
        }

        public void addAnchor(String displayText, int toScrollY) {
            int w = class_310.method_1551().field_1772.method_1727("\u00a7n" + displayText);
            if (w + this.currentTextX > this.getAvailableStringWidth()) {
                this.currentTextX = 0;
                ++this.currentTextRow;
            }
            this.currentTextX += w + 10;
            this.anchors.add((io.github.jsnimda.common.gui.AnchoredListWidget$AnchorHeader.Anchor)new Anchor(displayText, toScrollY, this.currentTextRow));
        }

        private int getViewingAnchorIndex() {
            int scrollY = AnchoredListWidget.this.container.getScrollY();
            for (int i = 0; i < this.anchors.size(); ++i) {
                if (((Anchor)this.anchors.get((int)i)).toScrollY < scrollY) continue;
                if (((Anchor)this.anchors.get((int)i)).toScrollY - scrollY <= AnchoredListWidget.this.container.getViewportHeight() / 2) {
                    return i;
                }
                return Math.max(0, i - 1);
            }
            return this.anchors.size() - 1;
        }

        public List<? extends class_364> children() {
            return this.anchors.stream().map(x -> x.textButtonWidget).collect(Collectors.toList());
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            this.isMouseOver(mouseX, mouseY);
            if (this.expanded) {
                int y1 = this.getExpandedY();
                int y2 = this.getExpandedY() + this.getExpandedHeight();
                VHLine.h(AnchoredListWidget.this.x, AnchoredListWidget.this.x + AnchoredListWidget.this.width - 1, y1, -6710887);
                VHLine.h(AnchoredListWidget.this.x, AnchoredListWidget.this.x + AnchoredListWidget.this.width - 1, y2, -6710887);
                AnchorHeader.fill((int)AnchoredListWidget.this.x, (int)(y1 + 1), (int)(AnchoredListWidget.this.x + AnchoredListWidget.this.width), (int)y2, (int)-1063675495);
            } else {
                VHLine.h(AnchoredListWidget.this.x, AnchoredListWidget.this.x + AnchoredListWidget.this.width - 1, AnchoredListWidget.this.y, -2137417319);
                VHLine.h(AnchoredListWidget.this.x, AnchoredListWidget.this.x + AnchoredListWidget.this.width - 1, AnchoredListWidget.this.y + AnchoredListWidget.this.anchorHeaderHeight, -2137417319);
                AnchorHeader.fill((int)AnchoredListWidget.this.x, (int)(AnchoredListWidget.this.y + 1), (int)(AnchoredListWidget.this.x + AnchoredListWidget.this.width), (int)(AnchoredListWidget.this.y + AnchoredListWidget.this.anchorHeaderHeight), (int)0x40999999);
            }
            if (!this.anchors.isEmpty()) {
                int startY = this.expanded ? this.getExpandedY() : this.getHiddenStartY();
                int viewingAnchorIndex = this.getViewingAnchorIndex();
                int viewingRowIndex = ((Anchor)this.anchors.get((int)viewingAnchorIndex)).rowIndex;
                int offsetX = 0;
                int lastRowIndex = 0;
                for (int i = 0; i < this.anchors.size(); ++i) {
                    Anchor anchor = (Anchor)this.anchors.get(i);
                    if (anchor.rowIndex != lastRowIndex) {
                        offsetX = 0;
                        lastRowIndex = anchor.rowIndex;
                    }
                    TextButtonWidget textWidget = anchor.textButtonWidget;
                    textWidget.active = i != viewingAnchorIndex;
                    textWidget.visible = this.expanded || anchor.rowIndex == viewingRowIndex;
                    textWidget.x = this.getStartX() + offsetX;
                    textWidget.y = startY + this.getTextOffsetY() + anchor.rowIndex * this.rowHeight;
                    textWidget.render(mouseX, mouseY, partialTicks);
                    offsetX += textWidget.getWidth() + 10;
                    if (this.expanded || this.getTotalTextRow() <= 1 || anchor.rowIndex != viewingRowIndex || i + 1 < this.anchors.size() && anchor.rowIndex == ((Anchor)this.anchors.get((int)(i + 1))).rowIndex) continue;
                    this.drawString(class_310.method_1551().field_1772, " ... ...", this.getStartX() + offsetX - 10, AnchoredListWidget.this.y + this.getTextOffsetY(), -1);
                }
            }
        }

        public boolean isMouseOver(double d, double e) {
            boolean result;
            if (!this.expanded) {
                result = VHLine.contains(AnchoredListWidget.this.x, AnchoredListWidget.this.y, AnchoredListWidget.this.x + AnchoredListWidget.this.width, AnchoredListWidget.this.y + AnchoredListWidget.this.anchorHeaderHeight + 1, (int)d, (int)e);
            } else {
                int y1 = this.getExpandedY();
                result = VHLine.contains(AnchoredListWidget.this.x, y1, AnchoredListWidget.this.x + AnchoredListWidget.this.width, y1 + this.getExpandedHeight(), (int)d, (int)e);
            }
            boolean bl = this.expanded = result && this.getTotalTextRow() > 1;
            if (!this.expanded) {
                this.hoveringY = -1;
            }
            return result;
        }

        public void sizeChanged() {
            List<io.github.jsnimda.common.gui.AnchoredListWidget$AnchorHeader.Anchor> a = this.anchors;
            this.anchors = new ArrayList<io.github.jsnimda.common.gui.AnchoredListWidget$AnchorHeader.Anchor>();
            this.currentTextX = 0;
            this.currentTextRow = 0;
            a.forEach(x -> this.addAnchor(x.anchorDisplayText, x.toScrollY));
        }

        protected class Anchor {
            public String anchorDisplayText;
            public TextButtonWidget textButtonWidget;
            public int toScrollY;
            public int rowIndex;

            public Anchor(String displayText, int toScrollY, int rowIndex) {
                this.anchorDisplayText = displayText;
                this.toScrollY = toScrollY;
                this.rowIndex = rowIndex;
                this.textButtonWidget = new TextButtonWidget(0, 0, displayText, x -> AnchoredListWidget.this.container.setScrollY(toScrollY));
                this.textButtonWidget.setHoverText("\u00a7e\u00a7n" + displayText);
                this.textButtonWidget.setInactiveText("\u00a7e\u00a7n\u00a7l" + displayText);
                this.textButtonWidget.visible = false;
                this.textButtonWidget.pressableMargin = 2;
            }
        }
    }
}

