/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.gui;

import io.github.jsnimda.common.config.options.ConfigHotkey;
import io.github.jsnimda.common.gui.ConfigOptionHotkeyOverlayScreen;
import io.github.jsnimda.common.gui.ConfigOptionWidgetBase;
import io.github.jsnimda.common.gui.Tooltips;
import io.github.jsnimda.common.gui.VHLine;
import io.github.jsnimda.common.input.GlobalInputHandler;
import io.github.jsnimda.common.input.Keybind;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4493;

public class ConfigOptionHotkeyWidget
extends ConfigOptionWidgetBase<ConfigHotkey> {
    private class_4185 setKeyButton = new class_4185(10, 10, 200, 20, "", x -> GlobalInputHandler.getInstance().setCurrentSettingKeybind(((ConfigHotkey)this.configOption).getMainKeybind()));
    private static class_2960 WIDGETS_TEXTURE = new class_2960("inventoryprofiles", "textures/gui/widgets.png");
    public boolean isInConfigHotkeyOverlay = false;
    public Keybind targetKeybind;
    private static String textPrefix = "inventoryprofiles.common.gui.config.";

    protected ConfigOptionHotkeyWidget(ConfigHotkey configOption) {
        super(configOption);
        this.targetKeybind = configOption.getMainKeybind();
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        int textureX = 20 + (this.targetKeybind.isSettingsModified() || !((ConfigHotkey)this.configOption).getAlternativeKeybinds().isEmpty() ? 20 : 0);
        int textureY = 160 + this.targetKeybind.getSettings().activateOn.ordinal() * 20;
        if (this.targetKeybind.getKeyCodes().isEmpty()) {
            textureY = 140;
        }
        class_310.method_1551().method_1531().method_22813(WIDGETS_TEXTURE);
        class_4493.method_22047();
        ConfigOptionHotkeyWidget.blit((int)this.x, (int)this.y, (float)textureX, (float)textureY, (int)20, (int)20, (int)256, (int)256);
        class_4493.method_22050();
        if (VHLine.contains(this.x, this.y, this.x + 20, this.y + 20, mouseX, mouseY)) {
            Tooltips.getInstance().addTooltip(this.getKeybindSettingsTooltip(), mouseX, mouseY);
        }
        this.setKeyButton.x = this.x + 20 + 2;
        this.setKeyButton.y = this.y;
        this.setKeyButton.setWidth(this.availableWidth - 20 - 2);
        String displayText = this.targetKeybind.getDisplayText();
        this.setKeyButton.setMessage(GlobalInputHandler.getInstance().getCurrentSettingKeybind() == this.targetKeybind ? "> \u00a7e" + displayText + "\u00a7r <" : displayText);
        this.setKeyButton.render(mouseX, mouseY, partialTicks);
    }

    private static String translate(String suffix) {
        return class_1074.method_4662((String)(textPrefix + suffix), (Object[])new Object[0]);
    }

    private String getKeybindSettingsTooltip() {
        String yes = ConfigOptionHotkeyWidget.translate("yes");
        String no = ConfigOptionHotkeyWidget.translate("no");
        String s = "\u00a7n" + ConfigOptionHotkeyWidget.translate("advanced_keybind_settings");
        s = s + String.format("\n%s: %s", ConfigOptionHotkeyWidget.translate("activate_on"), "\u00a79" + this.targetKeybind.getSettings().activateOn.toString());
        s = s + String.format("\n%s: %s", ConfigOptionHotkeyWidget.translate("context"), "\u00a79" + this.targetKeybind.getSettings().context.toString());
        s = s + String.format("\n%s: %s", ConfigOptionHotkeyWidget.translate("allow_extra_keys"), "\u00a76" + (this.targetKeybind.getSettings().allowExtraKeys ? yes : no));
        s = s + String.format("\n%s: %s", ConfigOptionHotkeyWidget.translate("order_sensitive"), "\u00a76" + (this.targetKeybind.getSettings().orderSensitive ? yes : no));
        s = s + "\n\n" + ConfigOptionHotkeyWidget.translate("keybind_settings_tips");
        return s;
    }

    protected void onClickKeybindSettingsIcon() {
        if (!this.isInConfigHotkeyOverlay) {
            class_310.method_1551().method_1507((class_437)new ConfigOptionHotkeyOverlayScreen((ConfigHotkey)this.configOption));
        }
    }

    @Override
    protected void reset() {
        this.targetKeybind.resetKeyCodesToDefault();
    }

    @Override
    protected boolean resetButtonActive() {
        return this.targetKeybind.isKeyCodesModified();
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (super.mouseClicked(d, e, i)) {
            return true;
        }
        if (VHLine.contains(this.x, this.y, this.x + 20, this.y + 20, (int)d, (int)e)) {
            if (i == 1) {
                this.targetKeybind.resetSettingsToDefault();
            } else if (i == 0) {
                this.onClickKeybindSettingsIcon();
            }
            return true;
        }
        return false;
    }

    @Override
    public List<? extends class_364> children() {
        return Arrays.asList(this.resetButton, this.setKeyButton);
    }
}

