/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.gui;

import io.github.jsnimda.common.config.CategorizedConfigOptions;
import io.github.jsnimda.common.config.IConfigOption;
import io.github.jsnimda.common.gui.AnchoredListWidget;
import io.github.jsnimda.common.gui.ConfigOptionWidgetBase;
import io.github.jsnimda.common.gui.Tooltips;
import io.github.jsnimda.common.gui.VHLine;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;

public class ConfigOptionListWidget
extends AnchoredListWidget<Entry> {
    private static final int COLOR_WHITE = -1;
    private String displayNamePrefix;
    private String descriptionPrefix;

    public ConfigOptionListWidget(String displayNamePrefix, String descriptionPrefix) {
        super(0, 0, 100, 100);
        this.displayNamePrefix = displayNamePrefix;
        this.descriptionPrefix = descriptionPrefix;
    }

    public static ConfigOptionListWidget from(CategorizedConfigOptions optionGroup, String displayNamePrefix, String descriptionPrefix) {
        ConfigOptionListWidget c = new ConfigOptionListWidget(displayNamePrefix, descriptionPrefix);
        optionGroup.getCategories().forEach(x -> {
            String categoryNameKey = (String)x.getLeft();
            String categoryName = class_1074.method_4662((String)categoryNameKey, (Object[])new Object[0]);
            c.addAnchor(categoryName);
            ConfigOptionListWidget configOptionListWidget = c;
            ((Object)((Object)configOptionListWidget)).getClass();
            c.addEntry(configOptionListWidget.new CategoryEntry(categoryName));
            ((List)x.getRight()).forEach(y -> {
                ConfigOptionListWidget configOptionListWidget = c;
                ((Object)((Object)configOptionListWidget)).getClass();
                c.addEntry(configOptionListWidget.new ConfigOptionEntry((IConfigOption)y));
            });
        });
        return c;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        Tooltips.getInstance().renderAll();
    }

    public static abstract class Entry
    extends class_332
    implements AnchoredListWidget.Entry,
    class_4069 {
        @Nullable
        private class_364 focused;
        private boolean dragging;

        public boolean isDragging() {
            return this.dragging;
        }

        public void setDragging(boolean bl) {
            this.dragging = bl;
        }

        public void setFocused(@Nullable class_364 element) {
            this.focused = element;
        }

        @Nullable
        public class_364 getFocused() {
            return this.focused;
        }
    }

    public class CategoryEntry
    extends Entry {
        private String categoryName;
        private int textY = 6;

        private CategoryEntry(String categoryName) {
            this.categoryName = categoryName;
        }

        @Override
        public int getHeight() {
            return 20;
        }

        public List<? extends class_364> children() {
            return Collections.emptyList();
        }

        @Override
        public void render(int mouseX, int mouseY, float partialTicks, int offsetX, int offsetY, int viewportWidth) {
            this.drawCenteredString(class_310.method_1551().field_1772, this.categoryName, offsetX + viewportWidth / 2, offsetY + this.textY, -1);
        }
    }

    public class ConfigOptionEntry
    extends Entry {
        private IConfigOption option;
        private ConfigOptionWidgetBase<?> optionWidget;
        private int textY = 6;

        private ConfigOptionEntry(IConfigOption option) {
            this.option = option;
            this.optionWidget = ConfigOptionWidgetBase.of(option);
        }

        public List<? extends class_364> children() {
            return Arrays.asList(this.optionWidget, this.optionWidget);
        }

        @Override
        public int getHeight() {
            return 20;
        }

        @Override
        public void render(int mouseX, int mouseY, float partialTicks, int offsetX, int offsetY, int viewportWidth) {
            int xMid;
            boolean outOfContainer = !ConfigOptionListWidget.this.getContainer().isMouseOverViewport(mouseX, mouseY) || ConfigOptionListWidget.this.anchorHeader.isMouseOver(mouseX, mouseY);
            this.optionWidget.x = xMid = offsetX + viewportWidth / 2;
            this.optionWidget.y = offsetY;
            this.optionWidget.width = offsetX + viewportWidth - 2 - xMid;
            this.optionWidget.render(outOfContainer ? -1 : mouseX, outOfContainer ? -1 : mouseY, partialTicks);
            String displayName = class_1074.method_4662((String)(ConfigOptionListWidget.this.displayNamePrefix + this.option.getKey()), (Object[])new Object[0]);
            int tx = offsetX + 2;
            int ty = offsetY + this.textY;
            int tw = class_310.method_1551().field_1772.method_1727(displayName);
            this.drawString(class_310.method_1551().field_1772, displayName, tx, ty, -1);
            if (VHLine.contains(tx, ty - 1, tx + tw, ty + 9 + 1, mouseX, mouseY)) {
                Tooltips.getInstance().addTooltip(class_1074.method_4662((String)(ConfigOptionListWidget.this.descriptionPrefix + this.option.getKey()), (Object[])new Object[0]), mouseX, mouseY, x -> x * 2 / 3);
            }
        }
    }
}

