/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.gui;

import io.github.jsnimda.common.config.IConfigOptionPrimitiveNumeric;
import io.github.jsnimda.common.gui.ConfigOptionWidgetBase;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4493;

public class ConfigOptionNumericWidget
extends ConfigOptionWidgetBase<IConfigOptionPrimitiveNumeric<?>> {
    public static class_2960 WIDGETS_TEXTURE = new class_2960("inventoryprofiles", "textures/gui/widgets.png");
    private class_357 slider = new class_357(10, 10, 200, 20, 0.5){

        protected void updateMessage() {
        }

        protected void applyValue() {
            double min = ((Number)((IConfigOptionPrimitiveNumeric)ConfigOptionNumericWidget.this.configOption).getMinValue()).doubleValue();
            double max = ((Number)((IConfigOptionPrimitiveNumeric)ConfigOptionNumericWidget.this.configOption).getMaxValue()).doubleValue();
            double val = (max - min) * this.value + min;
            ((IConfigOptionPrimitiveNumeric)ConfigOptionNumericWidget.this.configOption).setValue(val);
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            ((ConfigOptionNumericWidget)ConfigOptionNumericWidget.this).slider.x = ConfigOptionNumericWidget.this.x;
            ((ConfigOptionNumericWidget)ConfigOptionNumericWidget.this).slider.y = ConfigOptionNumericWidget.this.y;
            ConfigOptionNumericWidget.this.slider.setWidth(ConfigOptionNumericWidget.this.availableWidth - 16 - 2);
            ConfigOptionNumericWidget.this.slider.setMessage(String.valueOf(((IConfigOptionPrimitiveNumeric)ConfigOptionNumericWidget.this.configOption).getValue()));
            double min = ((Number)((IConfigOptionPrimitiveNumeric)ConfigOptionNumericWidget.this.configOption).getMinValue()).doubleValue();
            double max = ((Number)((IConfigOptionPrimitiveNumeric)ConfigOptionNumericWidget.this.configOption).getMaxValue()).doubleValue();
            double val = ((Number)((IConfigOptionPrimitiveNumeric)ConfigOptionNumericWidget.this.configOption).getValue()).doubleValue();
            this.value = (val - min) / (max - min);
            super.render(mouseX, mouseY, partialTicks);
        }
    };
    private boolean useSlider = true;
    private class_342 textField;
    private class_4185 toggleButton;
    private static final Pattern PATTERN_INTEGER = Pattern.compile("-?[0-9]*");
    private static final Pattern PATTERN_DOUBLE = Pattern.compile("^-?([0-9]+(\\.[0-9]*)?)?");
    private Pattern pattern;

    protected ConfigOptionNumericWidget(IConfigOptionPrimitiveNumeric<?> configOption) {
        super(configOption);
        this.textField = new class_342(class_310.method_1551().field_1772, 10, 10, 200, 18, "");
        this.toggleButton = new class_4185(10, 10, 16, 16, "", x -> {
            this.useSlider = !this.useSlider;
        }){

            public void renderButton(int i, int j, float f) {
                class_310 minecraftClient = class_310.method_1551();
                minecraftClient.method_1531().method_22813(WIDGETS_TEXTURE);
                class_4493.method_22047();
                int textureX = this.isHovered() ? 32 : 16;
                int textureY = ConfigOptionNumericWidget.this.useSlider ? 16 : 0;
                2.blit((int)this.x, (int)this.y, (float)textureX, (float)textureY, (int)this.width, (int)this.height, (int)256, (int)256);
                class_4493.method_22050();
            }
        };
        this.pattern = configOption.getDefaultValue() instanceof Double ? PATTERN_DOUBLE : PATTERN_INTEGER;
        this.textField.method_1890(x -> x.isEmpty() || this.pattern.matcher((CharSequence)x).matches());
        this.textField.method_1863(x -> {
            if (this.textField.method_20315()) {
                if (this.textField.method_1882().isEmpty()) {
                    configOption.setValue(0);
                } else {
                    try {
                        double d = Double.parseDouble(this.textField.method_1882());
                        configOption.setValue(d);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.toggleButton.x = this.x + this.availableWidth - 16;
        this.toggleButton.y = this.y + 2;
        this.toggleButton.render(mouseX, mouseY, partialTicks);
        this.textField.x = this.x + 2;
        this.textField.y = this.y + 1;
        this.textField.setWidth(this.availableWidth - 16 - 2 - 4);
        if (!this.textField.method_20315() && !this.useSlider) {
            this.textField.method_1852(String.valueOf(((IConfigOptionPrimitiveNumeric)this.configOption).getValue()));
        }
        (this.useSlider ? this.slider : this.textField).render(mouseX, mouseY, partialTicks);
    }

    @Override
    public List<? extends class_364> children() {
        return this.useSlider ? Arrays.asList(this.resetButton, this.slider, this.toggleButton) : Arrays.asList(this.resetButton, this.textField, this.toggleButton);
    }
}

