/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.gui;

import io.github.jsnimda.common.config.IConfigOption;
import io.github.jsnimda.common.config.IConfigOptionPrimitiveNumeric;
import io.github.jsnimda.common.config.options.ConfigBoolean;
import io.github.jsnimda.common.config.options.ConfigEnum;
import io.github.jsnimda.common.config.options.ConfigHotkey;
import io.github.jsnimda.common.gui.ConfigOptionBooleanWidget;
import io.github.jsnimda.common.gui.ConfigOptionHotkeyWidget;
import io.github.jsnimda.common.gui.ConfigOptionNumericWidget;
import io.github.jsnimda.common.gui.ConfigOptionToggleableWidget;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;

public abstract class ConfigOptionWidgetBase<T extends IConfigOption>
extends class_362
implements class_4068 {
    public int x;
    public int y;
    public int width;
    public int height;
    protected class_4185 resetButton = new class_4185(10, 10, 200, 20, "", x -> this.reset());
    public boolean showResetButton = true;
    public int resetButtonGap = 2;
    protected final T configOption;
    protected int availableWidth;

    protected ConfigOptionWidgetBase(T configOption) {
        this.configOption = configOption;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.showResetButton) {
            String s = class_1074.method_4662((String)"inventoryprofiles.common.gui.config.reset", (Object[])new Object[0]);
            int w = class_310.method_1551().field_1772.method_1727(s);
            int bw = w + 15;
            this.resetButton.x = this.x + this.width - bw;
            this.resetButton.y = this.y;
            this.resetButton.setWidth(bw);
            this.resetButton.setMessage(s);
            this.resetButton.active = this.resetButtonActive();
            this.resetButton.render(mouseX, mouseY, partialTicks);
        }
        this.availableWidth = this.width - (this.showResetButton ? this.resetButton.getWidth() + this.resetButtonGap : 0);
    }

    public static ConfigOptionWidgetBase<?> of(IConfigOption configOption) {
        if (configOption instanceof ConfigBoolean) {
            return new ConfigOptionBooleanWidget((ConfigBoolean)configOption);
        }
        if (configOption instanceof IConfigOptionPrimitiveNumeric) {
            return new ConfigOptionNumericWidget((IConfigOptionPrimitiveNumeric)configOption);
        }
        if (configOption instanceof ConfigEnum) {
            return new ConfigOptionToggleableWidget<ConfigEnum>((ConfigEnum)configOption, x -> ((Enum)x.getValue()).toString());
        }
        if (configOption instanceof ConfigHotkey) {
            return new ConfigOptionHotkeyWidget((ConfigHotkey)configOption);
        }
        return new ConfigOptionWidgetBase<IConfigOption>(configOption){};
    }

    protected void reset() {
        this.configOption.resetToDefault();
    }

    protected boolean resetButtonActive() {
        return this.configOption.isModified();
    }

    public List<? extends class_364> children() {
        return Collections.emptyList();
    }
}

