/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.input;

import io.github.jsnimda.common.gui.DebugScreen;
import io.github.jsnimda.common.input.IInputHandler;
import io.github.jsnimda.common.input.Keybind;
import io.github.jsnimda.common.input.KeybindSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_310;

public class GlobalInputHandler {
    private static final GlobalInputHandler INSTANCE = new GlobalInputHandler();
    public final List<Integer> pressingKeys = new ArrayList<Integer>();
    public List<Integer> beforePressingKeys = new ArrayList<Integer>();
    public int lastKey = -1;
    public int lastAction = -1;
    private Optional<Keybind> currentSettingKeybind = Optional.empty();
    private boolean firstKey = false;
    private List<IInputHandler> registeredInputHandlers = new ArrayList<IInputHandler>();

    public static GlobalInputHandler getInstance() {
        return INSTANCE;
    }

    private GlobalInputHandler() {
    }

    public boolean isActivated(List<Integer> keyCodes, KeybindSettings settings) {
        List<Integer> pressedKeys;
        if (keyCodes.isEmpty()) {
            return false;
        }
        if (settings.activateOn == KeybindSettings.KeyAction.PRESS && this.lastAction == 0) {
            return false;
        }
        if (settings.activateOn == KeybindSettings.KeyAction.RELEASE && this.lastAction == 1) {
            return false;
        }
        if (settings.context == KeybindSettings.Context.INGAME && class_310.method_1551().field_1755 != null) {
            return false;
        }
        if (settings.context == KeybindSettings.Context.GUI && class_310.method_1551().field_1755 == null) {
            return false;
        }
        List<Integer> list = pressedKeys = this.lastAction == 1 ? this.pressingKeys : this.beforePressingKeys;
        if (pressedKeys.size() >= keyCodes.size() && (settings.allowExtraKeys || pressedKeys.size() == keyCodes.size())) {
            if (settings.orderSensitive) {
                for (int i = 0; i < keyCodes.size(); ++i) {
                    if (keyCodes.get(keyCodes.size() - 1 - i).intValue() == pressedKeys.get(pressedKeys.size() - 1 - i).intValue()) continue;
                    return false;
                }
                return true;
            }
            return keyCodes.contains(this.lastKey) && pressedKeys.containsAll(keyCodes);
        }
        return false;
    }

    public void setCurrentSettingKeybind(Keybind keybind) {
        this.currentSettingKeybind = Optional.ofNullable(keybind);
        this.firstKey = false;
    }

    public Keybind getCurrentSettingKeybind() {
        return this.currentSettingKeybind.orElse(null);
    }

    private void handleCurrentSettingKeybind() {
        if (this.lastAction == 1) {
            this.firstKey = true;
            if (this.lastKey == 256) {
                this.currentSettingKeybind.get().setKeyCodes(new ArrayList<Integer>());
                this.currentSettingKeybind = Optional.empty();
            } else {
                this.currentSettingKeybind.get().setKeyCodes(new ArrayList<Integer>(this.pressingKeys));
            }
        } else if (this.lastAction == 0 && this.pressingKeys.isEmpty() && this.firstKey) {
            this.currentSettingKeybind = Optional.empty();
        }
    }

    public boolean onKeyPress(int key) {
        if (this.pressingKeys.contains(key)) {
            return false;
        }
        this.beforePressingKeys = new ArrayList<Integer>(this.pressingKeys);
        this.pressingKeys.add(key);
        this.lastKey = key;
        this.lastAction = 1;
        return this.onInput();
    }

    public boolean onKeyRelease(int key) {
        if (!this.pressingKeys.contains(key)) {
            return false;
        }
        this.beforePressingKeys = new ArrayList<Integer>(this.pressingKeys);
        this.pressingKeys.remove((Object)key);
        this.lastKey = key;
        this.lastAction = 0;
        return this.onInput();
    }

    private boolean onInput() {
        if (this.currentSettingKeybind.isPresent()) {
            this.handleCurrentSettingKeybind();
            return true;
        }
        this.registeredInputHandlers.forEach(x -> x.onInput(this.lastKey, this.lastAction));
        return false;
    }

    public boolean onKey(int key, int scanCode, int action, int modifiers) {
        DebugScreen.DebugInfos.onKey(key, scanCode, action, modifiers);
        if (action == 1) {
            return this.onKeyPress(key);
        }
        if (action == 0) {
            return this.onKeyRelease(key);
        }
        return false;
    }

    public boolean onMouseButton(int button, int action, int mods) {
        DebugScreen.DebugInfos.onMouseButton(button, action, mods);
        if (action == 1) {
            return this.onKeyPress(button - 100);
        }
        if (action == 0) {
            return this.onKeyRelease(button - 100);
        }
        return false;
    }

    public void registerInputHandler(IInputHandler inputHandler) {
        if (!this.registeredInputHandlers.contains(inputHandler)) {
            this.registeredInputHandlers.add(inputHandler);
        }
    }
}

