/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter;

import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemStack;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSlot;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSlotsStats;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class BiVirtualSlots {
    public List<VirtualSlot> sourceSlots;
    public List<VirtualSlot> targetSlots;

    public BiVirtualSlots(List<VirtualSlot> sourceSlots, List<VirtualSlot> targetSlots) {
        this.sourceSlots = sourceSlots;
        this.targetSlots = targetSlots;
    }

    public static List<VirtualItemStack> toItems(List<VirtualSlot> slots) {
        return slots.stream().map(x -> x.slotItem).collect(Collectors.toList());
    }

    public void swap() {
        List<VirtualSlot> tmp = this.sourceSlots;
        this.sourceSlots = this.targetSlots;
        this.targetSlots = tmp;
    }

    public List<VirtualItemStack> sources() {
        return BiVirtualSlots.toItems(this.sourceSlots);
    }

    public VirtualItemStack source(int index) {
        return this.sourceSlots.get((int)index).slotItem;
    }

    public List<VirtualItemStack> targets() {
        return BiVirtualSlots.toItems(this.targetSlots);
    }

    public VirtualItemStack target(int index) {
        return this.targetSlots.get((int)index).slotItem;
    }

    public void restock() {
        VirtualSlotsStats sourceStats = new VirtualSlotsStats(this.sources());
        VirtualSlotsStats targetStats = new VirtualSlotsStats(this.targets());
        List<VirtualSlotsStats.ItemTypeStats> infos = targetStats.getInfosAsList();
        block0: for (VirtualSlotsStats.ItemTypeStats info : infos) {
            ListIterator lit = sourceStats.getOrDefault(info.type, x -> x.indexes.listIterator(x.indexes.size()), Collections.emptyListIterator());
            if (!lit.hasPrevious()) continue;
            int sourceIndex = (Integer)lit.previous();
            for (int targetIndex : info.indexes) {
                while (!this.target(targetIndex).isFull()) {
                    if (this.source(sourceIndex).isEmpty()) {
                        if (!lit.hasPrevious()) continue block0;
                        sourceIndex = (Integer)lit.previous();
                    }
                    this.source(sourceIndex).transferTo(this.target(targetIndex));
                }
            }
        }
    }
}

