/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter;

import io.github.jsnimda.inventoryprofiles.config.Configs;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSorterPort;
import io.github.jsnimda.inventoryprofiles.sorter.predefined.SortingMethodProviders;
import io.github.jsnimda.inventoryprofiles.sorter.util.ContainerActions;
import io.github.jsnimda.inventoryprofiles.sorter.util.Current;
import net.minecraft.class_437;

public class SorterEventPort {
    public static void handleCloseContainer() {
        ContainerActions.cleanCursor();
        ContainerActions.cleanTempSlotsForClosing();
    }

    public static void doSortAction() {
        VirtualSorterPort.doSort(SortingMethodProviders.current(), VirtualSorterPort.GroupingType.PRESERVED);
    }

    public static void doSortActionByGroupColumns() {
        VirtualSorterPort.doSort(SortingMethodProviders.current(), VirtualSorterPort.GroupingType.COLUMNS);
    }

    public static void doSortActionByGroupRows() {
        VirtualSorterPort.doSort(SortingMethodProviders.current(), VirtualSorterPort.GroupingType.ROWS);
    }

    public static void doSwitchProfile() {
    }

    public static void doMoveAll() {
        ContainerActions.moveAllAlike(class_437.hasShiftDown());
    }

    public static boolean handleKey(int lastKey, int lastAction) {
        if (!Current.inGame()) {
            return false;
        }
        try {
            if (Configs.Hotkeys.SORT_INVENTORY.isActivated()) {
                SorterEventPort.doSortAction();
                return true;
            }
            if (Configs.Hotkeys.SORT_INVENTORY_IN_COLUMNS.isActivated()) {
                SorterEventPort.doSortActionByGroupColumns();
                return true;
            }
            if (Configs.Hotkeys.SORT_INVENTORY_IN_ROWS.isActivated()) {
                SorterEventPort.doSortActionByGroupRows();
                return true;
            }
            if (Configs.Hotkeys.MOVE_ALL_ITEMS.isActivated()) {
                SorterEventPort.doMoveAll();
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }
}

