/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter.predefined;

import io.github.jsnimda.inventoryprofiles.sorter.predefined.ConvertedComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class ChainedComparator<T>
implements Comparator<T> {
    public final List<Comparator<T>> comparators = new ArrayList<Comparator<T>>();

    @Override
    public int compare(T o1, T o2) {
        return ChainedComparator.compare(o1, o2, this.comparators);
    }

    public static <T> int compare(T o1, T o2, List<Comparator<T>> comparators) {
        int cmp = 0;
        Iterator<Comparator<T>> it = comparators.iterator();
        while (cmp == 0 && it.hasNext()) {
            cmp = it.next().compare(o1, o2);
        }
        return cmp;
    }

    public ChainedComparator<T> add(Comparator<T> cmp) {
        if (cmp instanceof ChainedComparator) {
            for (Comparator<T> every : ((ChainedComparator)cmp).comparators) {
                this.add(every);
            }
        } else {
            this.comparators.add(cmp);
        }
        return this;
    }

    public <A> ConvertedComparator<A, T> convert(Function<A, T> function) {
        return ConvertedComparator.convert(function, this);
    }
}

