/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter.predefined;

import io.github.jsnimda.inventoryprofiles.sorter.IGroupingShapeProvider;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemStack;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSlotsStats;
import io.github.jsnimda.inventoryprofiles.sorter.util.CodeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;

public class GroupingShapeProviders {
    public static final IGroupingShapeProvider PRESERVED = items -> items;
    public static final IGroupingShapeProvider RANDOM = items -> {
        ArrayList copy = new ArrayList(items);
        Collections.shuffle(copy);
        return copy;
    };
    public static final IGroupingShapeProvider COLUMNS = GroupingShapeProviders.columnsProvider(9);
    public static final IGroupingShapeProvider ROWS = GroupingShapeProviders.rowsProvider(9);
    public static final IGroupingShapeProvider TRANSPOSE = GroupingShapeProviders.transposeProvider(9);

    public static IGroupingShapeProvider rowsProvider(int width) {
        return items -> GroupingShapeProviders.transposeProvider(width).group(GroupingShapeProviders.columnsProvider(items.size() / width, true).group(items));
    }

    public static IGroupingShapeProvider transposeProvider(int width) {
        return items -> GroupingShapeProviders.transpose(items, items.size() / width, width);
    }

    private static List<VirtualItemStack> transpose(List<VirtualItemStack> grouped, int groupedWidth, int groupedHeight) {
        if (groupedWidth * groupedHeight != grouped.size()) {
            throw new RuntimeException("Container is not rectangular!");
        }
        ArrayList<Object> result = new ArrayList<Object>(Collections.nCopies(groupedWidth * groupedHeight, null));
        int resultWidth = groupedHeight;
        for (int y = 0; y < groupedHeight; ++y) {
            for (int x = 0; x < groupedWidth; ++x) {
                int ind = y * groupedWidth + x;
                int ind2 = x * resultWidth + y;
                if (ind >= grouped.size()) continue;
                result.set(ind2, grouped.get(ind));
            }
        }
        return result;
    }

    public static IGroupingShapeProvider columnsProvider(int width) {
        return GroupingShapeProviders.columnsProvider(width, false);
    }

    public static IGroupingShapeProvider columnsProvider(int width, boolean isTransposed) {
        return items -> {
            VirtualSlotsStats stats = new VirtualSlotsStats(items);
            if (items.size() == 0) {
                return items;
            }
            int height = stats.size / width;
            if (width * height != stats.size) {
                throw new RuntimeException("Container is not rectangular!");
            }
            List<Integer> itemsIdentity = stats.getInfosAsList(x -> x.stackCount);
            int minRows = itemsIdentity.size();
            if (minRows == 0) {
                return items;
            }
            ColumnsCandidate bestCc = null;
            int neededColumnsCount = 1;
            while (neededColumnsCount <= width) {
                if (minRows > height * neededColumnsCount) {
                    ++neededColumnsCount;
                    continue;
                }
                List<Integer> widths = CodeUtils.distribute(width, neededColumnsCount);
                ColumnsCandidate cc = new ColumnsCandidate(itemsIdentity, widths, height);
                if (cc.succeeded) {
                    if (cc.brokenGroups == 0) {
                        return cc.apply(items, isTransposed);
                    }
                    if (bestCc == null || bestCc.brokenGroups > cc.brokenGroups) {
                        bestCc = cc;
                    }
                }
                ++neededColumnsCount;
            }
            if (bestCc != null) {
                return bestCc.apply(items, isTransposed);
            }
            return PRESERVED.group(items);
        };
    }

    private static class ColumnsCandidate {
        public int brokenGroups = 0;
        public final boolean succeeded;
        private final List<Integer> itemsIdentity;
        private final List<Integer> widths;
        private final int width;
        private final int height;
        private final int columnsCount;
        private final List<Integer> spaceWidths;
        private boolean[] occupied;
        private int cursor = 0;
        private int loopCount = 0;
        private List<List<Integer>> rowsForStacks = new ArrayList<List<Integer>>();

        public ColumnsCandidate(List<Integer> itemsIdentity, List<Integer> widths, int height) {
            this.itemsIdentity = itemsIdentity;
            this.widths = widths;
            this.width = widths.stream().mapToInt(x -> x).sum();
            this.height = height;
            this.columnsCount = widths.size();
            this.occupied = new boolean[this.columnsCount * height];
            ArrayList<Integer> spaceWidths = new ArrayList<Integer>();
            for (int i = 0; i < this.occupied.length; ++i) {
                spaceWidths.add(widths.get(i / height));
            }
            this.spaceWidths = spaceWidths;
            for (int stacks : itemsIdentity) {
                if (this.addStack(stacks)) continue;
                this.succeeded = false;
                return;
            }
            assert (itemsIdentity.size() == this.rowsForStacks.size());
            this.succeeded = true;
        }

        private boolean addStack(int stacks) {
            if (!this.findCursor()) {
                return false;
            }
            ArrayList<Integer> rows = new ArrayList<Integer>();
            this.rowsForStacks.add(rows);
            boolean justFillFlag = false;
            if (this.loopCount == 0) {
                int cursorY = this.cursor % this.height;
                int vStacks = stacks;
                int spaceHeight = 0;
                while (this.cursor + spaceHeight < this.occupied.length && vStacks > 0) {
                    vStacks -= this.spaceWidths.get(this.cursor + spaceHeight).intValue();
                    ++spaceHeight;
                }
                if (vStacks <= 0) {
                    if (spaceHeight > this.height || cursorY + spaceHeight <= this.height) {
                        for (int i = 0; i < spaceHeight; ++i) {
                            rows.add(this.cursor);
                            this.occupied[this.cursor] = true;
                            ++this.cursor;
                        }
                        return true;
                    }
                    this.cursor += this.height - cursorY;
                    justFillFlag = true;
                } else {
                    justFillFlag = true;
                }
            }
            if (this.loopCount > 0 || justFillFlag) {
                int old_cursor = this.cursor;
                while (stacks > 0) {
                    if (!this.findCursor()) {
                        return false;
                    }
                    stacks -= this.spaceWidths.get(this.cursor).intValue();
                    rows.add(this.cursor);
                    this.occupied[this.cursor] = true;
                    if (!this.isNear(old_cursor, this.cursor)) {
                        ++this.brokenGroups;
                    }
                    old_cursor = this.cursor;
                }
            }
            return true;
        }

        private boolean isNear(int cursor1, int cursor2) {
            if (cursor1 == cursor2) {
                return true;
            }
            RowInfo info1 = new RowInfo(cursor1);
            RowInfo info2 = new RowInfo(cursor2);
            if (info1.columnIndex == info2.columnIndex) {
                return Math.abs(info1.y - info2.y) <= 1;
            }
            if (info1.y == info2.y) {
                return Math.abs(info1.columnIndex - info2.columnIndex) <= 1;
            }
            return false;
        }

        private boolean findCursor() {
            if (this.cursor >= this.occupied.length) {
                if (this.loopCount > 0) {
                    return false;
                }
                ++this.loopCount;
                this.cursor = 0;
            }
            while (this.occupied[this.cursor]) {
                ++this.cursor;
                if (this.cursor < this.occupied.length) continue;
                if (this.loopCount > 0) {
                    return false;
                }
                ++this.loopCount;
                this.cursor = 0;
            }
            return true;
        }

        public List<VirtualItemStack> apply(List<VirtualItemStack> items, boolean isTransposed) {
            ArrayList<VirtualItemStack> result = new ArrayList<VirtualItemStack>(Collections.nCopies(this.width * this.height, VirtualItemStack.empty()));
            int itemsIndex = 0;
            for (int i = 0; i < this.itemsIdentity.size(); ++i) {
                int stacks = this.itemsIdentity.get(i);
                List<Integer> rows = this.rowsForStacks.get(i);
                Collections.sort(rows);
                List<Integer> slots = this.slotIndexs(rows, isTransposed);
                for (int k = 0; k < stacks; ++k) {
                    VirtualItemStack v = items.get(itemsIndex + k);
                    result.set(slots.get(k), v);
                }
                itemsIndex += stacks;
            }
            return result;
        }

        private List<Integer> slotIndexs(List<Integer> rows, boolean isTransposed) {
            ArrayList<Integer> res = new ArrayList<Integer>();
            for (int row : rows) {
                RowInfo info = new RowInfo(row);
                for (int rowX = 0; rowX < info.spaceWidth; ++rowX) {
                    int x = info.x_base + rowX;
                    res.add(this.getIndexByXY(x, info.y));
                }
            }
            if (!isTransposed) {
                Collections.sort(res);
            } else {
                res.sort(new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        int x1 = o1 % width;
                        int y1 = o1 / width;
                        int x2 = o2 % width;
                        int y2 = o2 / width;
                        return x1 * height + y1 - (x2 * height + y2);
                    }
                });
            }
            return res;
        }

        private int getIndexByXY(int x, int y) {
            return y * this.width + x;
        }

        private class RowInfo {
            public int x_base;
            public int y;
            public int columnIndex;
            public int spaceWidth;

            public RowInfo(int row) {
                this.y = row % ColumnsCandidate.this.height;
                this.columnIndex = row / ColumnsCandidate.this.height;
                this.spaceWidth = (Integer)ColumnsCandidate.this.widths.get(this.columnIndex);
                this.x_base = IntStream.range(0, this.columnIndex).map(x -> (Integer)ColumnsCandidate.this.widths.get(x)).sum();
            }
        }
    }
}

