/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter.predefined;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import io.github.jsnimda.inventoryprofiles.sorter.ISortingMethodProvider;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemStack;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemType;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSlotsStats;
import io.github.jsnimda.inventoryprofiles.sorter.util.CodeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;

public class ShuffleSorter
implements ISortingMethodProvider {
    public int emptySpace;
    private Random random = new Random();

    private int[] randfixedsum(int n, int max, int sum) {
        if (sum > n * max) {
            throw new IllegalArgumentException("sum > n * max");
        }
        if (n == 1) {
            return new int[]{sum};
        }
        int a = n / 2;
        int b = n - a;
        int aMinSum = Math.max(0, sum - b * max);
        int aMaxSum = Math.min(sum, a * max);
        int aSum = this.randInc(aMinSum, aMaxSum);
        int[] aRes = this.randfixedsum(a, max, aSum);
        int[] bRes = this.randfixedsum(b, max, sum - aSum);
        return ArrayUtils.addAll((int[])aRes, (int[])bRes);
    }

    private int randInc(int min, int max) {
        return this.random.nextInt(max - min + 1) + min;
    }

    private int[] randfixedsum(List<Constraint> nums, int sum) {
        if (this.totalMin(nums) > sum || this.totalMax(nums) < sum) {
            throw new IllegalArgumentException("impossible sum");
        }
        if (nums.size() <= 0) {
            return new int[0];
        }
        if (nums.size() == 1) {
            return new int[]{sum};
        }
        List<Constraint> a = nums.subList(0, nums.size() / 2);
        List<Constraint> b = nums.subList(a.size(), nums.size());
        int aMinSum = Math.max(this.totalMin(a), sum - this.totalMax(b));
        int aMaxSum = Math.min(sum - this.totalMin(b), this.totalMax(a));
        int aSum = this.randInc(aMinSum, aMaxSum);
        int[] aRes = this.randfixedsum(a, aSum);
        int[] bRes = this.randfixedsum(b, sum - aSum);
        return ArrayUtils.addAll((int[])aRes, (int[])bRes);
    }

    private int totalMin(List<Constraint> e) {
        return e.stream().mapToInt(x -> x.min).sum();
    }

    private int totalMax(List<Constraint> e) {
        return e.stream().mapToInt(x -> x.max).sum();
    }

    public ShuffleSorter(int emptySpace) {
        this.emptySpace = emptySpace;
    }

    @Override
    public List<VirtualItemStack> sort(List<VirtualItemStack> items) {
        return new Calc(items).calc();
    }

    private class Calc {
        private List<VirtualItemStack> items;
        private VirtualSlotsStats stats;
        private int extra;
        private Multiset<VirtualItemType> stackCounts;

        public Calc(List<VirtualItemStack> items) {
            this.items = items;
        }

        public List<VirtualItemStack> calc() {
            this.init();
            this.spreadStackCounts();
            return this.spreadItemCounts();
        }

        private void init() {
            this.stats = new VirtualSlotsStats(this.items);
            int resTotalStackCount = this.stats.size - ShuffleSorter.this.emptySpace;
            if (this.stats.getMaxTotalStackCount() < resTotalStackCount) {
                resTotalStackCount = this.stats.getMaxTotalStackCount();
            } else if (this.stats.getMinTotalStackCount() > resTotalStackCount) {
                resTotalStackCount = this.stats.getMinTotalStackCount();
            }
            this.extra = resTotalStackCount - this.stats.getMinTotalStackCount();
        }

        private void spreadStackCounts() {
            this.stackCounts = HashMultiset.create();
            List<VirtualItemType> types = this.stats.getInfosAsList(x -> x.type);
            ArrayList<Constraint> r = new ArrayList<Constraint>();
            for (VirtualItemType type : types) {
                VirtualSlotsStats.ItemTypeStats info = this.stats.getInfos().get(type);
                r.add(new Constraint(info.stackCount, info.totalCount));
            }
            int[] counts = ShuffleSorter.this.randfixedsum(r, this.stats.getMinTotalStackCount() + this.extra);
            for (int i = 0; i < counts.length; ++i) {
                this.stackCounts.add((Object)types.get(i), counts[i]);
            }
        }

        private List<VirtualItemStack> spreadItemCounts() {
            ArrayList<VirtualItemStack> res = new ArrayList<VirtualItemStack>();
            for (VirtualItemType type : this.stats.getInfos().keySet()) {
                int[] counts;
                int total = this.stats.getInfos().get((Object)type).totalCount;
                int stack = this.stackCounts.count((Object)type);
                int max = type.getMaxCount();
                for (int count : counts = ShuffleSorter.this.randfixedsum(stack, max - 1, total - stack)) {
                    res.add(new VirtualItemStack(type, count + 1));
                }
            }
            return CodeUtils.pad(res, this.stats.size, () -> VirtualItemStack.empty());
        }
    }

    private static class Constraint {
        public int min;
        public int max;

        public Constraint(int min, int max) {
            this.min = min;
            this.max = max;
        }
    }
}

