/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter.util;

import io.github.jsnimda.inventoryprofiles.Log;
import io.github.jsnimda.inventoryprofiles.config.Configs;
import io.github.jsnimda.inventoryprofiles.sorter.BiVirtualSlots;
import io.github.jsnimda.inventoryprofiles.sorter.Click;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemStack;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemType;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSlot;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSlotsStats;
import io.github.jsnimda.inventoryprofiles.sorter.predefined.DistributeSorter;
import io.github.jsnimda.inventoryprofiles.sorter.util.CodeUtils;
import io.github.jsnimda.inventoryprofiles.sorter.util.ContainerCategory;
import io.github.jsnimda.inventoryprofiles.sorter.util.ContainerInfo;
import io.github.jsnimda.inventoryprofiles.sorter.util.ContainerUtils;
import io.github.jsnimda.inventoryprofiles.sorter.util.Converter;
import io.github.jsnimda.inventoryprofiles.sorter.util.Current;
import io.github.jsnimda.inventoryprofiles.sorter.util.CurrentState;
import io.github.jsnimda.inventoryprofiles.sorter.util.Getter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1704;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_437;
import net.minecraft.class_481;

public class ContainerActions {
    public static void cleanCursor() {
        ContainerActions.cleanCursor(true, true);
    }

    public static void cleanCursor(boolean putToContainer, boolean putToHotbar) {
        class_1799 cursorStack;
        if (Current.cursorStack().method_7960()) {
            return;
        }
        class_1735 focuesdSlot = Current.focusedSlot();
        if (ContainerUtils.getRemainingRoom(focuesdSlot, cursorStack = Current.cursorStack()) > 0) {
            ContainerActions.leftClick(Getter.slotId(focuesdSlot));
        }
        for (CleanCursorCandidateSlot cccs : CleanCursorCandidateSlot.gets(putToContainer, putToHotbar)) {
            if (Current.cursorStack().method_7960()) {
                return;
            }
            if (!cccs.suit(cursorStack)) continue;
            ContainerActions.leftClick(Getter.slotId(cccs.slot));
        }
    }

    public static void quickMoveByPlayerStorageSlotsFirst(int fromSlotId, boolean putToHotbar) {
        class_1735 slot = (class_1735)Current.container().field_7761.get(fromSlotId);
        if (slot.method_7677().method_7960()) {
            return;
        }
        boolean pickedUpFromSlot = false;
        for (CleanCursorCandidateSlot cccs : CleanCursorCandidateSlot.gets(false, putToHotbar)) {
            if (pickedUpFromSlot && Current.cursorStack().method_7960()) {
                return;
            }
            if (!cccs.suit(pickedUpFromSlot ? Current.cursorStack() : slot.method_7677())) continue;
            if (!pickedUpFromSlot) {
                pickedUpFromSlot = true;
                ContainerActions.leftClick(fromSlotId);
            }
            ContainerActions.leftClick(Getter.slotId(cccs.slot));
        }
        if (!Current.cursorStack().method_7960()) {
            ContainerActions.leftClick(fromSlotId);
        }
    }

    public static void cleanTempSlotsForClosing() {
        if (ContainerCategory.of(Current.container()).isStorage()) {
            return;
        }
        if (!(Current.container() instanceof class_1704)) {
            return;
        }
        if (Current.container().method_7611(0).method_7681()) {
            ContainerActions.shiftClick(Current.container(), 0);
        }
    }

    public static void restockHotbar() {
        ContainerInfo info = CurrentState.containerInfo();
        List<class_1735> source = info.playerStorageSlots;
        List<class_1735> target = Stream.concat(Stream.of(info.playerMainhandSlot, info.playerOffhandSlot), info.playerHotbarSlots.stream().filter(x -> x != info.playerMainhandSlot)).filter(x -> x != null).collect(Collectors.toList());
        List<VirtualSlot> aVS = Converter.toVirtualSlotList(source);
        List<VirtualSlot> bVS = Converter.toVirtualSlotList(target);
        List<VirtualSlot> from = Converter.concat(aVS, bVS, x -> x.copy());
        new BiVirtualSlots(aVS, bVS).restock();
        List<VirtualSlot> to = Converter.concat(aVS, bVS, x -> x.copy());
        ContainerActions.genericClicks(info.container, ContainerUtils.calcDiff(from, to), 0);
    }

    public static void evenlyDistributeCraftingSlots(boolean includeHotbar) {
        ContainerInfo info = CurrentState.containerInfo();
        ArrayList<class_1735> fromSlots = new ArrayList<class_1735>();
        fromSlots.addAll(info.playerStorageSlots);
        if (includeHotbar) {
            fromSlots.addAll(info.playerHotbarSlots);
        }
        List<VirtualSlot> aVS = Converter.toVirtualSlotList(fromSlots);
        List<VirtualSlot> bVS = Converter.toVirtualSlotList(info.craftingSlots);
        List<VirtualSlot> from = Converter.concat(aVS, bVS, x -> x.copy());
        new BiVirtualSlots(aVS, bVS).restock();
        VirtualSlot.bulkAction(bVS, x -> new DistributeSorter().sort((List<VirtualItemStack>)x));
        List<VirtualSlot> to = Converter.concat(aVS, bVS, x -> x.copy());
        ContainerActions.genericClicks(info.container, ContainerUtils.calcDiff(from, to), 0);
    }

    public static void moveAllAlike(boolean includeHotbar) {
        ContainerActions.moveAllAlike(Configs.ModSettings.SORT_AT_CURSOR.getBooleanValue() && ContainerUtils.cursorPointingPlayerInventory(), includeHotbar);
    }

    public static void moveAllAlike(boolean moveToPlayerInventory, boolean includeHotbar) {
        List<VirtualItemType> types;
        ContainerActions.cleanCursor();
        ContainerInfo info = CurrentState.containerInfo();
        if (info.category == ContainerCategory.CRAFTABLE_3x3 || info.category == ContainerCategory.PLAYER_SURVIVAL) {
            ContainerActions.evenlyDistributeCraftingSlots(includeHotbar);
            return;
        }
        if (info.storageSlots.isEmpty()) {
            return;
        }
        ArrayList<class_1735> checkSlots = new ArrayList<class_1735>();
        if (!moveToPlayerInventory) {
            types = new VirtualSlotsStats(Converter.toVirtualItemStackList(info.storageSlots)).getItemTypes();
            checkSlots.addAll(info.playerStorageSlots);
            if (includeHotbar) {
                checkSlots.addAll(info.playerHotbarSlots);
            }
        } else {
            checkSlots.addAll(info.storageSlots);
            ArrayList<class_1735> typeSlots = new ArrayList<class_1735>();
            typeSlots.addAll(info.playerStorageSlots);
            if (includeHotbar) {
                typeSlots.addAll(info.playerHotbarSlots);
            }
            types = new VirtualSlotsStats(Converter.toVirtualItemStackList(typeSlots)).getItemTypes();
            if (!Current.cursorStack().method_7960()) {
                ContainerActions.cleanCursor();
            }
        }
        block0: for (class_1735 s : checkSlots) {
            if (!s.method_7681()) continue;
            for (VirtualItemType t : types) {
                if (!Converter.toVirtualItemType(s.method_7677()).equals(t)) continue;
                if (!moveToPlayerInventory) {
                    ContainerActions.shiftClick(Current.container(), Getter.slotId(s));
                    continue block0;
                }
                ContainerActions.quickMoveByPlayerStorageSlotsFirst(Getter.slotId(s), includeHotbar);
                continue block0;
            }
        }
    }

    public static void leftClick(int slotId) {
        ContainerActions.leftClick(Current.container(), slotId);
    }

    public static void rightClick(int slotId) {
        ContainerActions.rightClick(Current.container(), slotId);
    }

    public static void leftClick(class_1703 container, int slotId) {
        ContainerActions.click(container, slotId, 0);
    }

    public static void rightClick(class_1703 container, int slotId) {
        ContainerActions.click(container, slotId, 1);
    }

    public static void shiftClick(class_1703 container, int slotId) {
        ContainerActions.genericClick(container, slotId, 0, class_1713.field_7794);
    }

    public static void click(class_1703 container, int slotId, int button) {
        ContainerActions.genericClick(container, slotId, button, class_1713.field_7790);
    }

    public static void genericClick(class_1703 container, int slotId, int button, class_1713 actionType) {
        if (container instanceof class_481.class_483) {
            Current.playerContainer().method_7593(slotId, button, actionType, (class_1657)Current.player());
            Current.playerContainer().method_7623();
            return;
        }
        Current.interactionManager().method_2906(container.field_7763, slotId, button, actionType, (class_1657)Current.player());
    }

    public static void genericClick(class_1703 container, Click click) {
        ContainerActions.genericClick(container, click.slotId, click.button, click.actionType);
    }

    public static void genericClicks(final class_1703 container, final List<Click> clicks, final int interval) {
        int lclick = 0;
        int rclick = 0;
        for (Click c : clicks) {
            lclick += c.button == 0 ? 1 : 0;
            rclick += c.button == 1 ? 1 : 0;
        }
        ContainerActions.logClicks(clicks.size(), lclick, rclick, interval);
        new Runnable(){
            class_437 currentScreen = Current.screen();

            @Override
            public void run() {
                CodeUtils.timedTasks(clicks, (c, timer) -> {
                    if (timer != null) {
                        if (container != Current.container()) {
                            timer.cancel();
                            Log.debugLogs("[inventoryprofiles] Click cancelled due to container changed");
                            return;
                        }
                        if (Configs.ModSettings.STOP_AT_SCREEN_CLOSE.getBooleanValue() && this.currentScreen != Current.screen()) {
                            if (this.currentScreen == null) {
                                this.currentScreen = Current.screen();
                            } else {
                                timer.cancel();
                                Log.debugLogs("[inventoryprofiles] Click cancelled due to screen closed");
                                return;
                            }
                        }
                    }
                    ContainerActions.genericClick(container, c);
                }, interval, () -> {});
            }
        }.run();
    }

    private static void logClicks(int total, int lclick, int rclick, int interval) {
        Log.debugLogs(String.format("[inventoryprofiles] Click count total %d. %d left. %d right. Time = %ss", total, lclick, rclick, (double)(total * interval) / 1000.0));
    }

    private static class CleanCursorCandidateSlot {
        public class_1735 slot;
        public boolean skipIfNoStack;

        public static List<CleanCursorCandidateSlot> gets(boolean putToContainer, boolean putToHotbar) {
            ArrayList<CleanCursorCandidateSlot> list = new ArrayList<CleanCursorCandidateSlot>();
            ContainerInfo info = CurrentState.containerInfo();
            if (putToHotbar) {
                list.add(CleanCursorCandidateSlot.alike(info.playerMainhandSlot));
            }
            if (info.playerOffhandSlot != null) {
                list.add(CleanCursorCandidateSlot.alike(info.playerOffhandSlot));
            }
            if (putToHotbar) {
                info.playerHotbarSlots.stream().filter(x -> x != info.playerMainhandSlot).forEach(x -> list.add(CleanCursorCandidateSlot.alike(x)));
            }
            info.playerStorageSlots.forEach(x -> list.add(CleanCursorCandidateSlot.alike(x)));
            info.playerStorageSlots.forEach(x -> list.add(CleanCursorCandidateSlot.empty(x)));
            if (putToHotbar) {
                info.playerHotbarSlots.forEach(x -> list.add(CleanCursorCandidateSlot.empty(x)));
            }
            if (info.playerOffhandSlot != null) {
                list.add(CleanCursorCandidateSlot.empty(info.playerOffhandSlot));
            }
            info.playerArmorSlots.forEach(x -> list.add(CleanCursorCandidateSlot.empty(x)));
            if (putToContainer) {
                info.storageSlots.forEach(x -> list.add(CleanCursorCandidateSlot.alike(x)));
                info.storageSlots.forEach(x -> list.add(CleanCursorCandidateSlot.empty(x)));
            }
            return list;
        }

        public boolean suit(class_1799 forItem) {
            if (this.skipIfNoStack && !this.slot.method_7681()) {
                return false;
            }
            return ContainerUtils.getRemainingRoom(this.slot, forItem) > 0;
        }

        public CleanCursorCandidateSlot(class_1735 slot, boolean skipIfNoStack) {
            this.slot = slot;
            this.skipIfNoStack = skipIfNoStack;
        }

        public static CleanCursorCandidateSlot alike(class_1735 slot) {
            return new CleanCursorCandidateSlot(slot, true);
        }

        public static CleanCursorCandidateSlot empty(class_1735 slot) {
            return new CleanCursorCandidateSlot(slot, false);
        }
    }
}

