/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.gui.widgets;

import io.github.jsnimda.common.a.a.d.a.r;
import io.github.jsnimda.common.a.a.d.b.j;
import io.github.jsnimda.common.a.a.g.b;
import io.github.jsnimda.common.gui.widget.AnchorStyles;
import io.github.jsnimda.common.gui.widget.Overflow;
import io.github.jsnimda.common.gui.widgets.ScrollableContainerWidget$$special$$inlined$apply$lambda$1;
import io.github.jsnimda.common.gui.widgets.ScrollableContainerWidget$Scrollbar;
import io.github.jsnimda.common.gui.widgets.ScrollableContainerWidget$_contentContainer$1;
import io.github.jsnimda.common.gui.widgets.ScrollableContainerWidget$contentCustomRendererDefault$1;
import io.github.jsnimda.common.gui.widgets.Widget;
import io.github.jsnimda.common.math2d.Rectangle;
import io.github.jsnimda.common.vanilla.render.RectKt;
import org.jetbrains.annotations.NotNull;

public final class ScrollableContainerWidget
extends Widget {
    private final int scrollbarWidth;
    private final int padding;
    @NotNull
    private final Widget viewport;
    private final ScrollableContainerWidget$_contentContainer$1 _contentContainer;
    @NotNull
    private final r contentCustomRendererDefault;
    @NotNull
    private r contentCustomRenderer;
    private boolean renderBorder;
    private int borderColor;
    @NotNull
    private final ScrollableContainerWidget$Scrollbar scrollbar;
    private boolean draggingScrollbar;
    private int draggingInitMouseY;
    private int draggingInitScrollbarY;

    @NotNull
    public final Widget getViewport() {
        return this.viewport;
    }

    @NotNull
    public final Widget getContentContainer() {
        return this._contentContainer;
    }

    @NotNull
    public final r getContentCustomRendererDefault() {
        return this.contentCustomRendererDefault;
    }

    @NotNull
    public final r getContentCustomRenderer() {
        return this.contentCustomRenderer;
    }

    public final void setContentCustomRenderer(@NotNull r r2) {
        j.b(r2, "<set-?>");
        this.contentCustomRenderer = r2;
    }

    public final int getContentHeight() {
        return this.getContentContainer().getHeight();
    }

    public final void setContentHeight(int n2) {
        this.getContentContainer().setHeight(n2);
    }

    public final int getScrollY() {
        return -this.getContentContainer().getTop();
    }

    public final void setScrollY(int n2) {
        this.getContentContainer().setTop(-b.a(n2, 0, this.getScrollYMax()));
    }

    public final int getScrollYMax() {
        return b.b(this.getContentHeight() - this.viewport.getHeight(), 0);
    }

    public final boolean getRenderBorder() {
        return this.renderBorder;
    }

    public final void setRenderBorder(boolean bl) {
        this.renderBorder = bl;
    }

    public final int getBorderColor() {
        return this.borderColor;
    }

    public final void setBorderColor(int n2) {
        this.borderColor = n2;
    }

    @NotNull
    public final ScrollableContainerWidget$Scrollbar getScrollbar() {
        return this.scrollbar;
    }

    private final int map(int n2, int n3, int n4) {
        if (n2 == 0) {
            return 0;
        }
        double d2 = 1.0 * (double)n4 * (double)n3 / (double)n2;
        if (Double.isNaN(d2)) {
            throw (Throwable)new IllegalArgumentException("Cannot round NaN value.");
        }
        if (d2 > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (d2 < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.round(d2);
    }

    @Override
    public final void render(int n2, int n3, float f2) {
        if (this.renderBorder) {
            RectKt.rDrawOutline(this.getAbsoluteBounds(), this.borderColor);
        }
        if (this.scrollbar.getVisible()) {
            RectKt.rFillRect(this.scrollbar.getTrackAbsoluteBounds(), Integer.MIN_VALUE);
            boolean bl = this.scrollbar.getThumbAbsoluteBounds().contains(n2, n3) || this.draggingScrollbar;
            RectKt.rFillRect(this.scrollbar.getThumbAbsoluteBounds(), bl ? -4144960 : -6776680);
            Rectangle rectangle = this.scrollbar.getThumbAbsoluteBounds();
            RectKt.rFillRect(Rectangle.copy$default(rectangle, 0, 0, rectangle.getWidth() - 1, rectangle.getHeight() - 1, 3, null), bl ? -1 : -2565928);
        }
        super.render(n2, n3, f2);
    }

    @Override
    public final boolean mouseClicked(int n2, int n3, int n4) {
        block7: {
            block6: {
                boolean bl;
                if (super.mouseClicked(n2, n3, n4)) break block6;
                if (n4 == 0 && this.scrollbar.getVisible() && this.scrollbar.getTrackAbsoluteBounds().contains(n2, n3)) {
                    if (!this.scrollbar.getThumbAbsoluteBounds().contains(n2, n3)) {
                        this.scrollbar.setY(n3 - this.viewport.getScreenY() - this.scrollbar.getThumbHeight() / 2);
                    }
                    this.draggingScrollbar = true;
                    this.draggingInitMouseY = n3;
                    this.draggingInitScrollbarY = this.scrollbar.getY();
                    bl = true;
                } else {
                    bl = false;
                }
                if (!bl) break block7;
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean mouseReleased(int n2, int n3, int n4) {
        this.draggingScrollbar = false;
        return false;
    }

    @Override
    public final boolean mouseDragged(double d2, double d3, int n2, double d4, double d5) {
        block6: {
            block5: {
                boolean bl;
                if (super.mouseDragged(d2, d3, n2, d4, d5)) break block5;
                if (this.draggingScrollbar) {
                    int n3 = (int)(d3 - (double)this.draggingInitMouseY);
                    this.scrollbar.setY(this.draggingInitScrollbarY + n3);
                    bl = true;
                } else {
                    bl = false;
                }
                if (!bl) break block6;
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean mouseScrolled(int n2, int n3, double d2) {
        block6: {
            block5: {
                boolean bl;
                if (super.mouseScrolled(n2, n3, d2)) break block5;
                if (this.scrollbar.getVisible()) {
                    ScrollableContainerWidget scrollableContainerWidget = this;
                    scrollableContainerWidget.setScrollY(scrollableContainerWidget.getScrollY() - (int)(d2 * 20.0));
                    bl = true;
                } else {
                    bl = false;
                }
                if (!bl) break block6;
            }
            return true;
        }
        return false;
    }

    public ScrollableContainerWidget() {
        Widget widget2;
        this.scrollbarWidth = 6;
        this.padding = 3;
        Widget widget3 = widget2 = new Widget();
        ScrollableContainerWidget scrollableContainerWidget = this;
        widget3.setOverflow(Overflow.HIDDEN);
        widget3.setAnchor(AnchorStyles.Companion.getAll());
        this.addChild(widget3);
        widget3.setTop(this.padding);
        widget3.setLeft(this.padding);
        widget3.setBottom(this.padding);
        widget3.setRight(this.padding + this.scrollbarWidth);
        scrollableContainerWidget.viewport = widget2;
        widget3 = widget2 = new ScrollableContainerWidget$_contentContainer$1(this);
        scrollableContainerWidget = this;
        widget3.setAnchor(AnchorStyles.Companion.getNoBottom());
        this.viewport.addChild(widget3);
        widget3.setTop(0);
        widget3.setLeft(0);
        widget3.setRight(0);
        widget3.getSizeChanged().plusAssign(new ScrollableContainerWidget$$special$$inlined$apply$lambda$1(this));
        scrollableContainerWidget._contentContainer = widget2;
        this.contentCustomRenderer = this.contentCustomRendererDefault = (r)new ScrollableContainerWidget$contentCustomRendererDefault$1(this);
        this.renderBorder = true;
        this.borderColor = -6710887;
        this.scrollbar = new ScrollableContainerWidget$Scrollbar(this);
    }

    public static final /* synthetic */ int access$map(ScrollableContainerWidget scrollableContainerWidget, int n2, int n3, int n4) {
        return scrollableContainerWidget.map(n2, n3, n4);
    }

    public static final /* synthetic */ int access$getScrollbarWidth$p(ScrollableContainerWidget scrollableContainerWidget) {
        return scrollableContainerWidget.scrollbarWidth;
    }

    public static final /* synthetic */ ScrollableContainerWidget$_contentContainer$1 access$get_contentContainer$p(ScrollableContainerWidget scrollableContainerWidget) {
        return scrollableContainerWidget._contentContainer;
    }
}

