/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.inventory.data;

import io.github.jsnimda.common.a.a.d.b.j;
import io.github.jsnimda.inventoryprofiles.inventory.data.ItemBucket;
import io.github.jsnimda.inventoryprofiles.item.ItemStack;
import io.github.jsnimda.inventoryprofiles.item.ItemType;
import io.github.jsnimda.inventoryprofiles.item.ItemTypeExtensionsKt;
import io.github.jsnimda.inventoryprofiles.util.MutableBucket;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class MutableItemBucket
extends MutableBucket
implements ItemBucket {
    protected final boolean validateEmpty(@NotNull ItemType itemType) {
        j.b(itemType, "element");
        return ItemTypeExtensionsKt.isEmpty(itemType);
    }

    public final boolean add(@NotNull ItemStack itemStack) {
        j.b(itemStack, "itemStack");
        return this.add(itemStack.getItemType(), itemStack.getCount());
    }

    public final void addAll(@NotNull List object) {
        j.b(object, "itemStacks");
        for (ItemStack itemStack : (Iterable)object) {
            this.add(itemStack);
        }
    }

    @Override
    public final boolean contains(@NotNull ItemStack itemStack) {
        j.b(itemStack, "itemStack");
        return this.contains(itemStack.getItemType(), itemStack.getCount());
    }

    @Override
    public final boolean containsAll(@NotNull List object) {
        j.b(object, "itemStacks");
        object = (Iterable)object;
        if (!(object instanceof Collection) || !((Collection)object).isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                ItemStack itemStack = (ItemStack)object.next();
                if (this.contains(itemStack)) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean remove(@NotNull ItemStack itemStack) {
        j.b(itemStack, "itemStack");
        return this.remove(itemStack.getItemType(), itemStack.getCount());
    }

    public final void removeAll(@NotNull List object) {
        j.b(object, "itemStacks");
        for (ItemStack itemStack : (Iterable)object) {
            this.remove(itemStack);
        }
    }

    @Override
    @NotNull
    public final ItemBucket minus(@NotNull ItemBucket itemBucket) {
        j.b(itemBucket, "another");
        MutableItemBucket mutableItemBucket = this.copyAsMutable();
        mutableItemBucket.removeAll(itemBucket);
        return mutableItemBucket;
    }

    @Override
    @NotNull
    public final ItemBucket copy() {
        return this.copyAsMutable();
    }

    @Override
    @NotNull
    public final MutableItemBucket copyAsMutable() {
        return new MutableItemBucket(this.getAsMap());
    }

    private MutableItemBucket(Map map) {
        super(map);
    }

    public MutableItemBucket() {
    }
}

