/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.forge;

import io.github.jsnimda.common.event.GlobalInitHandler;
import io.github.jsnimda.common.input.GlobalInputHandler;
import io.github.jsnimda.common.vanilla.Vanilla;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonForgeEventHandler {
    boolean initialized = false;

    @SubscribeEvent
    public void onKeyboardInput(InputEvent.KeyInputEvent keyInputEvent) {
        if (Vanilla.INSTANCE.screen() == null) {
            GlobalInputHandler.INSTANCE.onKey(keyInputEvent.getKey(), keyInputEvent.getScanCode(), keyInputEvent.getAction(), keyInputEvent.getModifiers());
        }
    }

    @SubscribeEvent
    public void onKey1(GuiScreenEvent.KeyboardKeyPressedEvent.Pre pre) {
        Screen screen = Vanilla.INSTANCE.screen();
        GlobalInputHandler.INSTANCE.onKey(pre.getKeyCode(), pre.getScanCode(), 1, pre.getModifiers());
        if (screen != Vanilla.INSTANCE.screen() && pre.isCancelable()) {
            pre.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onKey0(GuiScreenEvent.KeyboardKeyReleasedEvent.Pre pre) {
        Screen screen = Vanilla.INSTANCE.screen();
        GlobalInputHandler.INSTANCE.onKey(pre.getKeyCode(), pre.getScanCode(), 0, pre.getModifiers());
        if (screen != Vanilla.INSTANCE.screen() && pre.isCancelable()) {
            pre.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onMouseInputEvent(InputEvent.MouseInputEvent mouseInputEvent) {
        GlobalInputHandler.INSTANCE.onMouseButton(mouseInputEvent.getButton(), mouseInputEvent.getAction(), mouseInputEvent.getMods());
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load load) {
        GlobalInputHandler.INSTANCE.getPressedKeys().clear();
    }

    @SubscribeEvent
    public void clientClick(TickEvent.ClientTickEvent clientTickEvent) {
        if (clientTickEvent.phase == TickEvent.Phase.START && !this.initialized) {
            this.initialized = true;
            GlobalInitHandler.INSTANCE.onInit();
        }
    }
}

