/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.item;

import io.github.jsnimda.common.a.a.a.d;
import io.github.jsnimda.common.a.a.d.b.j;
import io.github.jsnimda.common.a.a.f;
import io.github.jsnimda.common.vanilla.alias.I18n;
import io.github.jsnimda.inventoryprofiles.ingame.VanillaAccessorsKt;
import io.github.jsnimda.inventoryprofiles.item.ItemType;
import io.github.jsnimda.inventoryprofiles.item.ItemType$Companion;
import io.github.jsnimda.inventoryprofiles.item.PotionEffect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.BucketItem;
import net.minecraft.item.FishBucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MilkBucketItem;
import net.minecraft.item.SoupItem;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ItemTypeExtensionsKt {
    @NotNull
    public static final String toNamespacedString(@NotNull ItemType itemType) {
        j.b(itemType, "$this$toNamespacedString");
        StringBuilder stringBuilder = new StringBuilder().append(ItemTypeExtensionsKt.getItemId(itemType));
        Object object = itemType.getTag();
        if (object == null) {
            object = "";
        }
        return stringBuilder.append(object).toString();
    }

    @NotNull
    public static final ItemType getEMPTY(@NotNull ItemType$Companion itemType$Companion) {
        j.b(itemType$Companion, "$this$EMPTY");
        Item item2 = Items.field_190931_a;
        j.a((Object)item2, "Items.AIR");
        return new ItemType(item2, null);
    }

    public static final boolean isEmpty(@NotNull ItemType itemType) {
        j.b(itemType, "$this$isEmpty");
        return j.a((Object)itemType.getItem(), Items.field_190931_a);
    }

    public static final int getMaxCount(@NotNull ItemType itemType) {
        j.b(itemType, "$this$maxCount");
        return ItemTypeExtensionsKt.getVanillaStack(itemType).func_77976_d();
    }

    @NotNull
    public static final ItemStack getVanillaStack(@NotNull ItemType itemType) {
        j.b(itemType, "$this$vanillaStack");
        ItemStack itemStack = new ItemStack((IItemProvider)itemType.getItem());
        itemStack.func_77982_d(itemType.getTag());
        return itemStack;
    }

    @NotNull
    public static final ItemStack vanillaStackWithCount(@NotNull ItemType itemType, int n2) {
        j.b(itemType, "$this$vanillaStackWithCount");
        ItemStack itemStack = new ItemStack((IItemProvider)itemType.getItem(), n2);
        itemStack.func_77982_d(itemType.getTag());
        return itemStack;
    }

    @NotNull
    public static final ResourceLocation getIdentifier(@NotNull ItemType itemType) {
        j.b(itemType, "$this$identifier");
        DefaultedRegistry defaultedRegistry = Registry.field_212630_s;
        j.a((Object)defaultedRegistry, "Registry.ITEM");
        return VanillaAccessorsKt.(getIdentifier)(defaultedRegistry, (Object)itemType.getItem());
    }

    @NotNull
    public static final String getNamespace(@NotNull ItemType itemType) {
        j.b(itemType, "$this$namespace");
        String string = ItemTypeExtensionsKt.getIdentifier(itemType).func_110624_b();
        j.a((Object)string, "identifier.namespace");
        return string;
    }

    public static final boolean getHasCustomName(@NotNull ItemType itemType) {
        j.b(itemType, "$this$hasCustomName");
        return ItemTypeExtensionsKt.getVanillaStack(itemType).func_82837_s();
    }

    @NotNull
    public static final String getCustomName(@NotNull ItemType itemType) {
        j.b(itemType, "$this$customName");
        if (ItemTypeExtensionsKt.getHasCustomName(itemType)) {
            return ItemTypeExtensionsKt.getDisplayName(itemType);
        }
        return "";
    }

    @NotNull
    public static final String getDisplayName(@NotNull ItemType itemType) {
        j.b(itemType, "$this$displayName");
        ITextComponent iTextComponent = ItemTypeExtensionsKt.getVanillaStack(itemType).func_200301_q();
        j.a((Object)iTextComponent, "vanillaStack.displayName");
        String string = iTextComponent.getString();
        j.a((Object)string, "vanillaStack.displayName.string");
        return string;
    }

    @NotNull
    public static final String getTranslatedName(@NotNull ItemType itemType) {
        j.b(itemType, "$this$translatedName");
        return I18n.INSTANCE.translate(ItemTypeExtensionsKt.getTranslationKey(itemType), new Object[0]);
    }

    @NotNull
    public static final String getItemId(@NotNull ItemType itemType) {
        j.b(itemType, "$this$itemId");
        String string = ItemTypeExtensionsKt.getIdentifier(itemType).toString();
        j.a((Object)string, "identifier.toString()");
        return string;
    }

    @NotNull
    public static final String getTranslationKey(@NotNull ItemType itemType) {
        j.b(itemType, "$this$translationKey");
        String string = ItemTypeExtensionsKt.getVanillaStack(itemType).func_77977_a();
        j.a((Object)string, "vanillaStack.translationKey");
        return string;
    }

    public static final int getGroupIndex(@NotNull ItemType itemType) {
        j.b(itemType, "$this$groupIndex");
        ItemGroup itemGroup = itemType.getItem().func_77640_w();
        if (itemGroup != null) {
            return itemGroup.func_78021_a();
        }
        if (itemType.getItem() == Items.field_151134_bR) {
            ItemGroup itemGroup2 = ItemGroup.field_78040_i;
            j.a((Object)itemGroup2, "ItemGroup.TOOLS");
            return itemGroup2.func_78021_a();
        }
        if (j.a((Object)ItemTypeExtensionsKt.getNamespace(itemType), (Object)"minecraft")) {
            ItemGroup itemGroup3 = ItemGroup.field_78026_f;
            j.a((Object)itemGroup3, "ItemGroup.MISC");
            return itemGroup3.func_78021_a();
        }
        return ItemGroup.field_78032_a.length;
    }

    public static final int getRawId(@NotNull ItemType itemType) {
        j.b(itemType, "$this$rawId");
        DefaultedRegistry defaultedRegistry = Registry.field_212630_s;
        j.a((Object)defaultedRegistry, "Registry.ITEM");
        return VanillaAccessorsKt.(getRawId)(defaultedRegistry, (Object)itemType.getItem());
    }

    public static final int getDamage(@NotNull ItemType itemType) {
        j.b(itemType, "$this$damage");
        return ItemTypeExtensionsKt.getVanillaStack(itemType).func_77952_i();
    }

    public static final double getEnchantmentsScore(@NotNull ItemType iterator) {
        j.b(iterator, "$this$enchantmentsScore");
        Map map = EnchantmentHelper.func_82781_a((ItemStack)ItemTypeExtensionsKt.getVanillaStack((ItemType)((Object)iterator)));
        j.a((Object)map, "EnchantmentHelper.getEnchantments(vanillaStack)");
        iterator = d.a(map);
        double d2 = 0.0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            object = (f)object;
            double d3 = d2;
            Enchantment enchantment = (Enchantment)((f)object).c();
            object = (Integer)((f)object).d();
            Enchantment enchantment2 = enchantment;
            j.a((Object)enchantment2, "enchantment");
            d2 = d3 + (enchantment2.func_190936_d() ? -0.001 : (double)((Integer)object).intValue() / (double)enchantment.func_77325_b());
        }
        return d2;
    }

    public static final boolean isDamageable(@NotNull ItemType itemType) {
        j.b(itemType, "$this$isDamageable");
        return ItemTypeExtensionsKt.getVanillaStack(itemType).func_77984_f();
    }

    public static final int getMaxDamage(@NotNull ItemType itemType) {
        j.b(itemType, "$this$maxDamage");
        return ItemTypeExtensionsKt.getVanillaStack(itemType).func_77958_k();
    }

    public static final int getDurability(@NotNull ItemType itemType) {
        j.b(itemType, "$this$durability");
        return ItemTypeExtensionsKt.getMaxDamage(itemType) - ItemTypeExtensionsKt.getDamage(itemType);
    }

    public static final boolean isBucket(@NotNull ItemType itemType) {
        j.b(itemType, "$this$isBucket");
        return itemType.getItem() instanceof BucketItem || itemType.getItem() instanceof MilkBucketItem || itemType.getItem() instanceof FishBucketItem;
    }

    public static final boolean isStew(@NotNull ItemType itemType) {
        j.b(itemType, "$this$isStew");
        return itemType.getItem() instanceof SoupItem || itemType.getItem() instanceof SuspiciousStewItem;
    }

    public static final boolean getHasPotionName(@NotNull ItemType itemType) {
        j.b(itemType, "$this$hasPotionName");
        CompoundNBT compoundNBT = itemType.getTag();
        if (compoundNBT != null) {
            return compoundNBT.func_150297_b("Potion", 8);
        }
        return false;
    }

    @NotNull
    public static final String getPotionName(@NotNull ItemType itemType) {
        j.b(itemType, "$this$potionName");
        if (ItemTypeExtensionsKt.getHasPotionName(itemType)) {
            String string = PotionUtils.func_185187_c((CompoundNBT)itemType.getTag()).func_185174_b("");
            j.a((Object)string, "PotionUtil.getPotionType\u2026(tag).getNamePrefixed(\"\")");
            return string;
        }
        return "";
    }

    public static final boolean getHasPotionEffects(@NotNull ItemType itemType) {
        j.b(itemType, "$this$hasPotionEffects");
        List list3 = PotionUtils.func_185185_a((CompoundNBT)itemType.getTag());
        j.a((Object)list3, "PotionUtil.getEffectsFromTag(tag)");
        return !((Collection)list3).isEmpty();
    }

    public static final boolean getHasCustomPotionEffects(@NotNull ItemType itemType) {
        j.b(itemType, "$this$hasCustomPotionEffects");
        List list3 = PotionUtils.func_185192_b((CompoundNBT)itemType.getTag());
        j.a((Object)list3, "PotionUtil.getFullEffectsFromTag(tag)");
        return !((Collection)list3).isEmpty();
    }

    @NotNull
    public static final List getPotionEffects(@NotNull ItemType itemType) {
        j.b(itemType, "$this$potionEffects");
        List list3 = PotionUtils.func_185185_a((CompoundNBT)itemType.getTag());
        j.a((Object)list3, "PotionUtil.getEffectsFromTag(tag)");
        return list3;
    }

    @NotNull
    public static final List getComparablePotionEffects(@NotNull ItemType object) {
        j.b(object, "$this$comparablePotionEffects");
        Object object2 = object = (Iterable)ItemTypeExtensionsKt.getPotionEffects((ItemType)object);
        object = new ArrayList(d.a((Iterable)object, 10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            object3 = (EffectInstance)object3;
            Object object4 = object;
            object3 = ItemTypeExtensionsKt.get(asComparable)(object3);
            object4.add(object3);
        }
        return (List)object;
    }

    @NotNull
    public static final PotionEffect get(asComparable)(@NotNull EffectInstance effectInstance) {
        j.b(effectInstance, "$this$_u28asComparable_u29");
        Registry registry = Registry.field_212631_t;
        j.a((Object)registry, "Registry.EFFECTS");
        return new PotionEffect(String.valueOf(VanillaAccessorsKt.(getIdentifier)(registry, (Object)effectInstance.func_188419_a())), effectInstance.func_76458_c(), effectInstance.func_76459_b());
    }
}

