/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.math2d;

import io.github.jsnimda.common.a.a.d.b.j;
import io.github.jsnimda.common.math2d.Line;
import io.github.jsnimda.common.math2d.LineKt;
import io.github.jsnimda.common.math2d.Point;
import io.github.jsnimda.common.math2d.Rectangle;
import io.github.jsnimda.common.math2d.Size;
import org.jetbrains.annotations.NotNull;

public final class Rect2dKt {
    @NotNull
    public static final Size toSize(@NotNull Point point) {
        j.b(point, "$this$toSize");
        return new Size(point.getX(), point.getY());
    }

    @NotNull
    public static final Point transpose(@NotNull Point point) {
        j.b(point, "$this$transpose");
        return new Point(point.getY(), point.getX());
    }

    @NotNull
    public static final Point toPoint(@NotNull Size size) {
        j.b(size, "$this$toPoint");
        return new Point(size.getWidth(), size.getHeight());
    }

    @NotNull
    public static final Size transpose(@NotNull Size size) {
        j.b(size, "$this$transpose");
        return new Size(size.getHeight(), size.getWidth());
    }

    @NotNull
    public static final Rectangle intersect(@NotNull Rectangle rectangle, @NotNull Rectangle rectangle2) {
        j.b(rectangle, "$this$intersect");
        j.b(rectangle2, "other");
        Line line = LineKt.getDiagonal(Rect2dKt.normalize(rectangle));
        int n2 = line.component1();
        int n3 = line.component2();
        int n4 = line.component3();
        int n5 = line.component4();
        Line line2 = LineKt.getDiagonal(Rect2dKt.normalize(rectangle2));
        int n6 = line2.component1();
        int n7 = line2.component2();
        int n8 = line2.component3();
        int n9 = line2.component4();
        int n10 = Math.max(n2, n6);
        n2 = Math.max(n3, n7);
        n7 = Math.min(n4, n8);
        n3 = Math.min(n5, n9);
        return Rect2dKt.positiveOrEmpty(LineKt.toRectangle(new Line(n10, n2, n7, n3)));
    }

    @NotNull
    public static final Rectangle positiveOrEmpty(@NotNull Rectangle rectangle) {
        j.b(rectangle, "$this$positiveOrEmpty");
        if (rectangle.getWidth() > 0 && rectangle.getHeight() > 0) {
            return rectangle;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    private static final Rectangle normalizeWidth(@NotNull Rectangle rectangle) {
        if (rectangle.getWidth() >= 0) {
            return rectangle;
        }
        return new Rectangle(rectangle.getX() + rectangle.getWidth(), rectangle.getY(), -rectangle.getWidth(), rectangle.getHeight());
    }

    private static final Rectangle normalizeHeight(@NotNull Rectangle rectangle) {
        if (rectangle.getHeight() >= 0) {
            return rectangle;
        }
        return new Rectangle(rectangle.getX(), rectangle.getY() + rectangle.getHeight(), rectangle.getWidth(), -rectangle.getHeight());
    }

    @NotNull
    public static final Rectangle normalize(@NotNull Rectangle rectangle) {
        j.b(rectangle, "$this$normalize");
        return Rect2dKt.normalizeHeight(Rect2dKt.normalizeWidth(rectangle));
    }
}

