/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.math2d;

import io.github.jsnimda.common.a.a.d.b.j;
import io.github.jsnimda.common.math2d.Point;
import io.github.jsnimda.common.math2d.Size;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Rectangle {
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public final int getLeft() {
        return this.x;
    }

    public final int getTop() {
        return this.y;
    }

    public final int getRight() {
        return this.x + this.width;
    }

    public final int getBottom() {
        return this.y + this.height;
    }

    @NotNull
    public final Point getTopLeft() {
        return new Point(this.getLeft(), this.getTop());
    }

    @NotNull
    public final Point getTopRight() {
        return new Point(this.getRight(), this.getTop());
    }

    @NotNull
    public final Point getBottomLeft() {
        return new Point(this.getLeft(), this.getBottom());
    }

    @NotNull
    public final Point getBottomRight() {
        return new Point(this.getRight(), this.getBottom());
    }

    @NotNull
    public final Point getLocation() {
        return new Point(this.x, this.y);
    }

    @NotNull
    public final Size getSize() {
        return new Size(this.width, this.height);
    }

    @NotNull
    public final Rectangle copy(@NotNull Point point, @NotNull Size size) {
        j.b(point, "location");
        j.b(size, "size");
        return new Rectangle(point, size);
    }

    public static /* synthetic */ Rectangle copy$default(Rectangle rectangle, Point point, Size size, int n2, Object object) {
        if ((n2 & 1) != 0) {
            point = rectangle.getLocation();
        }
        if ((n2 & 2) != 0) {
            size = rectangle.getSize();
        }
        return rectangle.copy(point, size);
    }

    @NotNull
    public final Rectangle inflated(int n2) {
        return new Rectangle(this.x - n2, this.y - n2, this.width + (n2 << 1), this.height + (n2 << 1));
    }

    public final boolean contains(@NotNull Point point) {
        j.b(point, "point");
        return this.contains(point.getX(), point.getY());
    }

    public final boolean contains(int n2, int n3) {
        return this.getLeft() <= n2 && this.getRight() > n2 && this.getTop() <= n3 && this.getBottom() > n3;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public Rectangle(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    public Rectangle(@NotNull Point point, @NotNull Size size) {
        j.b(point, "location");
        j.b(size, "size");
        this(point.getX(), point.getY(), size.getWidth(), size.getHeight());
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    public final int component3() {
        return this.width;
    }

    public final int component4() {
        return this.height;
    }

    @NotNull
    public final Rectangle copy(int n2, int n3, int n4, int n5) {
        return new Rectangle(n2, n3, n4, n5);
    }

    public static /* synthetic */ Rectangle copy$default(Rectangle rectangle, int n2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 1) != 0) {
            n2 = rectangle.x;
        }
        if ((n6 & 2) != 0) {
            n3 = rectangle.y;
        }
        if ((n6 & 4) != 0) {
            n4 = rectangle.width;
        }
        if ((n6 & 8) != 0) {
            n5 = rectangle.height;
        }
        return rectangle.copy(n2, n3, n4, n5);
    }

    @NotNull
    public final String toString() {
        return "Rectangle(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ")";
    }

    public final int hashCode() {
        return ((Integer.hashCode(this.x) * 31 + Integer.hashCode(this.y)) * 31 + Integer.hashCode(this.width)) * 31 + Integer.hashCode(this.height);
    }

    public final boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Rectangle)) break block3;
                object = (Rectangle)object;
                if (this.x != ((Rectangle)object).x || this.y != ((Rectangle)object).y || this.width != ((Rectangle)object).width || this.height != ((Rectangle)object).height) break block3;
            }
            return true;
        }
        return false;
    }
}

