/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.vanilla;

import io.github.jsnimda.common.a.a.d.b.j;
import io.github.jsnimda.common.util.ExtIOKt;
import io.github.jsnimda.common.vanilla.Vanilla;
import io.github.jsnimda.common.vanilla.render.ScreenKt;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.Language;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VanillaUtil {
    private static int lastMouseX;
    private static int lastMouseY;
    private static int mouseX;
    private static int mouseY;
    public static final VanillaUtil INSTANCE;

    public final boolean isOnClientThread() {
        return Vanilla.INSTANCE.mc().func_213162_bc();
    }

    public final boolean inGame() {
        return Vanilla.INSTANCE.worldNullable() != null && Vanilla.INSTANCE.playerNullable() != null;
    }

    @NotNull
    public final String languageCode() {
        Language language = Vanilla.INSTANCE.languageManager().func_135041_c();
        j.a((Object)language, "Vanilla.languageManager().currentLanguage");
        String string = language.getCode();
        j.a((Object)string, "Vanilla.languageManager().currentLanguage.code");
        return string;
    }

    public final boolean shiftDown() {
        return Screen.hasShiftDown();
    }

    public final boolean ctrlDown() {
        return Screen.hasControlDown();
    }

    public final boolean altDown() {
        return Screen.hasAltDown();
    }

    public final int mouseX() {
        return (int)(Vanilla.INSTANCE.mouse().func_198024_e() * (double)ScreenKt.getRScreenWidth() / (double)Vanilla.INSTANCE.window().func_198105_m());
    }

    public final int mouseY() {
        return (int)(Vanilla.INSTANCE.mouse().func_198026_f() * (double)ScreenKt.getRScreenHeight() / (double)Vanilla.INSTANCE.window().func_198083_n());
    }

    public final float lastFrameDuration() {
        return Vanilla.INSTANCE.mc().func_193989_ak();
    }

    public final int getLastMouseX() {
        return lastMouseX;
    }

    public final int getLastMouseY() {
        return lastMouseY;
    }

    public final int getMouseX() {
        return mouseX;
    }

    public final int getMouseY() {
        return mouseY;
    }

    public final void updateMouse() {
        lastMouseX = mouseX;
        lastMouseY = mouseY;
        mouseX = this.mouseX();
        mouseY = this.mouseY();
    }

    public final void closeScreen() {
        Vanilla.INSTANCE.mc().func_147108_a(null);
    }

    public final void openScreen(@NotNull Screen screen) {
        j.b(screen, "screen");
        Vanilla.INSTANCE.mc().func_147108_a(screen);
    }

    public final void openScreenNullable(@Nullable Screen screen) {
        Vanilla.INSTANCE.mc().func_147108_a(screen);
    }

    public final void openDistinctScreen(@NotNull Screen screen) {
        j.b(screen, "screen");
        Screen screen2 = Vanilla.INSTANCE.screen();
        if (j.a(screen2 != null ? screen2.getClass() : null, screen.getClass()) ^ true) {
            this.openScreen(screen);
        }
    }

    public final void openDistinctScreenQuiet(@NotNull Screen screen) {
        j.b(screen, "screen");
        Screen screen2 = Vanilla.INSTANCE.screen();
        if (j.a(screen2 != null ? screen2.getClass() : null, screen.getClass()) ^ true) {
            Vanilla.INSTANCE.mc().field_71462_r = null;
            this.openScreen(screen);
        }
    }

    private final Path runDirectory() {
        Path path = Vanilla.INSTANCE.runDirectoryFile().toPath().normalize();
        j.a((Object)path, "Vanilla.runDirectoryFile().toPath().normalize()");
        return path;
    }

    @NotNull
    public final Path configDirectory() {
        return ExtIOKt.div(this.runDirectory(), "config");
    }

    @NotNull
    public final Path configDirectory(@NotNull String object) {
        j.b(object, "modName");
        object = ExtIOKt.div(this.configDirectory(), (String)object);
        ExtIOKt.createDirectories((Path)object);
        return object;
    }

    @Nullable
    public final String getResourceAsString(@NotNull String string) {
        j.b(string, "identifier");
        try {
            IResource iResource = Vanilla.INSTANCE.resourceManager().func_199002_a(new ResourceLocation(string));
            j.a((Object)iResource, "Vanilla.resourceManager(\u2026e(Identifier(identifier))");
            InputStream inputStream = iResource.func_199027_b();
            string = inputStream != null ? ExtIOKt.readToString(inputStream) : null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            string = null;
        }
        return string;
    }

    @NotNull
    public final String loggingString(@NotNull Path path) {
        j.b(path, "path");
        return ((Object)(path.isAbsolute() ? ExtIOKt.pathFrom(path, ExtIOKt.div(this.runDirectory(), "..")) : path)).toString();
    }

    public final void open(@NotNull File file2) {
        j.b(file2, "file");
        Util.func_110647_a().func_195641_a(file2);
    }

    private VanillaUtil() {
    }

    static {
        INSTANCE = new VanillaUtil();
        lastMouseX = -1;
        lastMouseY = -1;
        mouseX = -1;
        mouseY = -1;
    }
}

