/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.inventory.sandbox;

import io.github.jsnimda.common.a.a.d.b.f;
import io.github.jsnimda.common.a.a.d.b.j;
import io.github.jsnimda.inventoryprofiles.inventory.data.ItemTracker;
import io.github.jsnimda.inventoryprofiles.inventory.data.MutableItemTracker;
import io.github.jsnimda.inventoryprofiles.inventory.sandbox.SandboxClick;
import io.github.jsnimda.inventoryprofiles.item.ItemStackExtensionsKt;
import io.github.jsnimda.inventoryprofiles.item.MutableItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContainerSandbox {
    private final MutableItemTracker mutableItems;
    @Nullable
    private SandboxClick clickNode;

    @NotNull
    public final ItemTracker getItems() {
        return this.mutableItems;
    }

    public final void leftClick(int n2) {
        MutableItemTracker mutableItemTracker = this.mutableItems;
        MutableItemStack mutableItemStack = (MutableItemStack)mutableItemTracker.getSlots().get(n2);
        if (ItemStackExtensionsKt.isEmpty(mutableItemTracker.getCursor()) || ItemStackExtensionsKt.isEmpty(mutableItemStack) || !ItemStackExtensionsKt.stackableWith(mutableItemTracker.getCursor(), mutableItemStack)) {
            ItemStackExtensionsKt.swapWith(mutableItemTracker.getCursor(), mutableItemStack);
        } else {
            ItemStackExtensionsKt.transferTo(mutableItemTracker.getCursor(), mutableItemStack);
        }
        this.addClick(n2, 0);
    }

    public final void rightClick(int n2) {
        MutableItemTracker mutableItemTracker = this.mutableItems;
        MutableItemStack mutableItemStack = (MutableItemStack)mutableItemTracker.getSlots().get(n2);
        if (ItemStackExtensionsKt.isEmpty(mutableItemTracker.getCursor())) {
            ItemStackExtensionsKt.splitHalfTo(mutableItemStack, mutableItemTracker.getCursor());
        } else if (ItemStackExtensionsKt.stackableWith(mutableItemTracker.getCursor(), mutableItemStack)) {
            ItemStackExtensionsKt.transferOneTo(mutableItemTracker.getCursor(), mutableItemStack);
        } else {
            ItemStackExtensionsKt.swapWith(mutableItemTracker.getCursor(), mutableItemStack);
        }
        this.addClick(n2, 1);
    }

    public final void leftClickOutside() {
        MutableItemTracker mutableItemTracker = this.mutableItems;
        mutableItemTracker.getThrownItems().add(mutableItemTracker.getCursor());
        ItemStackExtensionsKt.setEmpty(mutableItemTracker.getCursor());
        this.addClick(-999, 0);
    }

    public final void rightClickOutside() {
        MutableItemTracker mutableItemTracker = this.mutableItems;
        MutableItemStack mutableItemStack = ItemStackExtensionsKt.empty(MutableItemStack.Companion);
        ItemStackExtensionsKt.transferOneTo(mutableItemTracker.getCursor(), mutableItemStack);
        mutableItemTracker.getThrownItems().add(mutableItemStack);
        this.addClick(-999, 1);
    }

    public final int getClickCount() {
        SandboxClick sandboxClick = this.clickNode;
        if (sandboxClick != null) {
            return sandboxClick.getClickIndex() + 1;
        }
        return 0;
    }

    @Nullable
    public final SandboxClick getClickNode() {
        return this.clickNode;
    }

    private final void addClick(int n2, int n3) {
        SandboxClick sandboxClick;
        this.clickNode = sandboxClick = new SandboxClick(this.getClickCount(), n2, n3, this.clickNode);
    }

    public ContainerSandbox(@NotNull MutableItemTracker mutableItemTracker, @Nullable SandboxClick sandboxClick) {
        j.b(mutableItemTracker, "items");
        this.mutableItems = mutableItemTracker;
        this.clickNode = sandboxClick;
    }

    public /* synthetic */ ContainerSandbox(MutableItemTracker mutableItemTracker, SandboxClick sandboxClick, int n2, f f2) {
        if ((n2 & 2) != 0) {
            sandboxClick = null;
        }
        this(mutableItemTracker, sandboxClick);
    }
}

