/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.parser;

import io.github.jsnimda.common.Log;
import io.github.jsnimda.common.a.a.a.d;
import io.github.jsnimda.common.util.ExtIOKt;
import io.github.jsnimda.common.vanilla.VanillaUtil;
import io.github.jsnimda.common.vanilla.VanillaUtilKt;
import io.github.jsnimda.inventoryprofiles.item.rule.file.RuleFile;
import io.github.jsnimda.inventoryprofiles.item.rule.file.RuleFileRegister;
import io.github.jsnimda.inventoryprofiles.parser.CustomDataFileLoaderKt;
import io.github.jsnimda.inventoryprofiles.parser.Loader;
import io.github.jsnimda.inventoryprofiles.parser.TemporaryRuleParser;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class RuleLoader
implements Loader {
    @NotNull
    public static final String internalFileDisplayName = "<internal rules.txt>";
    private static final String regex = "^rules\\.(?:.*\\.)?txt$";
    public static final RuleLoader INSTANCE = new RuleLoader();

    private final String getInternalRulesTxtContent() {
        String string = VanillaUtil.INSTANCE.getResourceAsString("inventoryprofiles:config/rules.txt");
        if (string == null) {
            String string2 = "";
            Log.INSTANCE.error("Failed to load in-jar file inventoryprofiles:config/rules.txt");
            string = string2;
        }
        return string;
    }

    @Override
    public final void reload() {
        Log.INSTANCE.clearIndent();
        Log.INSTANCE.trace("[-] Rule reloading...");
        Iterable iterable2 = CustomDataFileLoaderKt.getFiles(regex);
        List list3 = d.b(new RuleFile[]{new RuleFile(internalFileDisplayName, this.getInternalRulesTxtContent())});
        for (Iterable iterable2 : iterable2) {
            try {
                Log.INSTANCE.trace("    Trying to read file " + ExtIOKt.getName((Path)iterable2));
                String string = ExtIOKt.readFileToString((Path)iterable2);
                list3.add(new RuleFile(ExtIOKt.getName((Path)iterable2), string));
            }
            catch (Exception exception) {
                Log.INSTANCE.error("Failed to read file " + VanillaUtilKt.getLoggingPath((Path)iterable2));
            }
        }
        Log.INSTANCE.trace("[-] Total " + list3.size() + " rule files (including <internal>)");
        RuleFileRegister.INSTANCE.reloadRuleFiles(list3);
        Log.INSTANCE.trace("Rule reload end");
        TemporaryRuleParser.INSTANCE.onReload();
    }

    private RuleLoader() {
    }
}

