/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.config.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.github.jsnimda.common.Log;
import io.github.jsnimda.common.Savable;
import io.github.jsnimda.common.a.a.d.b.j;
import io.github.jsnimda.common.config.IConfigElement;
import io.github.jsnimda.common.util.ExtGsonKt;
import io.github.jsnimda.common.util.ExtIOKt;
import io.github.jsnimda.common.vanilla.VanillaUtil;
import io.github.jsnimda.common.vanilla.VanillaUtilKt;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class ConfigSaveLoadManager
implements Savable {
    private final Path configFile;
    private final String path;
    private final IConfigElement config;

    @Override
    public final void save() {
        try {
            ExtIOKt.writeToFile(ExtGsonKt.toJsonString(this.config.toJsonElement()), this.configFile);
            return;
        }
        catch (IOException iOException) {
            Log.INSTANCE.error("Failed to write config file " + this.path);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    @Override
    public final void load() {
        try {
            if (!ExtIOKt.exists(this.configFile)) {
                return;
            }
            JsonElement jsonElement = ExtGsonKt.parseAsJson(ExtIOKt.readFileToString(this.configFile));
            this.config.fromJsonElement(jsonElement);
            return;
        }
        catch (IOException iOException) {
            Log.INSTANCE.error("Failed to read config file " + this.path);
            return;
        }
        catch (JsonParseException jsonParseException) {
            Log.INSTANCE.error("Failed to parse config file " + this.path + " as JSON");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public ConfigSaveLoadManager(@NotNull IConfigElement iConfigElement, @NotNull String string) {
        j.b(iConfigElement, "config");
        j.b(string, "path");
        this.config = iConfigElement;
        this.configFile = ExtIOKt.div(VanillaUtil.INSTANCE.configDirectory(), string);
        this.path = VanillaUtilKt.getLoggingPath(this.configFile);
    }
}

