/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.input;

import io.github.jsnimda.common.IInputHandler;
import io.github.jsnimda.common.a.a.a.d;
import io.github.jsnimda.common.a.a.a.l;
import io.github.jsnimda.common.a.a.d.b.j;
import io.github.jsnimda.common.gui.debug.DebugInfos;
import io.github.jsnimda.common.input.IKeybind;
import io.github.jsnimda.common.input.KeybindSettings;
import io.github.jsnimda.common.vanilla.Vanilla;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GlobalInputHandler {
    @NotNull
    private static final Set pressedKeys;
    @NotNull
    private static Set previousPressedKeys;
    private static int lastKey;
    private static int lastAction;
    @Nullable
    private static IKeybind currentAssigningKeybind;
    private static boolean pressedFirstKey;
    private static boolean ignoreLeftClick;
    private static final Set registered;
    public static final GlobalInputHandler INSTANCE;

    @NotNull
    public final Set getPressedKeys() {
        return pressedKeys;
    }

    @NotNull
    public final Set getPreviousPressedKeys() {
        return previousPressedKeys;
    }

    public final int getLastKey() {
        return lastKey;
    }

    public final int getLastAction() {
        return lastAction;
    }

    public final boolean isActivated(@NotNull List list3, @NotNull KeybindSettings object) {
        j.b(list3, "keyCodes");
        j.b(object, "settings");
        if (list3.isEmpty()) {
            return false;
        }
        if (!((KeybindSettings)object).getActivateOn().isValid(lastAction)) {
            return false;
        }
        if (!((KeybindSettings)object).getContext().isValid(Vanilla.INSTANCE.screen())) {
            return false;
        }
        Set set = lastAction == 1 ? pressedKeys : previousPressedKeys;
        if (set.size() >= list3.size() && (((KeybindSettings)object).getAllowExtraKeys() || set.size() == list3.size())) {
            boolean bl;
            if (((KeybindSettings)object).getOrderSensitive()) {
                List list4;
                int n2 = list3.size();
                object = d.g(set);
                j.b(object, "$this$takeLast");
                if (!(n2 >= 0)) {
                    String string = "Requested element count " + n2 + " is less than zero.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                if (n2 == 0) {
                    list4 = l.a;
                } else {
                    int n3 = object.size();
                    if (n2 >= n3) {
                        list4 = d.g((Iterable)object);
                    } else if (n2 == 1) {
                        list4 = d.a(d.i((List)object));
                    } else {
                        ArrayList arrayList = new ArrayList(n2);
                        if (object instanceof RandomAccess) {
                            for (n2 = n3 - n2; n2 < n3; ++n2) {
                                arrayList.add(object.get(n2));
                            }
                        } else {
                            object = object.listIterator(n3 - n2);
                            while (object.hasNext()) {
                                Object e2 = object.next();
                                arrayList.add(e2);
                            }
                        }
                        list4 = arrayList;
                    }
                }
                bl = j.a((Object)list4, list3);
            } else {
                bl = list3.contains(lastKey) && set.containsAll(list3);
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    private final boolean onKey(int n2, int n3) {
        boolean bl = n3 == 1;
        if (bl == pressedKeys.contains(n2)) {
            return false;
        }
        previousPressedKeys = d.i(pressedKeys);
        if (bl) {
            pressedKeys.add(n2);
        } else {
            pressedKeys.remove(n2);
        }
        lastKey = n2;
        lastAction = n3;
        return this.onInput();
    }

    private final boolean onInput() {
        if (currentAssigningKeybind != null) {
            this.handleAssignKeybind();
            return true;
        }
        Iterator iterator = ((Iterable)registered).iterator();
        while (iterator.hasNext()) {
            ((IInputHandler)iterator.next()).onInput(lastKey, lastAction);
        }
        return false;
    }

    @Nullable
    public final IKeybind getCurrentAssigningKeybind() {
        return currentAssigningKeybind;
    }

    public final void setCurrentAssigningKeybind(@Nullable IKeybind iKeybind) {
        pressedFirstKey = false;
        ignoreLeftClick = true;
        currentAssigningKeybind = iKeybind;
    }

    private final void handleAssignKeybind() {
        if (lastAction == 1) {
            if (lastKey == -100 && ignoreLeftClick) {
                return;
            }
            pressedFirstKey = true;
            if (lastKey == 256) {
                IKeybind iKeybind = currentAssigningKeybind;
                if (iKeybind != null) {
                    iKeybind.setKeyCodes(l.a);
                }
                this.setCurrentAssigningKeybind(null);
                return;
            }
            IKeybind iKeybind = currentAssigningKeybind;
            if (iKeybind != null) {
                iKeybind.setKeyCodes(d.g(pressedKeys));
                return;
            }
            return;
        }
        if (lastKey == -100) {
            ignoreLeftClick = false;
        }
        if (pressedKeys.isEmpty() && pressedFirstKey) {
            this.setCurrentAssigningKeybind(null);
        }
    }

    public final boolean onKey(int n2, int n3, int n4, int n5) {
        DebugInfos.INSTANCE.onKey(n2, n3, n4, n5);
        switch (n4) {
            case 0: 
            case 1: {
                return this.onKey(n2, n4);
            }
        }
        return false;
    }

    public final boolean onMouseButton(int n2, int n3, int n4) {
        DebugInfos.INSTANCE.onMouseButton(n2, n3, n4);
        switch (n3) {
            case 0: 
            case 1: {
                return this.onKey(n2 - 100, n3);
            }
        }
        return false;
    }

    public final boolean register(@NotNull IInputHandler iInputHandler) {
        j.b(iInputHandler, "inputHandler");
        return registered.add(iInputHandler);
    }

    public final boolean unregister(@NotNull IInputHandler iInputHandler) {
        j.b(iInputHandler, "inputHandler");
        return registered.remove(iInputHandler);
    }

    private GlobalInputHandler() {
    }

    static {
        INSTANCE = new GlobalInputHandler();
        pressedKeys = new LinkedHashSet();
        previousPressedKeys = d.i(pressedKeys);
        lastKey = -1;
        lastAction = -1;
        registered = new LinkedHashSet();
    }
}

