/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.input;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.jsnimda.common.Log;
import io.github.jsnimda.common.a.a.d.b.j;
import io.github.jsnimda.common.config.IConfigElementObject$DefaultImpls;
import io.github.jsnimda.common.input.ConfigKeybindSettings;
import io.github.jsnimda.common.input.GlobalInputHandler;
import io.github.jsnimda.common.input.IKeybind;
import io.github.jsnimda.common.input.KeybindSettings;
import org.jetbrains.annotations.NotNull;

public final class IKeybind$DefaultImpls {
    public static boolean isActivated(IKeybind iKeybind) {
        return GlobalInputHandler.INSTANCE.isActivated(iKeybind.getKeyCodes(), iKeybind.getSettings());
    }

    @NotNull
    public static String getDisplayText(IKeybind iKeybind) {
        return IKeybind.Companion.getDisplayText(iKeybind.getKeyCodes());
    }

    public static boolean isKeyCodesModified(IKeybind iKeybind) {
        return j.a((Object)iKeybind.getDefaultKeyCodes(), iKeybind.getKeyCodes()) ^ true;
    }

    public static boolean isSettingsModified(IKeybind iKeybind) {
        return j.a((Object)iKeybind.getDefaultSettings(), iKeybind.getSettings()) ^ true;
    }

    public static boolean isModified(IKeybind iKeybind) {
        return iKeybind.isKeyCodesModified() || iKeybind.isSettingsModified();
    }

    public static void resetKeyCodesToDefault(IKeybind iKeybind) {
        IKeybind iKeybind2 = iKeybind;
        iKeybind2.setKeyCodes(iKeybind2.getDefaultKeyCodes());
    }

    public static void resetSettingsToDefault(IKeybind iKeybind) {
        IKeybind iKeybind2 = iKeybind;
        iKeybind2.setSettings(iKeybind2.getDefaultSettings());
    }

    public static void resetToDefault(IKeybind iKeybind) {
        iKeybind.resetKeyCodesToDefault();
        iKeybind.resetSettingsToDefault();
    }

    @NotNull
    public static JsonObject toJsonElement(IKeybind iKeybind) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = jsonObject = new JsonObject();
        if (iKeybind.isKeyCodesModified()) {
            jsonObject2.addProperty("keys", IKeybind.Companion.getStorageString(iKeybind.getKeyCodes()));
        }
        if (iKeybind.isSettingsModified()) {
            IKeybind iKeybind2 = iKeybind;
            jsonObject2.add("settings", (JsonElement)iKeybind2.toJsonElement(iKeybind2.getSettings()));
        }
        return jsonObject;
    }

    public static void fromJsonObject(IKeybind iKeybind, @NotNull JsonObject jsonObject) {
        j.b(jsonObject, "obj");
        try {
            JsonElement jsonElement;
            JsonElement jsonElement2 = jsonObject.get("settings");
            if (jsonElement2 != null) {
                jsonElement = jsonElement2;
                IKeybind iKeybind2 = iKeybind;
                iKeybind2.setSettings(iKeybind2.fromJsonElement(iKeybind.getSettings(), jsonElement));
            }
            JsonElement jsonElement3 = jsonObject.get("keys");
            if (jsonElement3 != null) {
                jsonElement = jsonElement3;
                String string = jsonElement.getAsString();
                j.a((Object)string, "it.asString");
                iKeybind.setKeyCodes(IKeybind.Companion.getKeyCodes(string));
                return;
            }
            return;
        }
        catch (Exception exception) {
            Log.INSTANCE.warn("Failed to set config value for 'keys' from the JSON element '" + jsonObject.get("keys") + '\'');
            return;
        }
    }

    @NotNull
    public static ConfigKeybindSettings toConfigElement(IKeybind iKeybind, @NotNull KeybindSettings keybindSettings) {
        j.b(keybindSettings, "$this$toConfigElement");
        return new ConfigKeybindSettings(iKeybind.getDefaultSettings(), keybindSettings);
    }

    @NotNull
    public static JsonObject toJsonElement(IKeybind iKeybind, @NotNull KeybindSettings keybindSettings) {
        j.b(keybindSettings, "$this$toJsonElement");
        return iKeybind.toConfigElement(keybindSettings).toJsonElement();
    }

    @NotNull
    public static KeybindSettings fromJsonElement(IKeybind iConfigElementObject, @NotNull KeybindSettings keybindSettings, @NotNull JsonElement jsonElement) {
        j.b(keybindSettings, "$this$fromJsonElement");
        j.b(jsonElement, "element");
        iConfigElementObject = iConfigElementObject.toConfigElement(keybindSettings);
        ((ConfigKeybindSettings)iConfigElementObject).fromJsonElement(jsonElement);
        return ((ConfigKeybindSettings)iConfigElementObject).getSettings();
    }

    public static void fromJsonElement(IKeybind iKeybind, @NotNull JsonElement jsonElement) {
        j.b(jsonElement, "element");
        IConfigElementObject$DefaultImpls.fromJsonElement(iKeybind, jsonElement);
    }
}

