/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.common.input;

import io.github.jsnimda.common.a.a.d.b.j;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class KeyCodes {
    public static final int KEY_UNKNOWN = -1;
    public static final int KEY_SPACE = 32;
    public static final int KEY_APOSTROPHE = 39;
    public static final int KEY_COMMA = 44;
    public static final int KEY_MINUS = 45;
    public static final int KEY_PERIOD = 46;
    public static final int KEY_SLASH = 47;
    public static final int KEY_0 = 48;
    public static final int KEY_1 = 49;
    public static final int KEY_2 = 50;
    public static final int KEY_3 = 51;
    public static final int KEY_4 = 52;
    public static final int KEY_5 = 53;
    public static final int KEY_6 = 54;
    public static final int KEY_7 = 55;
    public static final int KEY_8 = 56;
    public static final int KEY_9 = 57;
    public static final int KEY_SEMICOLON = 59;
    public static final int KEY_EQUAL = 61;
    public static final int KEY_A = 65;
    public static final int KEY_B = 66;
    public static final int KEY_C = 67;
    public static final int KEY_D = 68;
    public static final int KEY_E = 69;
    public static final int KEY_F = 70;
    public static final int KEY_G = 71;
    public static final int KEY_H = 72;
    public static final int KEY_I = 73;
    public static final int KEY_J = 74;
    public static final int KEY_K = 75;
    public static final int KEY_L = 76;
    public static final int KEY_M = 77;
    public static final int KEY_N = 78;
    public static final int KEY_O = 79;
    public static final int KEY_P = 80;
    public static final int KEY_Q = 81;
    public static final int KEY_R = 82;
    public static final int KEY_S = 83;
    public static final int KEY_T = 84;
    public static final int KEY_U = 85;
    public static final int KEY_V = 86;
    public static final int KEY_W = 87;
    public static final int KEY_X = 88;
    public static final int KEY_Y = 89;
    public static final int KEY_Z = 90;
    public static final int KEY_LEFT_BRACKET = 91;
    public static final int KEY_BACKSLASH = 92;
    public static final int KEY_RIGHT_BRACKET = 93;
    public static final int KEY_GRAVE_ACCENT = 96;
    public static final int KEY_WORLD_1 = 161;
    public static final int KEY_WORLD_2 = 162;
    public static final int KEY_ESCAPE = 256;
    public static final int KEY_ENTER = 257;
    public static final int KEY_TAB = 258;
    public static final int KEY_BACKSPACE = 259;
    public static final int KEY_INSERT = 260;
    public static final int KEY_DELETE = 261;
    public static final int KEY_RIGHT = 262;
    public static final int KEY_LEFT = 263;
    public static final int KEY_DOWN = 264;
    public static final int KEY_UP = 265;
    public static final int KEY_PAGE_UP = 266;
    public static final int KEY_PAGE_DOWN = 267;
    public static final int KEY_HOME = 268;
    public static final int KEY_END = 269;
    public static final int KEY_CAPS_LOCK = 280;
    public static final int KEY_SCROLL_LOCK = 281;
    public static final int KEY_NUM_LOCK = 282;
    public static final int KEY_PRINT_SCREEN = 283;
    public static final int KEY_PAUSE = 284;
    public static final int KEY_F1 = 290;
    public static final int KEY_F2 = 291;
    public static final int KEY_F3 = 292;
    public static final int KEY_F4 = 293;
    public static final int KEY_F5 = 294;
    public static final int KEY_F6 = 295;
    public static final int KEY_F7 = 296;
    public static final int KEY_F8 = 297;
    public static final int KEY_F9 = 298;
    public static final int KEY_F10 = 299;
    public static final int KEY_F11 = 300;
    public static final int KEY_F12 = 301;
    public static final int KEY_F13 = 302;
    public static final int KEY_F14 = 303;
    public static final int KEY_F15 = 304;
    public static final int KEY_F16 = 305;
    public static final int KEY_F17 = 306;
    public static final int KEY_F18 = 307;
    public static final int KEY_F19 = 308;
    public static final int KEY_F20 = 309;
    public static final int KEY_F21 = 310;
    public static final int KEY_F22 = 311;
    public static final int KEY_F23 = 312;
    public static final int KEY_F24 = 313;
    public static final int KEY_F25 = 314;
    public static final int KEY_KP_0 = 320;
    public static final int KEY_KP_1 = 321;
    public static final int KEY_KP_2 = 322;
    public static final int KEY_KP_3 = 323;
    public static final int KEY_KP_4 = 324;
    public static final int KEY_KP_5 = 325;
    public static final int KEY_KP_6 = 326;
    public static final int KEY_KP_7 = 327;
    public static final int KEY_KP_8 = 328;
    public static final int KEY_KP_9 = 329;
    public static final int KEY_KP_DECIMAL = 330;
    public static final int KEY_KP_DIVIDE = 331;
    public static final int KEY_KP_MULTIPLY = 332;
    public static final int KEY_KP_SUBTRACT = 333;
    public static final int KEY_KP_ADD = 334;
    public static final int KEY_KP_ENTER = 335;
    public static final int KEY_KP_EQUAL = 336;
    public static final int KEY_LEFT_SHIFT = 340;
    public static final int KEY_LEFT_CONTROL = 341;
    public static final int KEY_LEFT_ALT = 342;
    public static final int KEY_LEFT_SUPER = 343;
    public static final int KEY_RIGHT_SHIFT = 344;
    public static final int KEY_RIGHT_CONTROL = 345;
    public static final int KEY_RIGHT_ALT = 346;
    public static final int KEY_RIGHT_SUPER = 347;
    public static final int KEY_MENU = 348;
    public static final int KEY_LAST = 348;
    public static final int MOUSE_BUTTON_1 = -100;
    public static final int MOUSE_BUTTON_2 = -99;
    public static final int MOUSE_BUTTON_3 = -98;
    public static final int MOUSE_BUTTON_4 = -97;
    public static final int MOUSE_BUTTON_5 = -96;
    public static final int MOUSE_BUTTON_6 = -95;
    public static final int MOUSE_BUTTON_7 = -94;
    public static final int MOUSE_BUTTON_8 = -93;
    private static final Map MAP_KEY_CODE_TO_NAME;
    private static final Map MAP_NAME_TO_KEY_CODE;
    private static final Map MAP_NAME_TO_DISPLAY_TEXT;
    public static final KeyCodes INSTANCE;

    @NotNull
    public final String getName(int n2) {
        return MAP_KEY_CODE_TO_NAME.getOrDefault(n2, "keycode ".concat(String.valueOf(n2)));
    }

    public final int getKeyCode(@NotNull String string) {
        j.b(string, "name");
        return ((Number)MAP_NAME_TO_KEY_CODE.getOrDefault(string, -1)).intValue();
    }

    @NotNull
    public final String getFriendlyName(@NotNull String string) {
        j.b(string, "name");
        String string2 = string;
        return MAP_NAME_TO_DISPLAY_TEXT.getOrDefault(string2, string2);
    }

    @NotNull
    public final String getFriendlyName(int n2) {
        KeyCodes keyCodes = this;
        return keyCodes.getFriendlyName(keyCodes.getName(n2));
    }

    private final void addEntry(String string, String string2, int n2) {
        Object object;
        Map map = MAP_KEY_CODE_TO_NAME;
        Integer n3 = n2;
        if (map.get(n3) == null) {
            object = string;
            map.put(n3, object);
        }
        if ((map = MAP_NAME_TO_KEY_CODE).get(string) == null) {
            object = n2;
            map.put(string, object);
        }
        if ((map = MAP_NAME_TO_DISPLAY_TEXT).get(string) == null) {
            object = string2;
            string2 = object == null || object.length() == 0 ? string : string2;
            map.put(string, string2);
        }
    }

    private KeyCodes() {
    }

    static {
        KeyCodes keyCodes;
        INSTANCE = keyCodes = new KeyCodes();
        MAP_KEY_CODE_TO_NAME = new LinkedHashMap();
        MAP_NAME_TO_KEY_CODE = new LinkedHashMap();
        MAP_NAME_TO_DISPLAY_TEXT = new LinkedHashMap();
        keyCodes.addEntry("UNKNOWN", null, -1);
        keyCodes.addEntry("SPACE", "Space", 32);
        keyCodes.addEntry("APOSTROPHE", "'", 39);
        keyCodes.addEntry("COMMA", ",", 44);
        keyCodes.addEntry("MINUS", "-", 45);
        keyCodes.addEntry("PERIOD", ".", 46);
        keyCodes.addEntry("SLASH", "/", 47);
        keyCodes.addEntry("0", "0", 48);
        keyCodes.addEntry("1", "1", 49);
        keyCodes.addEntry("2", "2", 50);
        keyCodes.addEntry("3", "3", 51);
        keyCodes.addEntry("4", "4", 52);
        keyCodes.addEntry("5", "5", 53);
        keyCodes.addEntry("6", "6", 54);
        keyCodes.addEntry("7", "7", 55);
        keyCodes.addEntry("8", "8", 56);
        keyCodes.addEntry("9", "9", 57);
        keyCodes.addEntry("SEMICOLON", ";", 59);
        keyCodes.addEntry("EQUAL", "=", 61);
        keyCodes.addEntry("A", "a", 65);
        keyCodes.addEntry("B", "b", 66);
        keyCodes.addEntry("C", "c", 67);
        keyCodes.addEntry("D", "d", 68);
        keyCodes.addEntry("E", "e", 69);
        keyCodes.addEntry("F", "f", 70);
        keyCodes.addEntry("G", "g", 71);
        keyCodes.addEntry("H", "h", 72);
        keyCodes.addEntry("I", "i", 73);
        keyCodes.addEntry("J", "j", 74);
        keyCodes.addEntry("K", "k", 75);
        keyCodes.addEntry("L", "l", 76);
        keyCodes.addEntry("M", "m", 77);
        keyCodes.addEntry("N", "n", 78);
        keyCodes.addEntry("O", "o", 79);
        keyCodes.addEntry("P", "p", 80);
        keyCodes.addEntry("Q", "q", 81);
        keyCodes.addEntry("R", "r", 82);
        keyCodes.addEntry("S", "s", 83);
        keyCodes.addEntry("T", "t", 84);
        keyCodes.addEntry("U", "u", 85);
        keyCodes.addEntry("V", "v", 86);
        keyCodes.addEntry("W", "w", 87);
        keyCodes.addEntry("X", "x", 88);
        keyCodes.addEntry("Y", "y", 89);
        keyCodes.addEntry("Z", "z", 90);
        keyCodes.addEntry("LEFT_BRACKET", "[", 91);
        keyCodes.addEntry("BACKSLASH", "\\", 92);
        keyCodes.addEntry("RIGHT_BRACKET", "]", 93);
        keyCodes.addEntry("GRAVE_ACCENT", "`", 96);
        keyCodes.addEntry("WORLD_1", null, 161);
        keyCodes.addEntry("WORLD_2", null, 162);
        keyCodes.addEntry("ESCAPE", "Esc", 256);
        keyCodes.addEntry("ENTER", "Enter", 257);
        keyCodes.addEntry("TAB", "Tab", 258);
        keyCodes.addEntry("BACKSPACE", "Backspace", 259);
        keyCodes.addEntry("INSERT", "Insert", 260);
        keyCodes.addEntry("DELETE", "Delete", 261);
        keyCodes.addEntry("RIGHT", "Right", 262);
        keyCodes.addEntry("LEFT", "Left", 263);
        keyCodes.addEntry("DOWN", "Down", 264);
        keyCodes.addEntry("UP", "Up", 265);
        keyCodes.addEntry("PAGE_UP", "Page Up", 266);
        keyCodes.addEntry("PAGE_DOWN", "Page Down", 267);
        keyCodes.addEntry("HOME", "Home", 268);
        keyCodes.addEntry("END", "End", 269);
        keyCodes.addEntry("CAPS_LOCK", "Caps Lock", 280);
        keyCodes.addEntry("SCROLL_LOCK", "Scroll Lock", 281);
        keyCodes.addEntry("NUM_LOCK", "Num Lock", 282);
        keyCodes.addEntry("PRINT_SCREEN", "Print Screen", 283);
        keyCodes.addEntry("PAUSE", "Pause", 284);
        keyCodes.addEntry("F1", "F1", 290);
        keyCodes.addEntry("F2", "F2", 291);
        keyCodes.addEntry("F3", "F3", 292);
        keyCodes.addEntry("F4", "F4", 293);
        keyCodes.addEntry("F5", "F5", 294);
        keyCodes.addEntry("F6", "F6", 295);
        keyCodes.addEntry("F7", "F7", 296);
        keyCodes.addEntry("F8", "F8", 297);
        keyCodes.addEntry("F9", "F9", 298);
        keyCodes.addEntry("F10", "F10", 299);
        keyCodes.addEntry("F11", "F11", 300);
        keyCodes.addEntry("F12", "F12", 301);
        keyCodes.addEntry("F13", null, 302);
        keyCodes.addEntry("F14", null, 303);
        keyCodes.addEntry("F15", null, 304);
        keyCodes.addEntry("F16", null, 305);
        keyCodes.addEntry("F17", null, 306);
        keyCodes.addEntry("F18", null, 307);
        keyCodes.addEntry("F19", null, 308);
        keyCodes.addEntry("F20", null, 309);
        keyCodes.addEntry("F21", null, 310);
        keyCodes.addEntry("F22", null, 311);
        keyCodes.addEntry("F23", null, 312);
        keyCodes.addEntry("F24", null, 313);
        keyCodes.addEntry("F25", null, 314);
        keyCodes.addEntry("KP_0", "Numpad 0", 320);
        keyCodes.addEntry("KP_1", "Numpad 1", 321);
        keyCodes.addEntry("KP_2", "Numpad 2", 322);
        keyCodes.addEntry("KP_3", "Numpad 3", 323);
        keyCodes.addEntry("KP_4", "Numpad 4", 324);
        keyCodes.addEntry("KP_5", "Numpad 5", 325);
        keyCodes.addEntry("KP_6", "Numpad 6", 326);
        keyCodes.addEntry("KP_7", "Numpad 7", 327);
        keyCodes.addEntry("KP_8", "Numpad 8", 328);
        keyCodes.addEntry("KP_9", "Numpad 9", 329);
        keyCodes.addEntry("KP_DECIMAL", "Numpad .", 330);
        keyCodes.addEntry("KP_DIVIDE", "Numpad /", 331);
        keyCodes.addEntry("KP_MULTIPLY", "Numpad *", 332);
        keyCodes.addEntry("KP_SUBTRACT", "Numpad -", 333);
        keyCodes.addEntry("KP_ADD", "Numpad +", 334);
        keyCodes.addEntry("KP_ENTER", "Numpad Enter", 335);
        keyCodes.addEntry("KP_EQUAL", null, 336);
        keyCodes.addEntry("LEFT_SHIFT", "Left Shift", 340);
        keyCodes.addEntry("LEFT_CONTROL", "Left Ctrl", 341);
        keyCodes.addEntry("LEFT_ALT", "Left Alt", 342);
        keyCodes.addEntry("LEFT_SUPER", "Left Win", 343);
        keyCodes.addEntry("RIGHT_SHIFT", "Right Shift", 344);
        keyCodes.addEntry("RIGHT_CONTROL", "Right Ctrl", 345);
        keyCodes.addEntry("RIGHT_ALT", "Right Alt", 346);
        keyCodes.addEntry("RIGHT_SUPER", "Right Win", 347);
        keyCodes.addEntry("MENU", "Menu", 348);
        keyCodes.addEntry("LAST", null, 348);
        keyCodes.addEntry("BUTTON_1", "Left Button", -100);
        keyCodes.addEntry("BUTTON_2", "Right Button", -99);
        keyCodes.addEntry("BUTTON_3", "Middle Button", -98);
        keyCodes.addEntry("BUTTON_4", "Back Button", -97);
        keyCodes.addEntry("BUTTON_5", "Forward Button", -96);
        keyCodes.addEntry("BUTTON_6", null, -95);
        keyCodes.addEntry("BUTTON_7", null, -94);
        keyCodes.addEntry("BUTTON_8", null, -93);
    }
}

